/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.jms.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.jms.model.KeySizeAlgorithm;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class MinimumKeySizeSettings
extends ExplicitlySetBmcModel {
    @JsonProperty(value="tls")
    private final List<KeySizeAlgorithm> tls;
    @JsonProperty(value="jar")
    private final List<KeySizeAlgorithm> jar;
    @JsonProperty(value="certpath")
    private final List<KeySizeAlgorithm> certpath;

    @Deprecated
    @ConstructorProperties(value={"tls", "jar", "certpath"})
    public MinimumKeySizeSettings(List<KeySizeAlgorithm> tls, List<KeySizeAlgorithm> jar, List<KeySizeAlgorithm> certpath) {
        this.tls = tls;
        this.jar = jar;
        this.certpath = certpath;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public List<KeySizeAlgorithm> getTls() {
        return this.tls;
    }

    public List<KeySizeAlgorithm> getJar() {
        return this.jar;
    }

    public List<KeySizeAlgorithm> getCertpath() {
        return this.certpath;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("MinimumKeySizeSettings(");
        sb.append("super=").append(super.toString());
        sb.append("tls=").append(String.valueOf(this.tls));
        sb.append(", jar=").append(String.valueOf(this.jar));
        sb.append(", certpath=").append(String.valueOf(this.certpath));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MinimumKeySizeSettings)) {
            return false;
        }
        MinimumKeySizeSettings other = (MinimumKeySizeSettings)((Object)o);
        return Objects.equals(this.tls, other.tls) && Objects.equals(this.jar, other.jar) && Objects.equals(this.certpath, other.certpath) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.tls == null ? 43 : this.tls.hashCode());
        result = result * 59 + (this.jar == null ? 43 : this.jar.hashCode());
        result = result * 59 + (this.certpath == null ? 43 : this.certpath.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="tls")
        private List<KeySizeAlgorithm> tls;
        @JsonProperty(value="jar")
        private List<KeySizeAlgorithm> jar;
        @JsonProperty(value="certpath")
        private List<KeySizeAlgorithm> certpath;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder tls(List<KeySizeAlgorithm> tls) {
            this.tls = tls;
            this.__explicitlySet__.add("tls");
            return this;
        }

        public Builder jar(List<KeySizeAlgorithm> jar) {
            this.jar = jar;
            this.__explicitlySet__.add("jar");
            return this;
        }

        public Builder certpath(List<KeySizeAlgorithm> certpath) {
            this.certpath = certpath;
            this.__explicitlySet__.add("certpath");
            return this;
        }

        public MinimumKeySizeSettings build() {
            MinimumKeySizeSettings model = new MinimumKeySizeSettings(this.tls, this.jar, this.certpath);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(MinimumKeySizeSettings model) {
            if (model.wasPropertyExplicitlySet("tls")) {
                this.tls(model.getTls());
            }
            if (model.wasPropertyExplicitlySet("jar")) {
                this.jar(model.getJar());
            }
            if (model.wasPropertyExplicitlySet("certpath")) {
                this.certpath(model.getCertpath());
            }
            return this;
        }
    }
}

