/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.jms.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.jms.model.ArtifactContentType;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class NewInstallationSite
extends ExplicitlySetBmcModel {
    @JsonProperty(value="managedInstanceId")
    private final String managedInstanceId;
    @JsonProperty(value="releaseVersion")
    private final String releaseVersion;
    @JsonProperty(value="artifactContentType")
    private final ArtifactContentType artifactContentType;
    @JsonProperty(value="installationPath")
    private final String installationPath;
    @JsonProperty(value="headlessMode")
    private final Boolean headlessMode;
    @JsonProperty(value="forceInstall")
    private final Boolean forceInstall;

    @Deprecated
    @ConstructorProperties(value={"managedInstanceId", "releaseVersion", "artifactContentType", "installationPath", "headlessMode", "forceInstall"})
    public NewInstallationSite(String managedInstanceId, String releaseVersion, ArtifactContentType artifactContentType, String installationPath, Boolean headlessMode, Boolean forceInstall) {
        this.managedInstanceId = managedInstanceId;
        this.releaseVersion = releaseVersion;
        this.artifactContentType = artifactContentType;
        this.installationPath = installationPath;
        this.headlessMode = headlessMode;
        this.forceInstall = forceInstall;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getManagedInstanceId() {
        return this.managedInstanceId;
    }

    public String getReleaseVersion() {
        return this.releaseVersion;
    }

    public ArtifactContentType getArtifactContentType() {
        return this.artifactContentType;
    }

    public String getInstallationPath() {
        return this.installationPath;
    }

    public Boolean getHeadlessMode() {
        return this.headlessMode;
    }

    public Boolean getForceInstall() {
        return this.forceInstall;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("NewInstallationSite(");
        sb.append("super=").append(super.toString());
        sb.append("managedInstanceId=").append(String.valueOf(this.managedInstanceId));
        sb.append(", releaseVersion=").append(String.valueOf(this.releaseVersion));
        sb.append(", artifactContentType=").append(String.valueOf((Object)this.artifactContentType));
        sb.append(", installationPath=").append(String.valueOf(this.installationPath));
        sb.append(", headlessMode=").append(String.valueOf(this.headlessMode));
        sb.append(", forceInstall=").append(String.valueOf(this.forceInstall));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NewInstallationSite)) {
            return false;
        }
        NewInstallationSite other = (NewInstallationSite)((Object)o);
        return Objects.equals(this.managedInstanceId, other.managedInstanceId) && Objects.equals(this.releaseVersion, other.releaseVersion) && Objects.equals((Object)this.artifactContentType, (Object)other.artifactContentType) && Objects.equals(this.installationPath, other.installationPath) && Objects.equals(this.headlessMode, other.headlessMode) && Objects.equals(this.forceInstall, other.forceInstall) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.managedInstanceId == null ? 43 : this.managedInstanceId.hashCode());
        result = result * 59 + (this.releaseVersion == null ? 43 : this.releaseVersion.hashCode());
        result = result * 59 + (this.artifactContentType == null ? 43 : this.artifactContentType.hashCode());
        result = result * 59 + (this.installationPath == null ? 43 : this.installationPath.hashCode());
        result = result * 59 + (this.headlessMode == null ? 43 : this.headlessMode.hashCode());
        result = result * 59 + (this.forceInstall == null ? 43 : this.forceInstall.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="managedInstanceId")
        private String managedInstanceId;
        @JsonProperty(value="releaseVersion")
        private String releaseVersion;
        @JsonProperty(value="artifactContentType")
        private ArtifactContentType artifactContentType;
        @JsonProperty(value="installationPath")
        private String installationPath;
        @JsonProperty(value="headlessMode")
        private Boolean headlessMode;
        @JsonProperty(value="forceInstall")
        private Boolean forceInstall;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder managedInstanceId(String managedInstanceId) {
            this.managedInstanceId = managedInstanceId;
            this.__explicitlySet__.add("managedInstanceId");
            return this;
        }

        public Builder releaseVersion(String releaseVersion) {
            this.releaseVersion = releaseVersion;
            this.__explicitlySet__.add("releaseVersion");
            return this;
        }

        public Builder artifactContentType(ArtifactContentType artifactContentType) {
            this.artifactContentType = artifactContentType;
            this.__explicitlySet__.add("artifactContentType");
            return this;
        }

        public Builder installationPath(String installationPath) {
            this.installationPath = installationPath;
            this.__explicitlySet__.add("installationPath");
            return this;
        }

        public Builder headlessMode(Boolean headlessMode) {
            this.headlessMode = headlessMode;
            this.__explicitlySet__.add("headlessMode");
            return this;
        }

        public Builder forceInstall(Boolean forceInstall) {
            this.forceInstall = forceInstall;
            this.__explicitlySet__.add("forceInstall");
            return this;
        }

        public NewInstallationSite build() {
            NewInstallationSite model = new NewInstallationSite(this.managedInstanceId, this.releaseVersion, this.artifactContentType, this.installationPath, this.headlessMode, this.forceInstall);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(NewInstallationSite model) {
            if (model.wasPropertyExplicitlySet("managedInstanceId")) {
                this.managedInstanceId(model.getManagedInstanceId());
            }
            if (model.wasPropertyExplicitlySet("releaseVersion")) {
                this.releaseVersion(model.getReleaseVersion());
            }
            if (model.wasPropertyExplicitlySet("artifactContentType")) {
                this.artifactContentType(model.getArtifactContentType());
            }
            if (model.wasPropertyExplicitlySet("installationPath")) {
                this.installationPath(model.getInstallationPath());
            }
            if (model.wasPropertyExplicitlySet("headlessMode")) {
                this.headlessMode(model.getHeadlessMode());
            }
            if (model.wasPropertyExplicitlySet("forceInstall")) {
                this.forceInstall(model.getForceInstall());
            }
            return this;
        }
    }
}

