/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.jms.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.jms.model.JfrAttachmentTarget;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class RequestCryptoAnalysesDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="targets")
    private final List<JfrAttachmentTarget> targets;
    @JsonProperty(value="recordingDurationInMinutes")
    private final Integer recordingDurationInMinutes;
    @JsonProperty(value="waitingPeriodInMinutes")
    private final Integer waitingPeriodInMinutes;

    @Deprecated
    @ConstructorProperties(value={"targets", "recordingDurationInMinutes", "waitingPeriodInMinutes"})
    public RequestCryptoAnalysesDetails(List<JfrAttachmentTarget> targets, Integer recordingDurationInMinutes, Integer waitingPeriodInMinutes) {
        this.targets = targets;
        this.recordingDurationInMinutes = recordingDurationInMinutes;
        this.waitingPeriodInMinutes = waitingPeriodInMinutes;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public List<JfrAttachmentTarget> getTargets() {
        return this.targets;
    }

    public Integer getRecordingDurationInMinutes() {
        return this.recordingDurationInMinutes;
    }

    public Integer getWaitingPeriodInMinutes() {
        return this.waitingPeriodInMinutes;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("RequestCryptoAnalysesDetails(");
        sb.append("super=").append(super.toString());
        sb.append("targets=").append(String.valueOf(this.targets));
        sb.append(", recordingDurationInMinutes=").append(String.valueOf(this.recordingDurationInMinutes));
        sb.append(", waitingPeriodInMinutes=").append(String.valueOf(this.waitingPeriodInMinutes));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RequestCryptoAnalysesDetails)) {
            return false;
        }
        RequestCryptoAnalysesDetails other = (RequestCryptoAnalysesDetails)((Object)o);
        return Objects.equals(this.targets, other.targets) && Objects.equals(this.recordingDurationInMinutes, other.recordingDurationInMinutes) && Objects.equals(this.waitingPeriodInMinutes, other.waitingPeriodInMinutes) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.targets == null ? 43 : this.targets.hashCode());
        result = result * 59 + (this.recordingDurationInMinutes == null ? 43 : this.recordingDurationInMinutes.hashCode());
        result = result * 59 + (this.waitingPeriodInMinutes == null ? 43 : this.waitingPeriodInMinutes.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="targets")
        private List<JfrAttachmentTarget> targets;
        @JsonProperty(value="recordingDurationInMinutes")
        private Integer recordingDurationInMinutes;
        @JsonProperty(value="waitingPeriodInMinutes")
        private Integer waitingPeriodInMinutes;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder targets(List<JfrAttachmentTarget> targets) {
            this.targets = targets;
            this.__explicitlySet__.add("targets");
            return this;
        }

        public Builder recordingDurationInMinutes(Integer recordingDurationInMinutes) {
            this.recordingDurationInMinutes = recordingDurationInMinutes;
            this.__explicitlySet__.add("recordingDurationInMinutes");
            return this;
        }

        public Builder waitingPeriodInMinutes(Integer waitingPeriodInMinutes) {
            this.waitingPeriodInMinutes = waitingPeriodInMinutes;
            this.__explicitlySet__.add("waitingPeriodInMinutes");
            return this;
        }

        public RequestCryptoAnalysesDetails build() {
            RequestCryptoAnalysesDetails model = new RequestCryptoAnalysesDetails(this.targets, this.recordingDurationInMinutes, this.waitingPeriodInMinutes);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(RequestCryptoAnalysesDetails model) {
            if (model.wasPropertyExplicitlySet("targets")) {
                this.targets(model.getTargets());
            }
            if (model.wasPropertyExplicitlySet("recordingDurationInMinutes")) {
                this.recordingDurationInMinutes(model.getRecordingDurationInMinutes());
            }
            if (model.wasPropertyExplicitlySet("waitingPeriodInMinutes")) {
                this.waitingPeriodInMinutes(model.getWaitingPeriodInMinutes());
            }
            return this;
        }
    }
}

