/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.jms.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.jms.model.JfrAttachmentTarget;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class RequestJfrRecordingsDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="targets")
    private final List<JfrAttachmentTarget> targets;
    @JsonProperty(value="jfcProfileName")
    private final String jfcProfileName;
    @JsonProperty(value="jfcV1")
    private final String jfcV1;
    @JsonProperty(value="jfcV2")
    private final String jfcV2;
    @JsonProperty(value="recordingDurationInMinutes")
    private final Integer recordingDurationInMinutes;
    @JsonProperty(value="recordingSizeInMb")
    private final Integer recordingSizeInMb;
    @JsonProperty(value="waitingPeriodInMinutes")
    private final Integer waitingPeriodInMinutes;

    @Deprecated
    @ConstructorProperties(value={"targets", "jfcProfileName", "jfcV1", "jfcV2", "recordingDurationInMinutes", "recordingSizeInMb", "waitingPeriodInMinutes"})
    public RequestJfrRecordingsDetails(List<JfrAttachmentTarget> targets, String jfcProfileName, String jfcV1, String jfcV2, Integer recordingDurationInMinutes, Integer recordingSizeInMb, Integer waitingPeriodInMinutes) {
        this.targets = targets;
        this.jfcProfileName = jfcProfileName;
        this.jfcV1 = jfcV1;
        this.jfcV2 = jfcV2;
        this.recordingDurationInMinutes = recordingDurationInMinutes;
        this.recordingSizeInMb = recordingSizeInMb;
        this.waitingPeriodInMinutes = waitingPeriodInMinutes;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public List<JfrAttachmentTarget> getTargets() {
        return this.targets;
    }

    public String getJfcProfileName() {
        return this.jfcProfileName;
    }

    public String getJfcV1() {
        return this.jfcV1;
    }

    public String getJfcV2() {
        return this.jfcV2;
    }

    public Integer getRecordingDurationInMinutes() {
        return this.recordingDurationInMinutes;
    }

    public Integer getRecordingSizeInMb() {
        return this.recordingSizeInMb;
    }

    public Integer getWaitingPeriodInMinutes() {
        return this.waitingPeriodInMinutes;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("RequestJfrRecordingsDetails(");
        sb.append("super=").append(super.toString());
        sb.append("targets=").append(String.valueOf(this.targets));
        sb.append(", jfcProfileName=").append(String.valueOf(this.jfcProfileName));
        sb.append(", jfcV1=").append(String.valueOf(this.jfcV1));
        sb.append(", jfcV2=").append(String.valueOf(this.jfcV2));
        sb.append(", recordingDurationInMinutes=").append(String.valueOf(this.recordingDurationInMinutes));
        sb.append(", recordingSizeInMb=").append(String.valueOf(this.recordingSizeInMb));
        sb.append(", waitingPeriodInMinutes=").append(String.valueOf(this.waitingPeriodInMinutes));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RequestJfrRecordingsDetails)) {
            return false;
        }
        RequestJfrRecordingsDetails other = (RequestJfrRecordingsDetails)((Object)o);
        return Objects.equals(this.targets, other.targets) && Objects.equals(this.jfcProfileName, other.jfcProfileName) && Objects.equals(this.jfcV1, other.jfcV1) && Objects.equals(this.jfcV2, other.jfcV2) && Objects.equals(this.recordingDurationInMinutes, other.recordingDurationInMinutes) && Objects.equals(this.recordingSizeInMb, other.recordingSizeInMb) && Objects.equals(this.waitingPeriodInMinutes, other.waitingPeriodInMinutes) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.targets == null ? 43 : this.targets.hashCode());
        result = result * 59 + (this.jfcProfileName == null ? 43 : this.jfcProfileName.hashCode());
        result = result * 59 + (this.jfcV1 == null ? 43 : this.jfcV1.hashCode());
        result = result * 59 + (this.jfcV2 == null ? 43 : this.jfcV2.hashCode());
        result = result * 59 + (this.recordingDurationInMinutes == null ? 43 : this.recordingDurationInMinutes.hashCode());
        result = result * 59 + (this.recordingSizeInMb == null ? 43 : this.recordingSizeInMb.hashCode());
        result = result * 59 + (this.waitingPeriodInMinutes == null ? 43 : this.waitingPeriodInMinutes.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="targets")
        private List<JfrAttachmentTarget> targets;
        @JsonProperty(value="jfcProfileName")
        private String jfcProfileName;
        @JsonProperty(value="jfcV1")
        private String jfcV1;
        @JsonProperty(value="jfcV2")
        private String jfcV2;
        @JsonProperty(value="recordingDurationInMinutes")
        private Integer recordingDurationInMinutes;
        @JsonProperty(value="recordingSizeInMb")
        private Integer recordingSizeInMb;
        @JsonProperty(value="waitingPeriodInMinutes")
        private Integer waitingPeriodInMinutes;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder targets(List<JfrAttachmentTarget> targets) {
            this.targets = targets;
            this.__explicitlySet__.add("targets");
            return this;
        }

        public Builder jfcProfileName(String jfcProfileName) {
            this.jfcProfileName = jfcProfileName;
            this.__explicitlySet__.add("jfcProfileName");
            return this;
        }

        public Builder jfcV1(String jfcV1) {
            this.jfcV1 = jfcV1;
            this.__explicitlySet__.add("jfcV1");
            return this;
        }

        public Builder jfcV2(String jfcV2) {
            this.jfcV2 = jfcV2;
            this.__explicitlySet__.add("jfcV2");
            return this;
        }

        public Builder recordingDurationInMinutes(Integer recordingDurationInMinutes) {
            this.recordingDurationInMinutes = recordingDurationInMinutes;
            this.__explicitlySet__.add("recordingDurationInMinutes");
            return this;
        }

        public Builder recordingSizeInMb(Integer recordingSizeInMb) {
            this.recordingSizeInMb = recordingSizeInMb;
            this.__explicitlySet__.add("recordingSizeInMb");
            return this;
        }

        public Builder waitingPeriodInMinutes(Integer waitingPeriodInMinutes) {
            this.waitingPeriodInMinutes = waitingPeriodInMinutes;
            this.__explicitlySet__.add("waitingPeriodInMinutes");
            return this;
        }

        public RequestJfrRecordingsDetails build() {
            RequestJfrRecordingsDetails model = new RequestJfrRecordingsDetails(this.targets, this.jfcProfileName, this.jfcV1, this.jfcV2, this.recordingDurationInMinutes, this.recordingSizeInMb, this.waitingPeriodInMinutes);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(RequestJfrRecordingsDetails model) {
            if (model.wasPropertyExplicitlySet("targets")) {
                this.targets(model.getTargets());
            }
            if (model.wasPropertyExplicitlySet("jfcProfileName")) {
                this.jfcProfileName(model.getJfcProfileName());
            }
            if (model.wasPropertyExplicitlySet("jfcV1")) {
                this.jfcV1(model.getJfcV1());
            }
            if (model.wasPropertyExplicitlySet("jfcV2")) {
                this.jfcV2(model.getJfcV2());
            }
            if (model.wasPropertyExplicitlySet("recordingDurationInMinutes")) {
                this.recordingDurationInMinutes(model.getRecordingDurationInMinutes());
            }
            if (model.wasPropertyExplicitlySet("recordingSizeInMb")) {
                this.recordingSizeInMb(model.getRecordingSizeInMb());
            }
            if (model.wasPropertyExplicitlySet("waitingPeriodInMinutes")) {
                this.waitingPeriodInMinutes(model.getWaitingPeriodInMinutes());
            }
            return this;
        }
    }
}

