/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.jms.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class DeleteJavaMigrationAnalysisResultRequest
extends BmcRequest<Void> {
    private String fleetId;
    private String javaMigrationAnalysisResultId;
    private String ifMatch;
    private String opcRequestId;

    public String getFleetId() {
        return this.fleetId;
    }

    public String getJavaMigrationAnalysisResultId() {
        return this.javaMigrationAnalysisResultId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().fleetId(this.fleetId).javaMigrationAnalysisResultId(this.javaMigrationAnalysisResultId).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",fleetId=").append(String.valueOf(this.fleetId));
        sb.append(",javaMigrationAnalysisResultId=").append(String.valueOf(this.javaMigrationAnalysisResultId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DeleteJavaMigrationAnalysisResultRequest)) {
            return false;
        }
        DeleteJavaMigrationAnalysisResultRequest other = (DeleteJavaMigrationAnalysisResultRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.fleetId, other.fleetId) && Objects.equals(this.javaMigrationAnalysisResultId, other.javaMigrationAnalysisResultId) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.fleetId == null ? 43 : this.fleetId.hashCode());
        result = result * 59 + (this.javaMigrationAnalysisResultId == null ? 43 : this.javaMigrationAnalysisResultId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<DeleteJavaMigrationAnalysisResultRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String fleetId = null;
        private String javaMigrationAnalysisResultId = null;
        private String ifMatch = null;
        private String opcRequestId = null;

        public Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public Builder javaMigrationAnalysisResultId(String javaMigrationAnalysisResultId) {
            this.javaMigrationAnalysisResultId = javaMigrationAnalysisResultId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteJavaMigrationAnalysisResultRequest o) {
            this.fleetId(o.getFleetId());
            this.javaMigrationAnalysisResultId(o.getJavaMigrationAnalysisResultId());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteJavaMigrationAnalysisResultRequest build() {
            DeleteJavaMigrationAnalysisResultRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public DeleteJavaMigrationAnalysisResultRequest buildWithoutInvocationCallback() {
            DeleteJavaMigrationAnalysisResultRequest request = new DeleteJavaMigrationAnalysisResultRequest();
            request.fleetId = this.fleetId;
            request.javaMigrationAnalysisResultId = this.javaMigrationAnalysisResultId;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

