/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.jms.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.jms.model.DisableDrsDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class DisableDrsRequest
extends BmcRequest<DisableDrsDetails> {
    private String fleetId;
    private DisableDrsDetails disableDrsDetails;
    private String opcRequestId;
    private String ifMatch;
    private String opcRetryToken;

    public String getFleetId() {
        return this.fleetId;
    }

    public DisableDrsDetails getDisableDrsDetails() {
        return this.disableDrsDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    @InternalSdk
    public DisableDrsDetails getBody$() {
        return this.disableDrsDetails;
    }

    public Builder toBuilder() {
        return new Builder().fleetId(this.fleetId).disableDrsDetails(this.disableDrsDetails).opcRequestId(this.opcRequestId).ifMatch(this.ifMatch).opcRetryToken(this.opcRetryToken);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",fleetId=").append(String.valueOf(this.fleetId));
        sb.append(",disableDrsDetails=").append(String.valueOf((Object)this.disableDrsDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DisableDrsRequest)) {
            return false;
        }
        DisableDrsRequest other = (DisableDrsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.fleetId, other.fleetId) && Objects.equals((Object)this.disableDrsDetails, (Object)other.disableDrsDetails) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRetryToken, other.opcRetryToken);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.fleetId == null ? 43 : this.fleetId.hashCode());
        result = result * 59 + (this.disableDrsDetails == null ? 43 : this.disableDrsDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<DisableDrsRequest, DisableDrsDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String fleetId = null;
        private DisableDrsDetails disableDrsDetails = null;
        private String opcRequestId = null;
        private String ifMatch = null;
        private String opcRetryToken = null;

        public Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public Builder disableDrsDetails(DisableDrsDetails disableDrsDetails) {
            this.disableDrsDetails = disableDrsDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DisableDrsRequest o) {
            this.fleetId(o.getFleetId());
            this.disableDrsDetails(o.getDisableDrsDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.ifMatch(o.getIfMatch());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DisableDrsRequest build() {
            DisableDrsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(DisableDrsDetails body) {
            this.disableDrsDetails(body);
            return this;
        }

        public DisableDrsRequest buildWithoutInvocationCallback() {
            DisableDrsRequest request = new DisableDrsRequest();
            request.fleetId = this.fleetId;
            request.disableDrsDetails = this.disableDrsDetails;
            request.opcRequestId = this.opcRequestId;
            request.ifMatch = this.ifMatch;
            request.opcRetryToken = this.opcRetryToken;
            return request;
        }
    }
}

