/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.jms.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetJmsPluginRequest
extends BmcRequest<Void> {
    private String jmsPluginId;
    private String opcRequestId;

    public String getJmsPluginId() {
        return this.jmsPluginId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().jmsPluginId(this.jmsPluginId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",jmsPluginId=").append(String.valueOf(this.jmsPluginId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetJmsPluginRequest)) {
            return false;
        }
        GetJmsPluginRequest other = (GetJmsPluginRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.jmsPluginId, other.jmsPluginId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.jmsPluginId == null ? 43 : this.jmsPluginId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetJmsPluginRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String jmsPluginId = null;
        private String opcRequestId = null;

        public Builder jmsPluginId(String jmsPluginId) {
            this.jmsPluginId = jmsPluginId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetJmsPluginRequest o) {
            this.jmsPluginId(o.getJmsPluginId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetJmsPluginRequest build() {
            GetJmsPluginRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetJmsPluginRequest buildWithoutInvocationCallback() {
            GetJmsPluginRequest request = new GetJmsPluginRequest();
            request.jmsPluginId = this.jmsPluginId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

