/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.jms.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetPerformanceTuningAnalysisResultRequest
extends BmcRequest<Void> {
    private String fleetId;
    private String performanceTuningAnalysisResultId;
    private String opcRequestId;

    public String getFleetId() {
        return this.fleetId;
    }

    public String getPerformanceTuningAnalysisResultId() {
        return this.performanceTuningAnalysisResultId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().fleetId(this.fleetId).performanceTuningAnalysisResultId(this.performanceTuningAnalysisResultId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",fleetId=").append(String.valueOf(this.fleetId));
        sb.append(",performanceTuningAnalysisResultId=").append(String.valueOf(this.performanceTuningAnalysisResultId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetPerformanceTuningAnalysisResultRequest)) {
            return false;
        }
        GetPerformanceTuningAnalysisResultRequest other = (GetPerformanceTuningAnalysisResultRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.fleetId, other.fleetId) && Objects.equals(this.performanceTuningAnalysisResultId, other.performanceTuningAnalysisResultId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.fleetId == null ? 43 : this.fleetId.hashCode());
        result = result * 59 + (this.performanceTuningAnalysisResultId == null ? 43 : this.performanceTuningAnalysisResultId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetPerformanceTuningAnalysisResultRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String fleetId = null;
        private String performanceTuningAnalysisResultId = null;
        private String opcRequestId = null;

        public Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public Builder performanceTuningAnalysisResultId(String performanceTuningAnalysisResultId) {
            this.performanceTuningAnalysisResultId = performanceTuningAnalysisResultId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetPerformanceTuningAnalysisResultRequest o) {
            this.fleetId(o.getFleetId());
            this.performanceTuningAnalysisResultId(o.getPerformanceTuningAnalysisResultId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetPerformanceTuningAnalysisResultRequest build() {
            GetPerformanceTuningAnalysisResultRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetPerformanceTuningAnalysisResultRequest buildWithoutInvocationCallback() {
            GetPerformanceTuningAnalysisResultRequest request = new GetPerformanceTuningAnalysisResultRequest();
            request.fleetId = this.fleetId;
            request.performanceTuningAnalysisResultId = this.performanceTuningAnalysisResultId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

