/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.jms.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.jms.model.AgentInstallerSortBy;
import com.oracle.bmc.jms.model.OsFamily;
import com.oracle.bmc.jms.model.PlatformArchitectureType;
import com.oracle.bmc.jms.model.SortOrder;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class ListAgentInstallersRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private String fleetId;
    private PlatformArchitectureType platformArchitecture;
    private OsFamily osFamily;
    private Integer limit;
    private String page;
    private SortOrder sortOrder;
    private AgentInstallerSortBy sortBy;
    private String opcRequestId;

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getFleetId() {
        return this.fleetId;
    }

    public PlatformArchitectureType getPlatformArchitecture() {
        return this.platformArchitecture;
    }

    public OsFamily getOsFamily() {
        return this.osFamily;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public AgentInstallerSortBy getSortBy() {
        return this.sortBy;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().compartmentId(this.compartmentId).fleetId(this.fleetId).platformArchitecture(this.platformArchitecture).osFamily(this.osFamily).limit(this.limit).page(this.page).sortOrder(this.sortOrder).sortBy(this.sortBy).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",fleetId=").append(String.valueOf(this.fleetId));
        sb.append(",platformArchitecture=").append(String.valueOf((Object)this.platformArchitecture));
        sb.append(",osFamily=").append(String.valueOf((Object)this.osFamily));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListAgentInstallersRequest)) {
            return false;
        }
        ListAgentInstallersRequest other = (ListAgentInstallersRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.fleetId, other.fleetId) && Objects.equals((Object)this.platformArchitecture, (Object)other.platformArchitecture) && Objects.equals((Object)this.osFamily, (Object)other.osFamily) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.fleetId == null ? 43 : this.fleetId.hashCode());
        result = result * 59 + (this.platformArchitecture == null ? 43 : this.platformArchitecture.hashCode());
        result = result * 59 + (this.osFamily == null ? 43 : this.osFamily.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListAgentInstallersRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String compartmentId = null;
        private String fleetId = null;
        private PlatformArchitectureType platformArchitecture = null;
        private OsFamily osFamily = null;
        private Integer limit = null;
        private String page = null;
        private SortOrder sortOrder = null;
        private AgentInstallerSortBy sortBy = null;
        private String opcRequestId = null;

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public Builder platformArchitecture(PlatformArchitectureType platformArchitecture) {
            this.platformArchitecture = platformArchitecture;
            return this;
        }

        public Builder osFamily(OsFamily osFamily) {
            this.osFamily = osFamily;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortBy(AgentInstallerSortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListAgentInstallersRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.fleetId(o.getFleetId());
            this.platformArchitecture(o.getPlatformArchitecture());
            this.osFamily(o.getOsFamily());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.sortOrder(o.getSortOrder());
            this.sortBy(o.getSortBy());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListAgentInstallersRequest build() {
            ListAgentInstallersRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListAgentInstallersRequest buildWithoutInvocationCallback() {
            ListAgentInstallersRequest request = new ListAgentInstallersRequest();
            request.compartmentId = this.compartmentId;
            request.fleetId = this.fleetId;
            request.platformArchitecture = this.platformArchitecture;
            request.osFamily = this.osFamily;
            request.limit = this.limit;
            request.page = this.page;
            request.sortOrder = this.sortOrder;
            request.sortBy = this.sortBy;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

