/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.jms.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.jms.model.JavaReleaseSortBy;
import com.oracle.bmc.jms.model.JreSecurityStatus;
import com.oracle.bmc.jms.model.LicenseType;
import com.oracle.bmc.jms.model.ReleaseType;
import com.oracle.bmc.jms.model.SortOrder;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class ListJavaReleasesRequest
extends BmcRequest<Void> {
    private String releaseVersion;
    private String familyVersion;
    private ReleaseType releaseType;
    private JreSecurityStatus jreSecurityStatus;
    private LicenseType licenseType;
    private Integer limit;
    private String page;
    private SortOrder sortOrder;
    private JavaReleaseSortBy sortBy;
    private String opcRequestId;

    public String getReleaseVersion() {
        return this.releaseVersion;
    }

    public String getFamilyVersion() {
        return this.familyVersion;
    }

    public ReleaseType getReleaseType() {
        return this.releaseType;
    }

    public JreSecurityStatus getJreSecurityStatus() {
        return this.jreSecurityStatus;
    }

    public LicenseType getLicenseType() {
        return this.licenseType;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public JavaReleaseSortBy getSortBy() {
        return this.sortBy;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().releaseVersion(this.releaseVersion).familyVersion(this.familyVersion).releaseType(this.releaseType).jreSecurityStatus(this.jreSecurityStatus).licenseType(this.licenseType).limit(this.limit).page(this.page).sortOrder(this.sortOrder).sortBy(this.sortBy).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",releaseVersion=").append(String.valueOf(this.releaseVersion));
        sb.append(",familyVersion=").append(String.valueOf(this.familyVersion));
        sb.append(",releaseType=").append(String.valueOf((Object)this.releaseType));
        sb.append(",jreSecurityStatus=").append(String.valueOf((Object)this.jreSecurityStatus));
        sb.append(",licenseType=").append(String.valueOf((Object)this.licenseType));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListJavaReleasesRequest)) {
            return false;
        }
        ListJavaReleasesRequest other = (ListJavaReleasesRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.releaseVersion, other.releaseVersion) && Objects.equals(this.familyVersion, other.familyVersion) && Objects.equals((Object)this.releaseType, (Object)other.releaseType) && Objects.equals((Object)this.jreSecurityStatus, (Object)other.jreSecurityStatus) && Objects.equals((Object)this.licenseType, (Object)other.licenseType) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.releaseVersion == null ? 43 : this.releaseVersion.hashCode());
        result = result * 59 + (this.familyVersion == null ? 43 : this.familyVersion.hashCode());
        result = result * 59 + (this.releaseType == null ? 43 : this.releaseType.hashCode());
        result = result * 59 + (this.jreSecurityStatus == null ? 43 : this.jreSecurityStatus.hashCode());
        result = result * 59 + (this.licenseType == null ? 43 : this.licenseType.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListJavaReleasesRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String releaseVersion = null;
        private String familyVersion = null;
        private ReleaseType releaseType = null;
        private JreSecurityStatus jreSecurityStatus = null;
        private LicenseType licenseType = null;
        private Integer limit = null;
        private String page = null;
        private SortOrder sortOrder = null;
        private JavaReleaseSortBy sortBy = null;
        private String opcRequestId = null;

        public Builder releaseVersion(String releaseVersion) {
            this.releaseVersion = releaseVersion;
            return this;
        }

        public Builder familyVersion(String familyVersion) {
            this.familyVersion = familyVersion;
            return this;
        }

        public Builder releaseType(ReleaseType releaseType) {
            this.releaseType = releaseType;
            return this;
        }

        public Builder jreSecurityStatus(JreSecurityStatus jreSecurityStatus) {
            this.jreSecurityStatus = jreSecurityStatus;
            return this;
        }

        public Builder licenseType(LicenseType licenseType) {
            this.licenseType = licenseType;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortBy(JavaReleaseSortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListJavaReleasesRequest o) {
            this.releaseVersion(o.getReleaseVersion());
            this.familyVersion(o.getFamilyVersion());
            this.releaseType(o.getReleaseType());
            this.jreSecurityStatus(o.getJreSecurityStatus());
            this.licenseType(o.getLicenseType());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.sortOrder(o.getSortOrder());
            this.sortBy(o.getSortBy());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListJavaReleasesRequest build() {
            ListJavaReleasesRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListJavaReleasesRequest buildWithoutInvocationCallback() {
            ListJavaReleasesRequest request = new ListJavaReleasesRequest();
            request.releaseVersion = this.releaseVersion;
            request.familyVersion = this.familyVersion;
            request.releaseType = this.releaseType;
            request.jreSecurityStatus = this.jreSecurityStatus;
            request.licenseType = this.licenseType;
            request.limit = this.limit;
            request.page = this.page;
            request.sortOrder = this.sortOrder;
            request.sortBy = this.sortBy;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

