/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.jms.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.jms.model.RequestJfrRecordingsDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class RequestJfrRecordingsRequest
extends BmcRequest<RequestJfrRecordingsDetails> {
    private String fleetId;
    private RequestJfrRecordingsDetails requestJfrRecordingsDetails;
    private String opcRequestId;

    public String getFleetId() {
        return this.fleetId;
    }

    public RequestJfrRecordingsDetails getRequestJfrRecordingsDetails() {
        return this.requestJfrRecordingsDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public RequestJfrRecordingsDetails getBody$() {
        return this.requestJfrRecordingsDetails;
    }

    public Builder toBuilder() {
        return new Builder().fleetId(this.fleetId).requestJfrRecordingsDetails(this.requestJfrRecordingsDetails).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",fleetId=").append(String.valueOf(this.fleetId));
        sb.append(",requestJfrRecordingsDetails=").append(String.valueOf((Object)this.requestJfrRecordingsDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RequestJfrRecordingsRequest)) {
            return false;
        }
        RequestJfrRecordingsRequest other = (RequestJfrRecordingsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.fleetId, other.fleetId) && Objects.equals((Object)this.requestJfrRecordingsDetails, (Object)other.requestJfrRecordingsDetails) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.fleetId == null ? 43 : this.fleetId.hashCode());
        result = result * 59 + (this.requestJfrRecordingsDetails == null ? 43 : this.requestJfrRecordingsDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<RequestJfrRecordingsRequest, RequestJfrRecordingsDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String fleetId = null;
        private RequestJfrRecordingsDetails requestJfrRecordingsDetails = null;
        private String opcRequestId = null;

        public Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public Builder requestJfrRecordingsDetails(RequestJfrRecordingsDetails requestJfrRecordingsDetails) {
            this.requestJfrRecordingsDetails = requestJfrRecordingsDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(RequestJfrRecordingsRequest o) {
            this.fleetId(o.getFleetId());
            this.requestJfrRecordingsDetails(o.getRequestJfrRecordingsDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public RequestJfrRecordingsRequest build() {
            RequestJfrRecordingsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(RequestJfrRecordingsDetails body) {
            this.requestJfrRecordingsDetails(body);
            return this;
        }

        public RequestJfrRecordingsRequest buildWithoutInvocationCallback() {
            RequestJfrRecordingsRequest request = new RequestJfrRecordingsRequest();
            request.fleetId = this.fleetId;
            request.requestJfrRecordingsDetails = this.requestJfrRecordingsDetails;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

