/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.jms.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.jms.model.JavaServerSortBy;
import com.oracle.bmc.jms.model.SortOrder;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Date;
import java.util.Objects;

public class SummarizeJavaServerUsageRequest
extends BmcRequest<Void> {
    private String fleetId;
    private String serverKey;
    private String serverNameContains;
    private String serverName;
    private String serverVersion;
    private Date timeStart;
    private Date timeEnd;
    private Integer limit;
    private String page;
    private SortOrder sortOrder;
    private JavaServerSortBy sortBy;
    private String opcRequestId;

    public String getFleetId() {
        return this.fleetId;
    }

    public String getServerKey() {
        return this.serverKey;
    }

    public String getServerNameContains() {
        return this.serverNameContains;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getServerVersion() {
        return this.serverVersion;
    }

    public Date getTimeStart() {
        return this.timeStart;
    }

    public Date getTimeEnd() {
        return this.timeEnd;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public JavaServerSortBy getSortBy() {
        return this.sortBy;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().fleetId(this.fleetId).serverKey(this.serverKey).serverNameContains(this.serverNameContains).serverName(this.serverName).serverVersion(this.serverVersion).timeStart(this.timeStart).timeEnd(this.timeEnd).limit(this.limit).page(this.page).sortOrder(this.sortOrder).sortBy(this.sortBy).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",fleetId=").append(String.valueOf(this.fleetId));
        sb.append(",serverKey=").append(String.valueOf(this.serverKey));
        sb.append(",serverNameContains=").append(String.valueOf(this.serverNameContains));
        sb.append(",serverName=").append(String.valueOf(this.serverName));
        sb.append(",serverVersion=").append(String.valueOf(this.serverVersion));
        sb.append(",timeStart=").append(String.valueOf(this.timeStart));
        sb.append(",timeEnd=").append(String.valueOf(this.timeEnd));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SummarizeJavaServerUsageRequest)) {
            return false;
        }
        SummarizeJavaServerUsageRequest other = (SummarizeJavaServerUsageRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.fleetId, other.fleetId) && Objects.equals(this.serverKey, other.serverKey) && Objects.equals(this.serverNameContains, other.serverNameContains) && Objects.equals(this.serverName, other.serverName) && Objects.equals(this.serverVersion, other.serverVersion) && Objects.equals(this.timeStart, other.timeStart) && Objects.equals(this.timeEnd, other.timeEnd) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.fleetId == null ? 43 : this.fleetId.hashCode());
        result = result * 59 + (this.serverKey == null ? 43 : this.serverKey.hashCode());
        result = result * 59 + (this.serverNameContains == null ? 43 : this.serverNameContains.hashCode());
        result = result * 59 + (this.serverName == null ? 43 : this.serverName.hashCode());
        result = result * 59 + (this.serverVersion == null ? 43 : this.serverVersion.hashCode());
        result = result * 59 + (this.timeStart == null ? 43 : this.timeStart.hashCode());
        result = result * 59 + (this.timeEnd == null ? 43 : this.timeEnd.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<SummarizeJavaServerUsageRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String fleetId = null;
        private String serverKey = null;
        private String serverNameContains = null;
        private String serverName = null;
        private String serverVersion = null;
        private Date timeStart = null;
        private Date timeEnd = null;
        private Integer limit = null;
        private String page = null;
        private SortOrder sortOrder = null;
        private JavaServerSortBy sortBy = null;
        private String opcRequestId = null;

        public Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public Builder serverKey(String serverKey) {
            this.serverKey = serverKey;
            return this;
        }

        public Builder serverNameContains(String serverNameContains) {
            this.serverNameContains = serverNameContains;
            return this;
        }

        public Builder serverName(String serverName) {
            this.serverName = serverName;
            return this;
        }

        public Builder serverVersion(String serverVersion) {
            this.serverVersion = serverVersion;
            return this;
        }

        public Builder timeStart(Date timeStart) {
            this.timeStart = timeStart;
            return this;
        }

        public Builder timeEnd(Date timeEnd) {
            this.timeEnd = timeEnd;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortBy(JavaServerSortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(SummarizeJavaServerUsageRequest o) {
            this.fleetId(o.getFleetId());
            this.serverKey(o.getServerKey());
            this.serverNameContains(o.getServerNameContains());
            this.serverName(o.getServerName());
            this.serverVersion(o.getServerVersion());
            this.timeStart(o.getTimeStart());
            this.timeEnd(o.getTimeEnd());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.sortOrder(o.getSortOrder());
            this.sortBy(o.getSortBy());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public SummarizeJavaServerUsageRequest build() {
            SummarizeJavaServerUsageRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public SummarizeJavaServerUsageRequest buildWithoutInvocationCallback() {
            SummarizeJavaServerUsageRequest request = new SummarizeJavaServerUsageRequest();
            request.fleetId = this.fleetId;
            request.serverKey = this.serverKey;
            request.serverNameContains = this.serverNameContains;
            request.serverName = this.serverName;
            request.serverVersion = this.serverVersion;
            request.timeStart = this.timeStart;
            request.timeEnd = this.timeEnd;
            request.limit = this.limit;
            request.page = this.page;
            request.sortOrder = this.sortOrder;
            request.sortBy = this.sortBy;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

