/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.jms.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Date;
import java.util.Objects;

public class SummarizeResourceInventoryRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private Date timeStart;
    private Date timeEnd;
    private String opcRequestId;

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public Date getTimeStart() {
        return this.timeStart;
    }

    public Date getTimeEnd() {
        return this.timeEnd;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().compartmentId(this.compartmentId).timeStart(this.timeStart).timeEnd(this.timeEnd).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",timeStart=").append(String.valueOf(this.timeStart));
        sb.append(",timeEnd=").append(String.valueOf(this.timeEnd));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SummarizeResourceInventoryRequest)) {
            return false;
        }
        SummarizeResourceInventoryRequest other = (SummarizeResourceInventoryRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.timeStart, other.timeStart) && Objects.equals(this.timeEnd, other.timeEnd) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.timeStart == null ? 43 : this.timeStart.hashCode());
        result = result * 59 + (this.timeEnd == null ? 43 : this.timeEnd.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<SummarizeResourceInventoryRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String compartmentId = null;
        private Date timeStart = null;
        private Date timeEnd = null;
        private String opcRequestId = null;

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder timeStart(Date timeStart) {
            this.timeStart = timeStart;
            return this;
        }

        public Builder timeEnd(Date timeEnd) {
            this.timeEnd = timeEnd;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(SummarizeResourceInventoryRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.timeStart(o.getTimeStart());
            this.timeEnd(o.getTimeEnd());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public SummarizeResourceInventoryRequest build() {
            SummarizeResourceInventoryRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public SummarizeResourceInventoryRequest buildWithoutInvocationCallback() {
            SummarizeResourceInventoryRequest request = new SummarizeResourceInventoryRequest();
            request.compartmentId = this.compartmentId;
            request.timeStart = this.timeStart;
            request.timeEnd = this.timeEnd;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

