/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.jms.responses;

import com.oracle.bmc.jms.model.JmsPlugin;
import com.oracle.bmc.responses.BmcResponse;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class GetJmsPluginResponse
extends BmcResponse {
    private String opcRequestId;
    private Float retryAfter;
    private String etag;
    private JmsPlugin jmsPlugin;

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Float getRetryAfter() {
        return this.retryAfter;
    }

    public String getEtag() {
        return this.etag;
    }

    public JmsPlugin getJmsPlugin() {
        return this.jmsPlugin;
    }

    @ConstructorProperties(value={"__httpStatusCode__", "headers", "opcRequestId", "retryAfter", "etag", "jmsPlugin"})
    private GetJmsPluginResponse(int __httpStatusCode__, Map<String, List<String>> headers, String opcRequestId, Float retryAfter, String etag, JmsPlugin jmsPlugin) {
        super(__httpStatusCode__, headers);
        this.opcRequestId = opcRequestId;
        this.retryAfter = retryAfter;
        this.etag = etag;
        this.jmsPlugin = jmsPlugin;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",retryAfter=").append(String.valueOf(this.retryAfter));
        sb.append(",etag=").append(String.valueOf(this.etag));
        sb.append(",jmsPlugin=").append(String.valueOf((Object)this.jmsPlugin));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetJmsPluginResponse)) {
            return false;
        }
        GetJmsPluginResponse other = (GetJmsPluginResponse)((Object)o);
        return super.equals(o) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.retryAfter, other.retryAfter) && Objects.equals(this.etag, other.etag) && Objects.equals((Object)this.jmsPlugin, (Object)other.jmsPlugin);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.retryAfter == null ? 43 : this.retryAfter.hashCode());
        result = result * 59 + (this.etag == null ? 43 : this.etag.hashCode());
        result = result * 59 + (this.jmsPlugin == null ? 43 : this.jmsPlugin.hashCode());
        return result;
    }

    public static class Builder
    implements BmcResponse.Builder<GetJmsPluginResponse> {
        private int __httpStatusCode__;
        private Map<String, List<String>> headers;
        private String opcRequestId;
        private Float retryAfter;
        private String etag;
        private JmsPlugin jmsPlugin;

        public Builder __httpStatusCode__(int __httpStatusCode__) {
            this.__httpStatusCode__ = __httpStatusCode__;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            this.headers = headers;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder retryAfter(Float retryAfter) {
            this.retryAfter = retryAfter;
            return this;
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder jmsPlugin(JmsPlugin jmsPlugin) {
            this.jmsPlugin = jmsPlugin;
            return this;
        }

        public Builder copy(GetJmsPluginResponse o) {
            this.__httpStatusCode__(o.get__httpStatusCode__());
            this.headers(o.getHeaders());
            this.opcRequestId(o.getOpcRequestId());
            this.retryAfter(o.getRetryAfter());
            this.etag(o.getEtag());
            this.jmsPlugin(o.getJmsPlugin());
            return this;
        }

        public GetJmsPluginResponse build() {
            return new GetJmsPluginResponse(this.__httpStatusCode__, this.headers, this.opcRequestId, this.retryAfter, this.etag, this.jmsPlugin);
        }
    }
}

