/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.jmsjavadownloads;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.internal.ClientThreadFactory;
import com.oracle.bmc.jmsjavadownloads.JavaDownload;
import com.oracle.bmc.jmsjavadownloads.JavaDownloadPaginators;
import com.oracle.bmc.jmsjavadownloads.JavaDownloadWaiters;
import com.oracle.bmc.jmsjavadownloads.model.DownloadUrl;
import com.oracle.bmc.jmsjavadownloads.model.JavaDownloadCountAggregationCollection;
import com.oracle.bmc.jmsjavadownloads.model.JavaDownloadRecordCollection;
import com.oracle.bmc.jmsjavadownloads.model.JavaDownloadReport;
import com.oracle.bmc.jmsjavadownloads.model.JavaDownloadReportCollection;
import com.oracle.bmc.jmsjavadownloads.model.JavaDownloadToken;
import com.oracle.bmc.jmsjavadownloads.model.JavaDownloadTokenCollection;
import com.oracle.bmc.jmsjavadownloads.model.JavaLicense;
import com.oracle.bmc.jmsjavadownloads.model.JavaLicenseAcceptanceRecord;
import com.oracle.bmc.jmsjavadownloads.model.JavaLicenseAcceptanceRecordCollection;
import com.oracle.bmc.jmsjavadownloads.model.JavaLicenseCollection;
import com.oracle.bmc.jmsjavadownloads.model.WorkRequest;
import com.oracle.bmc.jmsjavadownloads.model.WorkRequestErrorCollection;
import com.oracle.bmc.jmsjavadownloads.model.WorkRequestLogEntryCollection;
import com.oracle.bmc.jmsjavadownloads.model.WorkRequestSummaryCollection;
import com.oracle.bmc.jmsjavadownloads.requests.CancelWorkRequestRequest;
import com.oracle.bmc.jmsjavadownloads.requests.CreateJavaDownloadReportRequest;
import com.oracle.bmc.jmsjavadownloads.requests.CreateJavaDownloadTokenRequest;
import com.oracle.bmc.jmsjavadownloads.requests.CreateJavaLicenseAcceptanceRecordRequest;
import com.oracle.bmc.jmsjavadownloads.requests.DeleteJavaDownloadReportRequest;
import com.oracle.bmc.jmsjavadownloads.requests.DeleteJavaDownloadTokenRequest;
import com.oracle.bmc.jmsjavadownloads.requests.DeleteJavaLicenseAcceptanceRecordRequest;
import com.oracle.bmc.jmsjavadownloads.requests.GenerateArtifactDownloadUrlRequest;
import com.oracle.bmc.jmsjavadownloads.requests.GetJavaDownloadReportContentRequest;
import com.oracle.bmc.jmsjavadownloads.requests.GetJavaDownloadReportRequest;
import com.oracle.bmc.jmsjavadownloads.requests.GetJavaDownloadTokenRequest;
import com.oracle.bmc.jmsjavadownloads.requests.GetJavaLicenseAcceptanceRecordRequest;
import com.oracle.bmc.jmsjavadownloads.requests.GetJavaLicenseRequest;
import com.oracle.bmc.jmsjavadownloads.requests.GetWorkRequestRequest;
import com.oracle.bmc.jmsjavadownloads.requests.ListJavaDownloadRecordsRequest;
import com.oracle.bmc.jmsjavadownloads.requests.ListJavaDownloadReportsRequest;
import com.oracle.bmc.jmsjavadownloads.requests.ListJavaDownloadTokensRequest;
import com.oracle.bmc.jmsjavadownloads.requests.ListJavaLicenseAcceptanceRecordsRequest;
import com.oracle.bmc.jmsjavadownloads.requests.ListJavaLicensesRequest;
import com.oracle.bmc.jmsjavadownloads.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.jmsjavadownloads.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.jmsjavadownloads.requests.ListWorkRequestsRequest;
import com.oracle.bmc.jmsjavadownloads.requests.RequestSummarizedJavaDownloadCountsRequest;
import com.oracle.bmc.jmsjavadownloads.requests.UpdateJavaDownloadTokenRequest;
import com.oracle.bmc.jmsjavadownloads.requests.UpdateJavaLicenseAcceptanceRecordRequest;
import com.oracle.bmc.jmsjavadownloads.responses.CancelWorkRequestResponse;
import com.oracle.bmc.jmsjavadownloads.responses.CreateJavaDownloadReportResponse;
import com.oracle.bmc.jmsjavadownloads.responses.CreateJavaDownloadTokenResponse;
import com.oracle.bmc.jmsjavadownloads.responses.CreateJavaLicenseAcceptanceRecordResponse;
import com.oracle.bmc.jmsjavadownloads.responses.DeleteJavaDownloadReportResponse;
import com.oracle.bmc.jmsjavadownloads.responses.DeleteJavaDownloadTokenResponse;
import com.oracle.bmc.jmsjavadownloads.responses.DeleteJavaLicenseAcceptanceRecordResponse;
import com.oracle.bmc.jmsjavadownloads.responses.GenerateArtifactDownloadUrlResponse;
import com.oracle.bmc.jmsjavadownloads.responses.GetJavaDownloadReportContentResponse;
import com.oracle.bmc.jmsjavadownloads.responses.GetJavaDownloadReportResponse;
import com.oracle.bmc.jmsjavadownloads.responses.GetJavaDownloadTokenResponse;
import com.oracle.bmc.jmsjavadownloads.responses.GetJavaLicenseAcceptanceRecordResponse;
import com.oracle.bmc.jmsjavadownloads.responses.GetJavaLicenseResponse;
import com.oracle.bmc.jmsjavadownloads.responses.GetWorkRequestResponse;
import com.oracle.bmc.jmsjavadownloads.responses.ListJavaDownloadRecordsResponse;
import com.oracle.bmc.jmsjavadownloads.responses.ListJavaDownloadReportsResponse;
import com.oracle.bmc.jmsjavadownloads.responses.ListJavaDownloadTokensResponse;
import com.oracle.bmc.jmsjavadownloads.responses.ListJavaLicenseAcceptanceRecordsResponse;
import com.oracle.bmc.jmsjavadownloads.responses.ListJavaLicensesResponse;
import com.oracle.bmc.jmsjavadownloads.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.jmsjavadownloads.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.jmsjavadownloads.responses.ListWorkRequestsResponse;
import com.oracle.bmc.jmsjavadownloads.responses.RequestSummarizedJavaDownloadCountsResponse;
import com.oracle.bmc.jmsjavadownloads.responses.UpdateJavaDownloadTokenResponse;
import com.oracle.bmc.jmsjavadownloads.responses.UpdateJavaLicenseAcceptanceRecordResponse;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.StreamUtils;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaDownloadClient
extends BaseSyncClient
implements JavaDownload {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("JAVADOWNLOAD").serviceEndpointPrefix("").serviceEndpointTemplate("https://javamanagementservice-download.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(JavaDownloadClient.class);
    private final JavaDownloadWaiters waiters;
    private final JavaDownloadPaginators paginators;

    JavaDownloadClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService) {
        this(builder, authenticationDetailsProvider, executorService, true);
    }

    JavaDownloadClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService, boolean isStreamWarningEnabled) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)ClientThreadFactory.builder().isDaemon(true).nameFormat("JavaDownload-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new JavaDownloadWaiters(executorService, this);
        this.paginators = new JavaDownloadPaginators(this);
        if (isStreamWarningEnabled && StreamUtils.isExtraStreamLogsEnabled()) {
            LOG.warn(StreamUtils.getStreamWarningMessage((String)"JavaDownloadClient", (String)"getJavaDownloadReportContent"));
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public CancelWorkRequestResponse cancelWorkRequest(CancelWorkRequestRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (CancelWorkRequestResponse)this.clientCall(request, CancelWorkRequestResponse::builder).logger(LOG, "cancelWorkRequest").serviceDetails("JavaDownload", "CancelWorkRequest", "").method(Method.DELETE).requestBuilder(CancelWorkRequestRequest::builder).basePath("/").appendPathParam("20230601").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleResponseHeaderString("opc-request-id", CancelWorkRequestResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateJavaDownloadReportResponse createJavaDownloadReport(CreateJavaDownloadReportRequest request) {
        Objects.requireNonNull(request.getCreateJavaDownloadReportDetails(), "createJavaDownloadReportDetails is required");
        return (CreateJavaDownloadReportResponse)this.clientCall(request, CreateJavaDownloadReportResponse::builder).logger(LOG, "createJavaDownloadReport").serviceDetails("JavaDownload", "CreateJavaDownloadReport", "").method(Method.POST).requestBuilder(CreateJavaDownloadReportRequest::builder).basePath("/").appendPathParam("20230601").appendPathParam("javaDownloadReports").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", CreateJavaDownloadReportResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateJavaDownloadReportResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateJavaDownloadTokenResponse createJavaDownloadToken(CreateJavaDownloadTokenRequest request) {
        Objects.requireNonNull(request.getCreateJavaDownloadTokenDetails(), "createJavaDownloadTokenDetails is required");
        return (CreateJavaDownloadTokenResponse)this.clientCall(request, CreateJavaDownloadTokenResponse::builder).logger(LOG, "createJavaDownloadToken").serviceDetails("JavaDownload", "CreateJavaDownloadToken", "").method(Method.POST).requestBuilder(CreateJavaDownloadTokenRequest::builder).basePath("/").appendPathParam("20230601").appendPathParam("javaDownloadTokens").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(JavaDownloadToken.class, CreateJavaDownloadTokenResponse.Builder::javaDownloadToken).handleResponseHeaderString("etag", CreateJavaDownloadTokenResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", CreateJavaDownloadTokenResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateJavaDownloadTokenResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateJavaLicenseAcceptanceRecordResponse createJavaLicenseAcceptanceRecord(CreateJavaLicenseAcceptanceRecordRequest request) {
        Objects.requireNonNull(request.getCreateJavaLicenseAcceptanceRecordDetails(), "createJavaLicenseAcceptanceRecordDetails is required");
        return (CreateJavaLicenseAcceptanceRecordResponse)this.clientCall(request, CreateJavaLicenseAcceptanceRecordResponse::builder).logger(LOG, "createJavaLicenseAcceptanceRecord").serviceDetails("JavaDownload", "CreateJavaLicenseAcceptanceRecord", "").method(Method.POST).requestBuilder(CreateJavaLicenseAcceptanceRecordRequest::builder).basePath("/").appendPathParam("20230601").appendPathParam("javaLicenseAcceptanceRecords").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(JavaLicenseAcceptanceRecord.class, CreateJavaLicenseAcceptanceRecordResponse.Builder::javaLicenseAcceptanceRecord).handleResponseHeaderString("opc-request-id", CreateJavaLicenseAcceptanceRecordResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreateJavaLicenseAcceptanceRecordResponse.Builder::etag).callSync();
    }

    @Override
    public DeleteJavaDownloadReportResponse deleteJavaDownloadReport(DeleteJavaDownloadReportRequest request) {
        Validate.notBlank((String)request.getJavaDownloadReportId(), (String)"javaDownloadReportId must not be blank", (Object[])new Object[0]);
        return (DeleteJavaDownloadReportResponse)this.clientCall(request, DeleteJavaDownloadReportResponse::builder).logger(LOG, "deleteJavaDownloadReport").serviceDetails("JavaDownload", "DeleteJavaDownloadReport", "").method(Method.DELETE).requestBuilder(DeleteJavaDownloadReportRequest::builder).basePath("/").appendPathParam("20230601").appendPathParam("javaDownloadReports").appendPathParam(request.getJavaDownloadReportId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleResponseHeaderString("opc-work-request-id", DeleteJavaDownloadReportResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteJavaDownloadReportResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteJavaDownloadTokenResponse deleteJavaDownloadToken(DeleteJavaDownloadTokenRequest request) {
        Validate.notBlank((String)request.getJavaDownloadTokenId(), (String)"javaDownloadTokenId must not be blank", (Object[])new Object[0]);
        return (DeleteJavaDownloadTokenResponse)this.clientCall(request, DeleteJavaDownloadTokenResponse::builder).logger(LOG, "deleteJavaDownloadToken").serviceDetails("JavaDownload", "DeleteJavaDownloadToken", "").method(Method.DELETE).requestBuilder(DeleteJavaDownloadTokenRequest::builder).basePath("/").appendPathParam("20230601").appendPathParam("javaDownloadTokens").appendPathParam(request.getJavaDownloadTokenId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleResponseHeaderString("opc-work-request-id", DeleteJavaDownloadTokenResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteJavaDownloadTokenResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteJavaLicenseAcceptanceRecordResponse deleteJavaLicenseAcceptanceRecord(DeleteJavaLicenseAcceptanceRecordRequest request) {
        Validate.notBlank((String)request.getJavaLicenseAcceptanceRecordId(), (String)"javaLicenseAcceptanceRecordId must not be blank", (Object[])new Object[0]);
        return (DeleteJavaLicenseAcceptanceRecordResponse)this.clientCall(request, DeleteJavaLicenseAcceptanceRecordResponse::builder).logger(LOG, "deleteJavaLicenseAcceptanceRecord").serviceDetails("JavaDownload", "DeleteJavaLicenseAcceptanceRecord", "").method(Method.DELETE).requestBuilder(DeleteJavaLicenseAcceptanceRecordRequest::builder).basePath("/").appendPathParam("20230601").appendPathParam("javaLicenseAcceptanceRecords").appendPathParam(request.getJavaLicenseAcceptanceRecordId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleResponseHeaderString("opc-request-id", DeleteJavaLicenseAcceptanceRecordResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GenerateArtifactDownloadUrlResponse generateArtifactDownloadUrl(GenerateArtifactDownloadUrlRequest request) {
        Objects.requireNonNull(request.getGenerateArtifactDownloadUrlDetails(), "generateArtifactDownloadUrlDetails is required");
        return (GenerateArtifactDownloadUrlResponse)this.clientCall(request, GenerateArtifactDownloadUrlResponse::builder).logger(LOG, "generateArtifactDownloadUrl").serviceDetails("JavaDownload", "GenerateArtifactDownloadUrl", "").method(Method.POST).requestBuilder(GenerateArtifactDownloadUrlRequest::builder).basePath("/").appendPathParam("20230601").appendPathParam("actions").appendPathParam("generateArtifactDownloadUrl").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(DownloadUrl.class, GenerateArtifactDownloadUrlResponse.Builder::downloadUrl).handleResponseHeaderString("opc-request-id", GenerateArtifactDownloadUrlResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetJavaDownloadReportResponse getJavaDownloadReport(GetJavaDownloadReportRequest request) {
        Validate.notBlank((String)request.getJavaDownloadReportId(), (String)"javaDownloadReportId must not be blank", (Object[])new Object[0]);
        return (GetJavaDownloadReportResponse)this.clientCall(request, GetJavaDownloadReportResponse::builder).logger(LOG, "getJavaDownloadReport").serviceDetails("JavaDownload", "GetJavaDownloadReport", "").method(Method.GET).requestBuilder(GetJavaDownloadReportRequest::builder).basePath("/").appendPathParam("20230601").appendPathParam("javaDownloadReports").appendPathParam(request.getJavaDownloadReportId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(JavaDownloadReport.class, GetJavaDownloadReportResponse.Builder::javaDownloadReport).handleResponseHeaderString("etag", GetJavaDownloadReportResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetJavaDownloadReportResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetJavaDownloadReportContentResponse getJavaDownloadReportContent(GetJavaDownloadReportContentRequest request) {
        Validate.notBlank((String)request.getJavaDownloadReportId(), (String)"javaDownloadReportId must not be blank", (Object[])new Object[0]);
        return (GetJavaDownloadReportContentResponse)this.clientCall(request, GetJavaDownloadReportContentResponse::builder).logger(LOG, "getJavaDownloadReportContent").serviceDetails("JavaDownload", "GetJavaDownloadReportContent", "").method(Method.GET).requestBuilder(GetJavaDownloadReportContentRequest::builder).basePath("/").appendPathParam("20230601").appendPathParam("javaDownloadReports").appendPathParam(request.getJavaDownloadReportId()).appendPathParam("content").accept(new String[]{"text/csv"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(InputStream.class, GetJavaDownloadReportContentResponse.Builder::inputStream).handleResponseHeaderString("etag", GetJavaDownloadReportContentResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetJavaDownloadReportContentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetJavaDownloadTokenResponse getJavaDownloadToken(GetJavaDownloadTokenRequest request) {
        Validate.notBlank((String)request.getJavaDownloadTokenId(), (String)"javaDownloadTokenId must not be blank", (Object[])new Object[0]);
        return (GetJavaDownloadTokenResponse)this.clientCall(request, GetJavaDownloadTokenResponse::builder).logger(LOG, "getJavaDownloadToken").serviceDetails("JavaDownload", "GetJavaDownloadToken", "").method(Method.GET).requestBuilder(GetJavaDownloadTokenRequest::builder).basePath("/").appendPathParam("20230601").appendPathParam("javaDownloadTokens").appendPathParam(request.getJavaDownloadTokenId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(JavaDownloadToken.class, GetJavaDownloadTokenResponse.Builder::javaDownloadToken).handleResponseHeaderString("etag", GetJavaDownloadTokenResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetJavaDownloadTokenResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetJavaLicenseResponse getJavaLicense(GetJavaLicenseRequest request) {
        Validate.notBlank((String)request.getLicenseType().getValue(), (String)"licenseType must not be blank", (Object[])new Object[0]);
        return (GetJavaLicenseResponse)this.clientCall(request, GetJavaLicenseResponse::builder).logger(LOG, "getJavaLicense").serviceDetails("JavaDownload", "GetJavaLicense", "").method(Method.GET).requestBuilder(GetJavaLicenseRequest::builder).basePath("/").appendPathParam("20230601").appendPathParam("javaLicenses").appendPathParam(request.getLicenseType().getValue()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(JavaLicense.class, GetJavaLicenseResponse.Builder::javaLicense).handleResponseHeaderString("opc-request-id", GetJavaLicenseResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetJavaLicenseAcceptanceRecordResponse getJavaLicenseAcceptanceRecord(GetJavaLicenseAcceptanceRecordRequest request) {
        Validate.notBlank((String)request.getJavaLicenseAcceptanceRecordId(), (String)"javaLicenseAcceptanceRecordId must not be blank", (Object[])new Object[0]);
        return (GetJavaLicenseAcceptanceRecordResponse)this.clientCall(request, GetJavaLicenseAcceptanceRecordResponse::builder).logger(LOG, "getJavaLicenseAcceptanceRecord").serviceDetails("JavaDownload", "GetJavaLicenseAcceptanceRecord", "").method(Method.GET).requestBuilder(GetJavaLicenseAcceptanceRecordRequest::builder).basePath("/").appendPathParam("20230601").appendPathParam("javaLicenseAcceptanceRecords").appendPathParam(request.getJavaLicenseAcceptanceRecordId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(JavaLicenseAcceptanceRecord.class, GetJavaLicenseAcceptanceRecordResponse.Builder::javaLicenseAcceptanceRecord).handleResponseHeaderString("opc-request-id", GetJavaLicenseAcceptanceRecordResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetJavaLicenseAcceptanceRecordResponse.Builder::etag).callSync();
    }

    @Override
    public GetWorkRequestResponse getWorkRequest(GetWorkRequestRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (GetWorkRequestResponse)this.clientCall(request, GetWorkRequestResponse::builder).logger(LOG, "getWorkRequest").serviceDetails("JavaDownload", "GetWorkRequest", "").method(Method.GET).requestBuilder(GetWorkRequestRequest::builder).basePath("/").appendPathParam("20230601").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(WorkRequest.class, GetWorkRequestResponse.Builder::workRequest).handleResponseHeaderString("etag", GetWorkRequestResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetWorkRequestResponse.Builder::opcRequestId).handleResponseHeaderLong("retry-after", GetWorkRequestResponse.Builder::retryAfter).callSync();
    }

    @Override
    public ListJavaDownloadRecordsResponse listJavaDownloadRecords(ListJavaDownloadRecordsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListJavaDownloadRecordsResponse)this.clientCall(request, ListJavaDownloadRecordsResponse::builder).logger(LOG, "listJavaDownloadRecords").serviceDetails("JavaDownload", "ListJavaDownloadRecords", "").method(Method.GET).requestBuilder(ListJavaDownloadRecordsRequest::builder).basePath("/").appendPathParam("20230601").appendPathParam("javaDownloadRecords").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("familyVersion", (Object)request.getFamilyVersion()).appendQueryParam("releaseVersion", (Object)request.getReleaseVersion()).appendQueryParam("osFamily", (Object)request.getOsFamily()).appendQueryParam("architecture", (Object)request.getArchitecture()).appendQueryParam("packageTypeDetail", (Object)request.getPackageTypeDetail()).appendQueryParam("timeStart", (Object)request.getTimeStart()).appendQueryParam("timeEnd", (Object)request.getTimeEnd()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(JavaDownloadRecordCollection.class, ListJavaDownloadRecordsResponse.Builder::javaDownloadRecordCollection).handleResponseHeaderString("opc-request-id", ListJavaDownloadRecordsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListJavaDownloadRecordsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListJavaDownloadReportsResponse listJavaDownloadReports(ListJavaDownloadReportsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListJavaDownloadReportsResponse)this.clientCall(request, ListJavaDownloadReportsResponse::builder).logger(LOG, "listJavaDownloadReports").serviceDetails("JavaDownload", "ListJavaDownloadReports", "").method(Method.GET).requestBuilder(ListJavaDownloadReportsRequest::builder).basePath("/").appendPathParam("20230601").appendPathParam("javaDownloadReports").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("javaDownloadReportId", (Object)request.getJavaDownloadReportId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(JavaDownloadReportCollection.class, ListJavaDownloadReportsResponse.Builder::javaDownloadReportCollection).handleResponseHeaderString("opc-request-id", ListJavaDownloadReportsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListJavaDownloadReportsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListJavaDownloadTokensResponse listJavaDownloadTokens(ListJavaDownloadTokensRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListJavaDownloadTokensResponse)this.clientCall(request, ListJavaDownloadTokensResponse::builder).logger(LOG, "listJavaDownloadTokens").serviceDetails("JavaDownload", "ListJavaDownloadTokens", "").method(Method.GET).requestBuilder(ListJavaDownloadTokensRequest::builder).basePath("/").appendPathParam("20230601").appendPathParam("javaDownloadTokens").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("value", (Object)request.getValue()).appendQueryParam("familyVersion", (Object)request.getFamilyVersion()).appendQueryParam("searchByUser", (Object)request.getSearchByUser()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(JavaDownloadTokenCollection.class, ListJavaDownloadTokensResponse.Builder::javaDownloadTokenCollection).handleResponseHeaderString("opc-request-id", ListJavaDownloadTokensResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListJavaDownloadTokensResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListJavaLicenseAcceptanceRecordsResponse listJavaLicenseAcceptanceRecords(ListJavaLicenseAcceptanceRecordsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListJavaLicenseAcceptanceRecordsResponse)this.clientCall(request, ListJavaLicenseAcceptanceRecordsResponse::builder).logger(LOG, "listJavaLicenseAcceptanceRecords").serviceDetails("JavaDownload", "ListJavaLicenseAcceptanceRecords", "").method(Method.GET).requestBuilder(ListJavaLicenseAcceptanceRecordsRequest::builder).basePath("/").appendPathParam("20230601").appendPathParam("javaLicenseAcceptanceRecords").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("searchByUser", (Object)request.getSearchByUser()).appendQueryParam("id", (Object)request.getId()).appendEnumQueryParam("licenseType", (BmcEnum)request.getLicenseType()).appendEnumQueryParam("status", (BmcEnum)request.getStatus()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(JavaLicenseAcceptanceRecordCollection.class, ListJavaLicenseAcceptanceRecordsResponse.Builder::javaLicenseAcceptanceRecordCollection).handleResponseHeaderString("opc-request-id", ListJavaLicenseAcceptanceRecordsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListJavaLicenseAcceptanceRecordsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListJavaLicensesResponse listJavaLicenses(ListJavaLicensesRequest request) {
        return (ListJavaLicensesResponse)this.clientCall(request, ListJavaLicensesResponse::builder).logger(LOG, "listJavaLicenses").serviceDetails("JavaDownload", "ListJavaLicenses", "").method(Method.GET).requestBuilder(ListJavaLicensesRequest::builder).basePath("/").appendPathParam("20230601").appendPathParam("javaLicenses").appendEnumQueryParam("licenseType", (BmcEnum)request.getLicenseType()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(JavaLicenseCollection.class, ListJavaLicensesResponse.Builder::javaLicenseCollection).handleResponseHeaderString("opc-request-id", ListJavaLicensesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListJavaLicensesResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListWorkRequestErrorsResponse listWorkRequestErrors(ListWorkRequestErrorsRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (ListWorkRequestErrorsResponse)this.clientCall(request, ListWorkRequestErrorsResponse::builder).logger(LOG, "listWorkRequestErrors").serviceDetails("JavaDownload", "ListWorkRequestErrors", "").method(Method.GET).requestBuilder(ListWorkRequestErrorsRequest::builder).basePath("/").appendPathParam("20230601").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("errors").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(WorkRequestErrorCollection.class, ListWorkRequestErrorsResponse.Builder::workRequestErrorCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestErrorsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestErrorsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListWorkRequestLogsResponse listWorkRequestLogs(ListWorkRequestLogsRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (ListWorkRequestLogsResponse)this.clientCall(request, ListWorkRequestLogsResponse::builder).logger(LOG, "listWorkRequestLogs").serviceDetails("JavaDownload", "ListWorkRequestLogs", "").method(Method.GET).requestBuilder(ListWorkRequestLogsRequest::builder).basePath("/").appendPathParam("20230601").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("logs").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(WorkRequestLogEntryCollection.class, ListWorkRequestLogsResponse.Builder::workRequestLogEntryCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestLogsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestLogsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListWorkRequestsResponse listWorkRequests(ListWorkRequestsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListWorkRequestsResponse)this.clientCall(request, ListWorkRequestsResponse::builder).logger(LOG, "listWorkRequests").serviceDetails("JavaDownload", "ListWorkRequests", "").method(Method.GET).requestBuilder(ListWorkRequestsRequest::builder).basePath("/").appendPathParam("20230601").appendPathParam("workRequests").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("id", (Object)request.getId()).appendEnumQueryParam("status", (BmcEnum)request.getStatus()).appendQueryParam("resourceId", (Object)request.getResourceId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(WorkRequestSummaryCollection.class, ListWorkRequestsResponse.Builder::workRequestSummaryCollection).handleResponseHeaderString("opc-request-id", ListWorkRequestsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListWorkRequestsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public RequestSummarizedJavaDownloadCountsResponse requestSummarizedJavaDownloadCounts(RequestSummarizedJavaDownloadCountsRequest request) {
        Objects.requireNonNull(request.getRequestSummarizedJavaDownloadCountsDetails(), "requestSummarizedJavaDownloadCountsDetails is required");
        return (RequestSummarizedJavaDownloadCountsResponse)this.clientCall(request, RequestSummarizedJavaDownloadCountsResponse::builder).logger(LOG, "requestSummarizedJavaDownloadCounts").serviceDetails("JavaDownload", "RequestSummarizedJavaDownloadCounts", "").method(Method.POST).requestBuilder(RequestSummarizedJavaDownloadCountsRequest::builder).basePath("/").appendPathParam("20230601").appendPathParam("actions").appendPathParam("requestSummarizedJavaDownloadCounts").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(JavaDownloadCountAggregationCollection.class, RequestSummarizedJavaDownloadCountsResponse.Builder::javaDownloadCountAggregationCollection).handleResponseHeaderString("opc-request-id", RequestSummarizedJavaDownloadCountsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", RequestSummarizedJavaDownloadCountsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public UpdateJavaDownloadTokenResponse updateJavaDownloadToken(UpdateJavaDownloadTokenRequest request) {
        Validate.notBlank((String)request.getJavaDownloadTokenId(), (String)"javaDownloadTokenId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateJavaDownloadTokenDetails(), "updateJavaDownloadTokenDetails is required");
        return (UpdateJavaDownloadTokenResponse)this.clientCall(request, UpdateJavaDownloadTokenResponse::builder).logger(LOG, "updateJavaDownloadToken").serviceDetails("JavaDownload", "UpdateJavaDownloadToken", "").method(Method.PUT).requestBuilder(UpdateJavaDownloadTokenRequest::builder).basePath("/").appendPathParam("20230601").appendPathParam("javaDownloadTokens").appendPathParam(request.getJavaDownloadTokenId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", UpdateJavaDownloadTokenResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateJavaDownloadTokenResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateJavaLicenseAcceptanceRecordResponse updateJavaLicenseAcceptanceRecord(UpdateJavaLicenseAcceptanceRecordRequest request) {
        Validate.notBlank((String)request.getJavaLicenseAcceptanceRecordId(), (String)"javaLicenseAcceptanceRecordId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateJavaLicenseAcceptanceRecordDetails(), "updateJavaLicenseAcceptanceRecordDetails is required");
        return (UpdateJavaLicenseAcceptanceRecordResponse)this.clientCall(request, UpdateJavaLicenseAcceptanceRecordResponse::builder).logger(LOG, "updateJavaLicenseAcceptanceRecord").serviceDetails("JavaDownload", "UpdateJavaLicenseAcceptanceRecord", "").method(Method.PUT).requestBuilder(UpdateJavaLicenseAcceptanceRecordRequest::builder).basePath("/").appendPathParam("20230601").appendPathParam("javaLicenseAcceptanceRecords").appendPathParam(request.getJavaLicenseAcceptanceRecordId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(JavaLicenseAcceptanceRecord.class, UpdateJavaLicenseAcceptanceRecordResponse.Builder::javaLicenseAcceptanceRecord).handleResponseHeaderString("opc-request-id", UpdateJavaLicenseAcceptanceRecordResponse.Builder::opcRequestId).handleResponseHeaderString("etag", UpdateJavaLicenseAcceptanceRecordResponse.Builder::etag).callSync();
    }

    @Override
    public JavaDownloadWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public JavaDownloadPaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public JavaDownloadClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)JavaDownloadClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public JavaDownloadClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(JavaDownloadClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public JavaDownloadClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)JavaDownloadClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public JavaDownloadClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)JavaDownloadClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider, null);
    }

    @Deprecated
    public JavaDownloadClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)JavaDownloadClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider, null);
    }

    @Deprecated
    public JavaDownloadClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)JavaDownloadClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider, null);
    }

    @Deprecated
    public JavaDownloadClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)JavaDownloadClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, null);
    }

    @Deprecated
    public JavaDownloadClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)JavaDownloadClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, executorService);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, JavaDownloadClient> {
        private boolean isStreamWarningEnabled = true;
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            String packageName = "jmsjavadownloads";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"jmsjavadownloads");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public Builder isStreamWarningEnabled(boolean isStreamWarningEnabled) {
            this.isStreamWarningEnabled = isStreamWarningEnabled;
            return this;
        }

        public JavaDownloadClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new JavaDownloadClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider, this.executorService, this.isStreamWarningEnabled);
        }
    }
}

