/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.jmsjavadownloads;

import com.oracle.bmc.jmsjavadownloads.JavaDownload;
import com.oracle.bmc.jmsjavadownloads.model.LifecycleState;
import com.oracle.bmc.jmsjavadownloads.requests.GetJavaDownloadReportRequest;
import com.oracle.bmc.jmsjavadownloads.requests.GetJavaDownloadTokenRequest;
import com.oracle.bmc.jmsjavadownloads.requests.GetJavaLicenseAcceptanceRecordRequest;
import com.oracle.bmc.jmsjavadownloads.requests.GetWorkRequestRequest;
import com.oracle.bmc.jmsjavadownloads.responses.GetJavaDownloadReportResponse;
import com.oracle.bmc.jmsjavadownloads.responses.GetJavaDownloadTokenResponse;
import com.oracle.bmc.jmsjavadownloads.responses.GetJavaLicenseAcceptanceRecordResponse;
import com.oracle.bmc.jmsjavadownloads.responses.GetWorkRequestResponse;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class JavaDownloadWaiters {
    private final ExecutorService executorService;
    private final JavaDownload client;

    public JavaDownloadWaiters(ExecutorService executorService, JavaDownload client) {
        this.executorService = executorService;
        this.client = client;
    }

    public Waiter<GetJavaDownloadReportRequest, GetJavaDownloadReportResponse> forJavaDownloadReport(GetJavaDownloadReportRequest request, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forJavaDownloadReport(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetJavaDownloadReportRequest, GetJavaDownloadReportResponse> forJavaDownloadReport(GetJavaDownloadReportRequest request, LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forJavaDownloadReport(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetJavaDownloadReportRequest, GetJavaDownloadReportResponse> forJavaDownloadReport(GetJavaDownloadReportRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forJavaDownloadReport(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetJavaDownloadReportRequest, GetJavaDownloadReportResponse> forJavaDownloadReport(BmcGenericWaiter waiter, GetJavaDownloadReportRequest request, LifecycleState ... targetStates) {
        final HashSet<LifecycleState> targetStatesSet = new HashSet<LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetJavaDownloadReportRequest, GetJavaDownloadReportResponse>(){

            @Override
            public GetJavaDownloadReportResponse apply(GetJavaDownloadReportRequest request) {
                return JavaDownloadWaiters.this.client.getJavaDownloadReport(request);
            }
        }, (Predicate)new Predicate<GetJavaDownloadReportResponse>(){

            @Override
            public boolean test(GetJavaDownloadReportResponse response) {
                return targetStatesSet.contains((Object)response.getJavaDownloadReport().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetJavaDownloadTokenRequest, GetJavaDownloadTokenResponse> forJavaDownloadToken(GetJavaDownloadTokenRequest request, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forJavaDownloadToken(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetJavaDownloadTokenRequest, GetJavaDownloadTokenResponse> forJavaDownloadToken(GetJavaDownloadTokenRequest request, LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forJavaDownloadToken(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetJavaDownloadTokenRequest, GetJavaDownloadTokenResponse> forJavaDownloadToken(GetJavaDownloadTokenRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forJavaDownloadToken(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetJavaDownloadTokenRequest, GetJavaDownloadTokenResponse> forJavaDownloadToken(BmcGenericWaiter waiter, GetJavaDownloadTokenRequest request, LifecycleState ... targetStates) {
        final HashSet<LifecycleState> targetStatesSet = new HashSet<LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetJavaDownloadTokenRequest, GetJavaDownloadTokenResponse>(){

            @Override
            public GetJavaDownloadTokenResponse apply(GetJavaDownloadTokenRequest request) {
                return JavaDownloadWaiters.this.client.getJavaDownloadToken(request);
            }
        }, (Predicate)new Predicate<GetJavaDownloadTokenResponse>(){

            @Override
            public boolean test(GetJavaDownloadTokenResponse response) {
                return targetStatesSet.contains((Object)response.getJavaDownloadToken().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetJavaLicenseAcceptanceRecordRequest, GetJavaLicenseAcceptanceRecordResponse> forJavaLicenseAcceptanceRecord(GetJavaLicenseAcceptanceRecordRequest request, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forJavaLicenseAcceptanceRecord(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetJavaLicenseAcceptanceRecordRequest, GetJavaLicenseAcceptanceRecordResponse> forJavaLicenseAcceptanceRecord(GetJavaLicenseAcceptanceRecordRequest request, LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forJavaLicenseAcceptanceRecord(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetJavaLicenseAcceptanceRecordRequest, GetJavaLicenseAcceptanceRecordResponse> forJavaLicenseAcceptanceRecord(GetJavaLicenseAcceptanceRecordRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forJavaLicenseAcceptanceRecord(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetJavaLicenseAcceptanceRecordRequest, GetJavaLicenseAcceptanceRecordResponse> forJavaLicenseAcceptanceRecord(BmcGenericWaiter waiter, GetJavaLicenseAcceptanceRecordRequest request, LifecycleState ... targetStates) {
        final HashSet<LifecycleState> targetStatesSet = new HashSet<LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetJavaLicenseAcceptanceRecordRequest, GetJavaLicenseAcceptanceRecordResponse>(){

            @Override
            public GetJavaLicenseAcceptanceRecordResponse apply(GetJavaLicenseAcceptanceRecordRequest request) {
                return JavaDownloadWaiters.this.client.getJavaLicenseAcceptanceRecord(request);
            }
        }, (Predicate)new Predicate<GetJavaLicenseAcceptanceRecordResponse>(){

            @Override
            public boolean test(GetJavaLicenseAcceptanceRecordResponse response) {
                return targetStatesSet.contains((Object)response.getJavaLicenseAcceptanceRecord().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request) {
        return this.forWorkRequest(Waiters.DEFAULT_POLLING_WAITER, request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        return this.forWorkRequest(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request);
    }

    private Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(BmcGenericWaiter waiter, GetWorkRequestRequest request) {
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetWorkRequestRequest, GetWorkRequestResponse>(){

            @Override
            public GetWorkRequestResponse apply(GetWorkRequestRequest request) {
                return JavaDownloadWaiters.this.client.getWorkRequest(request);
            }
        }, (Predicate)new Predicate<GetWorkRequestResponse>(){

            @Override
            public boolean test(GetWorkRequestResponse response) {
                return response.getWorkRequest().getTimeFinished() != null;
            }
        }, false), (Object)request);
    }
}

