/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.jmsjavadownloads.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.jmsjavadownloads.model.JavaDownloadCountAggregation;
import com.oracle.bmc.jmsjavadownloads.model.JavaDownloadCountAggregationType;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class JavaDownloadCountAggregationCollection
extends ExplicitlySetBmcModel {
    @JsonProperty(value="aggregationType")
    private final JavaDownloadCountAggregationType aggregationType;
    @JsonProperty(value="items")
    private final List<JavaDownloadCountAggregation> items;

    @Deprecated
    @ConstructorProperties(value={"aggregationType", "items"})
    public JavaDownloadCountAggregationCollection(JavaDownloadCountAggregationType aggregationType, List<JavaDownloadCountAggregation> items) {
        this.aggregationType = aggregationType;
        this.items = items;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public JavaDownloadCountAggregationType getAggregationType() {
        return this.aggregationType;
    }

    public List<JavaDownloadCountAggregation> getItems() {
        return this.items;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("JavaDownloadCountAggregationCollection(");
        sb.append("super=").append(super.toString());
        sb.append("aggregationType=").append(String.valueOf((Object)this.aggregationType));
        sb.append(", items=").append(String.valueOf(this.items));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JavaDownloadCountAggregationCollection)) {
            return false;
        }
        JavaDownloadCountAggregationCollection other = (JavaDownloadCountAggregationCollection)((Object)o);
        return Objects.equals((Object)this.aggregationType, (Object)other.aggregationType) && Objects.equals(this.items, other.items) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.aggregationType == null ? 43 : this.aggregationType.hashCode());
        result = result * 59 + (this.items == null ? 43 : this.items.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="aggregationType")
        private JavaDownloadCountAggregationType aggregationType;
        @JsonProperty(value="items")
        private List<JavaDownloadCountAggregation> items;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder aggregationType(JavaDownloadCountAggregationType aggregationType) {
            this.aggregationType = aggregationType;
            this.__explicitlySet__.add("aggregationType");
            return this;
        }

        public Builder items(List<JavaDownloadCountAggregation> items) {
            this.items = items;
            this.__explicitlySet__.add("items");
            return this;
        }

        public JavaDownloadCountAggregationCollection build() {
            JavaDownloadCountAggregationCollection model = new JavaDownloadCountAggregationCollection(this.aggregationType, this.items);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(JavaDownloadCountAggregationCollection model) {
            if (model.wasPropertyExplicitlySet("aggregationType")) {
                this.aggregationType(model.getAggregationType());
            }
            if (model.wasPropertyExplicitlySet("items")) {
                this.items(model.getItems());
            }
            return this;
        }
    }
}

