/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.jmsjavadownloads.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class JavaDownloadRecordSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="familyVersion")
    private final String familyVersion;
    @JsonProperty(value="familyDisplayName")
    private final String familyDisplayName;
    @JsonProperty(value="releaseVersion")
    private final String releaseVersion;
    @JsonProperty(value="osFamily")
    private final String osFamily;
    @JsonProperty(value="architecture")
    private final String architecture;
    @JsonProperty(value="packageType")
    private final String packageType;
    @JsonProperty(value="packageTypeDetail")
    private final String packageTypeDetail;
    @JsonProperty(value="downloadSourceId")
    private final String downloadSourceId;
    @JsonProperty(value="timeDownloaded")
    private final Date timeDownloaded;
    @JsonProperty(value="downloadType")
    private final String downloadType;

    @Deprecated
    @ConstructorProperties(value={"familyVersion", "familyDisplayName", "releaseVersion", "osFamily", "architecture", "packageType", "packageTypeDetail", "downloadSourceId", "timeDownloaded", "downloadType"})
    public JavaDownloadRecordSummary(String familyVersion, String familyDisplayName, String releaseVersion, String osFamily, String architecture, String packageType, String packageTypeDetail, String downloadSourceId, Date timeDownloaded, String downloadType) {
        this.familyVersion = familyVersion;
        this.familyDisplayName = familyDisplayName;
        this.releaseVersion = releaseVersion;
        this.osFamily = osFamily;
        this.architecture = architecture;
        this.packageType = packageType;
        this.packageTypeDetail = packageTypeDetail;
        this.downloadSourceId = downloadSourceId;
        this.timeDownloaded = timeDownloaded;
        this.downloadType = downloadType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getFamilyVersion() {
        return this.familyVersion;
    }

    public String getFamilyDisplayName() {
        return this.familyDisplayName;
    }

    public String getReleaseVersion() {
        return this.releaseVersion;
    }

    public String getOsFamily() {
        return this.osFamily;
    }

    public String getArchitecture() {
        return this.architecture;
    }

    public String getPackageType() {
        return this.packageType;
    }

    public String getPackageTypeDetail() {
        return this.packageTypeDetail;
    }

    public String getDownloadSourceId() {
        return this.downloadSourceId;
    }

    public Date getTimeDownloaded() {
        return this.timeDownloaded;
    }

    public String getDownloadType() {
        return this.downloadType;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("JavaDownloadRecordSummary(");
        sb.append("super=").append(super.toString());
        sb.append("familyVersion=").append(String.valueOf(this.familyVersion));
        sb.append(", familyDisplayName=").append(String.valueOf(this.familyDisplayName));
        sb.append(", releaseVersion=").append(String.valueOf(this.releaseVersion));
        sb.append(", osFamily=").append(String.valueOf(this.osFamily));
        sb.append(", architecture=").append(String.valueOf(this.architecture));
        sb.append(", packageType=").append(String.valueOf(this.packageType));
        sb.append(", packageTypeDetail=").append(String.valueOf(this.packageTypeDetail));
        sb.append(", downloadSourceId=").append(String.valueOf(this.downloadSourceId));
        sb.append(", timeDownloaded=").append(String.valueOf(this.timeDownloaded));
        sb.append(", downloadType=").append(String.valueOf(this.downloadType));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JavaDownloadRecordSummary)) {
            return false;
        }
        JavaDownloadRecordSummary other = (JavaDownloadRecordSummary)((Object)o);
        return Objects.equals(this.familyVersion, other.familyVersion) && Objects.equals(this.familyDisplayName, other.familyDisplayName) && Objects.equals(this.releaseVersion, other.releaseVersion) && Objects.equals(this.osFamily, other.osFamily) && Objects.equals(this.architecture, other.architecture) && Objects.equals(this.packageType, other.packageType) && Objects.equals(this.packageTypeDetail, other.packageTypeDetail) && Objects.equals(this.downloadSourceId, other.downloadSourceId) && Objects.equals(this.timeDownloaded, other.timeDownloaded) && Objects.equals(this.downloadType, other.downloadType) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.familyVersion == null ? 43 : this.familyVersion.hashCode());
        result = result * 59 + (this.familyDisplayName == null ? 43 : this.familyDisplayName.hashCode());
        result = result * 59 + (this.releaseVersion == null ? 43 : this.releaseVersion.hashCode());
        result = result * 59 + (this.osFamily == null ? 43 : this.osFamily.hashCode());
        result = result * 59 + (this.architecture == null ? 43 : this.architecture.hashCode());
        result = result * 59 + (this.packageType == null ? 43 : this.packageType.hashCode());
        result = result * 59 + (this.packageTypeDetail == null ? 43 : this.packageTypeDetail.hashCode());
        result = result * 59 + (this.downloadSourceId == null ? 43 : this.downloadSourceId.hashCode());
        result = result * 59 + (this.timeDownloaded == null ? 43 : this.timeDownloaded.hashCode());
        result = result * 59 + (this.downloadType == null ? 43 : this.downloadType.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="familyVersion")
        private String familyVersion;
        @JsonProperty(value="familyDisplayName")
        private String familyDisplayName;
        @JsonProperty(value="releaseVersion")
        private String releaseVersion;
        @JsonProperty(value="osFamily")
        private String osFamily;
        @JsonProperty(value="architecture")
        private String architecture;
        @JsonProperty(value="packageType")
        private String packageType;
        @JsonProperty(value="packageTypeDetail")
        private String packageTypeDetail;
        @JsonProperty(value="downloadSourceId")
        private String downloadSourceId;
        @JsonProperty(value="timeDownloaded")
        private Date timeDownloaded;
        @JsonProperty(value="downloadType")
        private String downloadType;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder familyVersion(String familyVersion) {
            this.familyVersion = familyVersion;
            this.__explicitlySet__.add("familyVersion");
            return this;
        }

        public Builder familyDisplayName(String familyDisplayName) {
            this.familyDisplayName = familyDisplayName;
            this.__explicitlySet__.add("familyDisplayName");
            return this;
        }

        public Builder releaseVersion(String releaseVersion) {
            this.releaseVersion = releaseVersion;
            this.__explicitlySet__.add("releaseVersion");
            return this;
        }

        public Builder osFamily(String osFamily) {
            this.osFamily = osFamily;
            this.__explicitlySet__.add("osFamily");
            return this;
        }

        public Builder architecture(String architecture) {
            this.architecture = architecture;
            this.__explicitlySet__.add("architecture");
            return this;
        }

        public Builder packageType(String packageType) {
            this.packageType = packageType;
            this.__explicitlySet__.add("packageType");
            return this;
        }

        public Builder packageTypeDetail(String packageTypeDetail) {
            this.packageTypeDetail = packageTypeDetail;
            this.__explicitlySet__.add("packageTypeDetail");
            return this;
        }

        public Builder downloadSourceId(String downloadSourceId) {
            this.downloadSourceId = downloadSourceId;
            this.__explicitlySet__.add("downloadSourceId");
            return this;
        }

        public Builder timeDownloaded(Date timeDownloaded) {
            this.timeDownloaded = timeDownloaded;
            this.__explicitlySet__.add("timeDownloaded");
            return this;
        }

        public Builder downloadType(String downloadType) {
            this.downloadType = downloadType;
            this.__explicitlySet__.add("downloadType");
            return this;
        }

        public JavaDownloadRecordSummary build() {
            JavaDownloadRecordSummary model = new JavaDownloadRecordSummary(this.familyVersion, this.familyDisplayName, this.releaseVersion, this.osFamily, this.architecture, this.packageType, this.packageTypeDetail, this.downloadSourceId, this.timeDownloaded, this.downloadType);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(JavaDownloadRecordSummary model) {
            if (model.wasPropertyExplicitlySet("familyVersion")) {
                this.familyVersion(model.getFamilyVersion());
            }
            if (model.wasPropertyExplicitlySet("familyDisplayName")) {
                this.familyDisplayName(model.getFamilyDisplayName());
            }
            if (model.wasPropertyExplicitlySet("releaseVersion")) {
                this.releaseVersion(model.getReleaseVersion());
            }
            if (model.wasPropertyExplicitlySet("osFamily")) {
                this.osFamily(model.getOsFamily());
            }
            if (model.wasPropertyExplicitlySet("architecture")) {
                this.architecture(model.getArchitecture());
            }
            if (model.wasPropertyExplicitlySet("packageType")) {
                this.packageType(model.getPackageType());
            }
            if (model.wasPropertyExplicitlySet("packageTypeDetail")) {
                this.packageTypeDetail(model.getPackageTypeDetail());
            }
            if (model.wasPropertyExplicitlySet("downloadSourceId")) {
                this.downloadSourceId(model.getDownloadSourceId());
            }
            if (model.wasPropertyExplicitlySet("timeDownloaded")) {
                this.timeDownloaded(model.getTimeDownloaded());
            }
            if (model.wasPropertyExplicitlySet("downloadType")) {
                this.downloadType(model.getDownloadType());
            }
            return this;
        }
    }
}

