/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.jmsjavadownloads.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetJavaDownloadReportContentRequest
extends BmcRequest<Void> {
    private String javaDownloadReportId;
    private String opcRequestId;

    public String getJavaDownloadReportId() {
        return this.javaDownloadReportId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().javaDownloadReportId(this.javaDownloadReportId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",javaDownloadReportId=").append(String.valueOf(this.javaDownloadReportId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetJavaDownloadReportContentRequest)) {
            return false;
        }
        GetJavaDownloadReportContentRequest other = (GetJavaDownloadReportContentRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.javaDownloadReportId, other.javaDownloadReportId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.javaDownloadReportId == null ? 43 : this.javaDownloadReportId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetJavaDownloadReportContentRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String javaDownloadReportId = null;
        private String opcRequestId = null;

        public Builder javaDownloadReportId(String javaDownloadReportId) {
            this.javaDownloadReportId = javaDownloadReportId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetJavaDownloadReportContentRequest o) {
            this.javaDownloadReportId(o.getJavaDownloadReportId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetJavaDownloadReportContentRequest build() {
            GetJavaDownloadReportContentRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetJavaDownloadReportContentRequest buildWithoutInvocationCallback() {
            GetJavaDownloadReportContentRequest request = new GetJavaDownloadReportContentRequest();
            request.javaDownloadReportId = this.javaDownloadReportId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

