/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.jmsjavadownloads.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.jmsjavadownloads.model.LicenseType;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetJavaLicenseRequest
extends BmcRequest<Void> {
    private LicenseType licenseType;
    private String opcRequestId;

    public LicenseType getLicenseType() {
        return this.licenseType;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().licenseType(this.licenseType).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",licenseType=").append(String.valueOf((Object)this.licenseType));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetJavaLicenseRequest)) {
            return false;
        }
        GetJavaLicenseRequest other = (GetJavaLicenseRequest)((Object)o);
        return super.equals(o) && Objects.equals((Object)this.licenseType, (Object)other.licenseType) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.licenseType == null ? 43 : this.licenseType.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetJavaLicenseRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private LicenseType licenseType = null;
        private String opcRequestId = null;

        public Builder licenseType(LicenseType licenseType) {
            this.licenseType = licenseType;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetJavaLicenseRequest o) {
            this.licenseType(o.getLicenseType());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetJavaLicenseRequest build() {
            GetJavaLicenseRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetJavaLicenseRequest buildWithoutInvocationCallback() {
            GetJavaLicenseRequest request = new GetJavaLicenseRequest();
            request.licenseType = this.licenseType;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

