/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.jmsjavadownloads.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.jmsjavadownloads.model.JavaDownloadRecordSortBy;
import com.oracle.bmc.jmsjavadownloads.model.SortOrder;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Date;
import java.util.Objects;

public class ListJavaDownloadRecordsRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private String familyVersion;
    private String releaseVersion;
    private String osFamily;
    private String architecture;
    private String packageTypeDetail;
    private Date timeStart;
    private Date timeEnd;
    private Integer limit;
    private String page;
    private SortOrder sortOrder;
    private JavaDownloadRecordSortBy sortBy;
    private String opcRequestId;

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getFamilyVersion() {
        return this.familyVersion;
    }

    public String getReleaseVersion() {
        return this.releaseVersion;
    }

    public String getOsFamily() {
        return this.osFamily;
    }

    public String getArchitecture() {
        return this.architecture;
    }

    public String getPackageTypeDetail() {
        return this.packageTypeDetail;
    }

    public Date getTimeStart() {
        return this.timeStart;
    }

    public Date getTimeEnd() {
        return this.timeEnd;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public JavaDownloadRecordSortBy getSortBy() {
        return this.sortBy;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().compartmentId(this.compartmentId).familyVersion(this.familyVersion).releaseVersion(this.releaseVersion).osFamily(this.osFamily).architecture(this.architecture).packageTypeDetail(this.packageTypeDetail).timeStart(this.timeStart).timeEnd(this.timeEnd).limit(this.limit).page(this.page).sortOrder(this.sortOrder).sortBy(this.sortBy).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",familyVersion=").append(String.valueOf(this.familyVersion));
        sb.append(",releaseVersion=").append(String.valueOf(this.releaseVersion));
        sb.append(",osFamily=").append(String.valueOf(this.osFamily));
        sb.append(",architecture=").append(String.valueOf(this.architecture));
        sb.append(",packageTypeDetail=").append(String.valueOf(this.packageTypeDetail));
        sb.append(",timeStart=").append(String.valueOf(this.timeStart));
        sb.append(",timeEnd=").append(String.valueOf(this.timeEnd));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListJavaDownloadRecordsRequest)) {
            return false;
        }
        ListJavaDownloadRecordsRequest other = (ListJavaDownloadRecordsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.familyVersion, other.familyVersion) && Objects.equals(this.releaseVersion, other.releaseVersion) && Objects.equals(this.osFamily, other.osFamily) && Objects.equals(this.architecture, other.architecture) && Objects.equals(this.packageTypeDetail, other.packageTypeDetail) && Objects.equals(this.timeStart, other.timeStart) && Objects.equals(this.timeEnd, other.timeEnd) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.familyVersion == null ? 43 : this.familyVersion.hashCode());
        result = result * 59 + (this.releaseVersion == null ? 43 : this.releaseVersion.hashCode());
        result = result * 59 + (this.osFamily == null ? 43 : this.osFamily.hashCode());
        result = result * 59 + (this.architecture == null ? 43 : this.architecture.hashCode());
        result = result * 59 + (this.packageTypeDetail == null ? 43 : this.packageTypeDetail.hashCode());
        result = result * 59 + (this.timeStart == null ? 43 : this.timeStart.hashCode());
        result = result * 59 + (this.timeEnd == null ? 43 : this.timeEnd.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListJavaDownloadRecordsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String compartmentId = null;
        private String familyVersion = null;
        private String releaseVersion = null;
        private String osFamily = null;
        private String architecture = null;
        private String packageTypeDetail = null;
        private Date timeStart = null;
        private Date timeEnd = null;
        private Integer limit = null;
        private String page = null;
        private SortOrder sortOrder = null;
        private JavaDownloadRecordSortBy sortBy = null;
        private String opcRequestId = null;

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder familyVersion(String familyVersion) {
            this.familyVersion = familyVersion;
            return this;
        }

        public Builder releaseVersion(String releaseVersion) {
            this.releaseVersion = releaseVersion;
            return this;
        }

        public Builder osFamily(String osFamily) {
            this.osFamily = osFamily;
            return this;
        }

        public Builder architecture(String architecture) {
            this.architecture = architecture;
            return this;
        }

        public Builder packageTypeDetail(String packageTypeDetail) {
            this.packageTypeDetail = packageTypeDetail;
            return this;
        }

        public Builder timeStart(Date timeStart) {
            this.timeStart = timeStart;
            return this;
        }

        public Builder timeEnd(Date timeEnd) {
            this.timeEnd = timeEnd;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortBy(JavaDownloadRecordSortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListJavaDownloadRecordsRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.familyVersion(o.getFamilyVersion());
            this.releaseVersion(o.getReleaseVersion());
            this.osFamily(o.getOsFamily());
            this.architecture(o.getArchitecture());
            this.packageTypeDetail(o.getPackageTypeDetail());
            this.timeStart(o.getTimeStart());
            this.timeEnd(o.getTimeEnd());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.sortOrder(o.getSortOrder());
            this.sortBy(o.getSortBy());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListJavaDownloadRecordsRequest build() {
            ListJavaDownloadRecordsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListJavaDownloadRecordsRequest buildWithoutInvocationCallback() {
            ListJavaDownloadRecordsRequest request = new ListJavaDownloadRecordsRequest();
            request.compartmentId = this.compartmentId;
            request.familyVersion = this.familyVersion;
            request.releaseVersion = this.releaseVersion;
            request.osFamily = this.osFamily;
            request.architecture = this.architecture;
            request.packageTypeDetail = this.packageTypeDetail;
            request.timeStart = this.timeStart;
            request.timeEnd = this.timeEnd;
            request.limit = this.limit;
            request.page = this.page;
            request.sortOrder = this.sortOrder;
            request.sortBy = this.sortBy;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

