/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.jmsjavadownloads.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.jmsjavadownloads.model.LicenseAcceptanceSortBy;
import com.oracle.bmc.jmsjavadownloads.model.LicenseAcceptanceStatus;
import com.oracle.bmc.jmsjavadownloads.model.LicenseType;
import com.oracle.bmc.jmsjavadownloads.model.SortOrder;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class ListJavaLicenseAcceptanceRecordsRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private String searchByUser;
    private String id;
    private LicenseType licenseType;
    private LicenseAcceptanceStatus status;
    private Integer limit;
    private String page;
    private SortOrder sortOrder;
    private LicenseAcceptanceSortBy sortBy;
    private String opcRequestId;

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getSearchByUser() {
        return this.searchByUser;
    }

    public String getId() {
        return this.id;
    }

    public LicenseType getLicenseType() {
        return this.licenseType;
    }

    public LicenseAcceptanceStatus getStatus() {
        return this.status;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public LicenseAcceptanceSortBy getSortBy() {
        return this.sortBy;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().compartmentId(this.compartmentId).searchByUser(this.searchByUser).id(this.id).licenseType(this.licenseType).status(this.status).limit(this.limit).page(this.page).sortOrder(this.sortOrder).sortBy(this.sortBy).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",searchByUser=").append(String.valueOf(this.searchByUser));
        sb.append(",id=").append(String.valueOf(this.id));
        sb.append(",licenseType=").append(String.valueOf((Object)this.licenseType));
        sb.append(",status=").append(String.valueOf((Object)this.status));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListJavaLicenseAcceptanceRecordsRequest)) {
            return false;
        }
        ListJavaLicenseAcceptanceRecordsRequest other = (ListJavaLicenseAcceptanceRecordsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.searchByUser, other.searchByUser) && Objects.equals(this.id, other.id) && Objects.equals((Object)this.licenseType, (Object)other.licenseType) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.searchByUser == null ? 43 : this.searchByUser.hashCode());
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.licenseType == null ? 43 : this.licenseType.hashCode());
        result = result * 59 + (this.status == null ? 43 : this.status.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListJavaLicenseAcceptanceRecordsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String compartmentId = null;
        private String searchByUser = null;
        private String id = null;
        private LicenseType licenseType = null;
        private LicenseAcceptanceStatus status = null;
        private Integer limit = null;
        private String page = null;
        private SortOrder sortOrder = null;
        private LicenseAcceptanceSortBy sortBy = null;
        private String opcRequestId = null;

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder searchByUser(String searchByUser) {
            this.searchByUser = searchByUser;
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder licenseType(LicenseType licenseType) {
            this.licenseType = licenseType;
            return this;
        }

        public Builder status(LicenseAcceptanceStatus status) {
            this.status = status;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortBy(LicenseAcceptanceSortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListJavaLicenseAcceptanceRecordsRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.searchByUser(o.getSearchByUser());
            this.id(o.getId());
            this.licenseType(o.getLicenseType());
            this.status(o.getStatus());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.sortOrder(o.getSortOrder());
            this.sortBy(o.getSortBy());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListJavaLicenseAcceptanceRecordsRequest build() {
            ListJavaLicenseAcceptanceRecordsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListJavaLicenseAcceptanceRecordsRequest buildWithoutInvocationCallback() {
            ListJavaLicenseAcceptanceRecordsRequest request = new ListJavaLicenseAcceptanceRecordsRequest();
            request.compartmentId = this.compartmentId;
            request.searchByUser = this.searchByUser;
            request.id = this.id;
            request.licenseType = this.licenseType;
            request.status = this.status;
            request.limit = this.limit;
            request.page = this.page;
            request.sortOrder = this.sortOrder;
            request.sortBy = this.sortBy;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

