/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.keymanagement;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.oracle.bmc.keymanagement.KmsVault;
import com.oracle.bmc.keymanagement.model.VaultSummary;
import com.oracle.bmc.keymanagement.requests.ListVaultsRequest;
import com.oracle.bmc.keymanagement.responses.ListVaultsResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.beans.ConstructorProperties;
import java.util.List;

public class KmsVaultPaginators {
    private final KmsVault client;

    public Iterable<ListVaultsResponse> listVaultsResponseIterator(final ListVaultsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListVaultsRequest.Builder>(){

            public ListVaultsRequest.Builder get() {
                return ListVaultsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListVaultsResponse, String>(){

            public String apply(ListVaultsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListVaultsRequest.Builder>, ListVaultsRequest>(){

            public ListVaultsRequest apply(RequestBuilderAndToken<ListVaultsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListVaultsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListVaultsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListVaultsRequest, ListVaultsResponse>(){

            public ListVaultsResponse apply(ListVaultsRequest request) {
                return KmsVaultPaginators.this.client.listVaults(request);
            }
        });
    }

    public Iterable<VaultSummary> listVaultsRecordIterator(final ListVaultsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListVaultsRequest.Builder>(){

            public ListVaultsRequest.Builder get() {
                return ListVaultsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListVaultsResponse, String>(){

            public String apply(ListVaultsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListVaultsRequest.Builder>, ListVaultsRequest>(){

            public ListVaultsRequest apply(RequestBuilderAndToken<ListVaultsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListVaultsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListVaultsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListVaultsRequest, ListVaultsResponse>(){

            public ListVaultsResponse apply(ListVaultsRequest request) {
                return KmsVaultPaginators.this.client.listVaults(request);
            }
        }, (Function)new Function<ListVaultsResponse, List<VaultSummary>>(){

            public List<VaultSummary> apply(ListVaultsResponse response) {
                return response.getItems();
            }
        });
    }

    @ConstructorProperties(value={"client"})
    public KmsVaultPaginators(KmsVault client) {
        this.client = client;
    }
}

