/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.keymanagement.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class DecryptedData {
    @JsonProperty(value="plaintext")
    private final String plaintext;
    @JsonProperty(value="plaintextChecksum")
    private final String plaintextChecksum;
    @JsonProperty(value="keyId")
    private final String keyId;
    @JsonProperty(value="keyVersionId")
    private final String keyVersionId;
    @JsonProperty(value="encryptionAlgorithm")
    private final EncryptionAlgorithm encryptionAlgorithm;
    @JsonIgnore
    private final Set<String> __explicitlySet__ = new HashSet<String>();

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().plaintext(this.plaintext).plaintextChecksum(this.plaintextChecksum).keyId(this.keyId).keyVersionId(this.keyVersionId).encryptionAlgorithm(this.encryptionAlgorithm);
    }

    public String getPlaintext() {
        return this.plaintext;
    }

    public String getPlaintextChecksum() {
        return this.plaintextChecksum;
    }

    public String getKeyId() {
        return this.keyId;
    }

    public String getKeyVersionId() {
        return this.keyVersionId;
    }

    public EncryptionAlgorithm getEncryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    public Set<String> get__explicitlySet__() {
        return this.__explicitlySet__;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DecryptedData)) {
            return false;
        }
        DecryptedData other = (DecryptedData)o;
        String this$plaintext = this.getPlaintext();
        String other$plaintext = other.getPlaintext();
        if (this$plaintext == null ? other$plaintext != null : !this$plaintext.equals(other$plaintext)) {
            return false;
        }
        String this$plaintextChecksum = this.getPlaintextChecksum();
        String other$plaintextChecksum = other.getPlaintextChecksum();
        if (this$plaintextChecksum == null ? other$plaintextChecksum != null : !this$plaintextChecksum.equals(other$plaintextChecksum)) {
            return false;
        }
        String this$keyId = this.getKeyId();
        String other$keyId = other.getKeyId();
        if (this$keyId == null ? other$keyId != null : !this$keyId.equals(other$keyId)) {
            return false;
        }
        String this$keyVersionId = this.getKeyVersionId();
        String other$keyVersionId = other.getKeyVersionId();
        if (this$keyVersionId == null ? other$keyVersionId != null : !this$keyVersionId.equals(other$keyVersionId)) {
            return false;
        }
        EncryptionAlgorithm this$encryptionAlgorithm = this.getEncryptionAlgorithm();
        EncryptionAlgorithm other$encryptionAlgorithm = other.getEncryptionAlgorithm();
        if (this$encryptionAlgorithm == null ? other$encryptionAlgorithm != null : !((Object)((Object)this$encryptionAlgorithm)).equals((Object)other$encryptionAlgorithm)) {
            return false;
        }
        Set<String> this$__explicitlySet__ = this.get__explicitlySet__();
        Set<String> other$__explicitlySet__ = other.get__explicitlySet__();
        return !(this$__explicitlySet__ == null ? other$__explicitlySet__ != null : !((Object)this$__explicitlySet__).equals(other$__explicitlySet__));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $plaintext = this.getPlaintext();
        result = result * 59 + ($plaintext == null ? 43 : $plaintext.hashCode());
        String $plaintextChecksum = this.getPlaintextChecksum();
        result = result * 59 + ($plaintextChecksum == null ? 43 : $plaintextChecksum.hashCode());
        String $keyId = this.getKeyId();
        result = result * 59 + ($keyId == null ? 43 : $keyId.hashCode());
        String $keyVersionId = this.getKeyVersionId();
        result = result * 59 + ($keyVersionId == null ? 43 : $keyVersionId.hashCode());
        EncryptionAlgorithm $encryptionAlgorithm = this.getEncryptionAlgorithm();
        result = result * 59 + ($encryptionAlgorithm == null ? 43 : ((Object)((Object)$encryptionAlgorithm)).hashCode());
        Set<String> $__explicitlySet__ = this.get__explicitlySet__();
        result = result * 59 + ($__explicitlySet__ == null ? 43 : ((Object)$__explicitlySet__).hashCode());
        return result;
    }

    public String toString() {
        return "DecryptedData(plaintext=" + this.getPlaintext() + ", plaintextChecksum=" + this.getPlaintextChecksum() + ", keyId=" + this.getKeyId() + ", keyVersionId=" + this.getKeyVersionId() + ", encryptionAlgorithm=" + (Object)((Object)this.getEncryptionAlgorithm()) + ", __explicitlySet__=" + this.get__explicitlySet__() + ")";
    }

    @ConstructorProperties(value={"plaintext", "plaintextChecksum", "keyId", "keyVersionId", "encryptionAlgorithm"})
    @Deprecated
    public DecryptedData(String plaintext, String plaintextChecksum, String keyId, String keyVersionId, EncryptionAlgorithm encryptionAlgorithm) {
        this.plaintext = plaintext;
        this.plaintextChecksum = plaintextChecksum;
        this.keyId = keyId;
        this.keyVersionId = keyVersionId;
        this.encryptionAlgorithm = encryptionAlgorithm;
    }

    public static enum EncryptionAlgorithm {
        Aes256Gcm("AES_256_GCM"),
        RsaOaepSha1("RSA_OAEP_SHA_1"),
        RsaOaepSha256("RSA_OAEP_SHA_256"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, EncryptionAlgorithm> map;

        private EncryptionAlgorithm(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static EncryptionAlgorithm create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'EncryptionAlgorithm', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(EncryptionAlgorithm.class);
            map = new HashMap<String, EncryptionAlgorithm>();
            for (EncryptionAlgorithm v : EncryptionAlgorithm.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="plaintext")
        private String plaintext;
        @JsonProperty(value="plaintextChecksum")
        private String plaintextChecksum;
        @JsonProperty(value="keyId")
        private String keyId;
        @JsonProperty(value="keyVersionId")
        private String keyVersionId;
        @JsonProperty(value="encryptionAlgorithm")
        private EncryptionAlgorithm encryptionAlgorithm;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder plaintext(String plaintext) {
            this.plaintext = plaintext;
            this.__explicitlySet__.add("plaintext");
            return this;
        }

        public Builder plaintextChecksum(String plaintextChecksum) {
            this.plaintextChecksum = plaintextChecksum;
            this.__explicitlySet__.add("plaintextChecksum");
            return this;
        }

        public Builder keyId(String keyId) {
            this.keyId = keyId;
            this.__explicitlySet__.add("keyId");
            return this;
        }

        public Builder keyVersionId(String keyVersionId) {
            this.keyVersionId = keyVersionId;
            this.__explicitlySet__.add("keyVersionId");
            return this;
        }

        public Builder encryptionAlgorithm(EncryptionAlgorithm encryptionAlgorithm) {
            this.encryptionAlgorithm = encryptionAlgorithm;
            this.__explicitlySet__.add("encryptionAlgorithm");
            return this;
        }

        public DecryptedData build() {
            DecryptedData __instance__ = new DecryptedData(this.plaintext, this.plaintextChecksum, this.keyId, this.keyVersionId, this.encryptionAlgorithm);
            __instance__.__explicitlySet__.addAll(this.__explicitlySet__);
            return __instance__;
        }

        @JsonIgnore
        public Builder copy(DecryptedData o) {
            Builder copiedBuilder = this.plaintext(o.getPlaintext()).plaintextChecksum(o.getPlaintextChecksum()).keyId(o.getKeyId()).keyVersionId(o.getKeyVersionId()).encryptionAlgorithm(o.getEncryptionAlgorithm());
            copiedBuilder.__explicitlySet__.retainAll(o.__explicitlySet__);
            return copiedBuilder;
        }

        Builder() {
        }

        public String toString() {
            return "DecryptedData.Builder(plaintext=" + this.plaintext + ", plaintextChecksum=" + this.plaintextChecksum + ", keyId=" + this.keyId + ", keyVersionId=" + this.keyVersionId + ", encryptionAlgorithm=" + (Object)((Object)this.encryptionAlgorithm) + ")";
        }
    }
}

