/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.keymanagement.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.keymanagement.model.KeyShape;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class Key {
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="currentKeyVersion")
    private final String currentKeyVersion;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="keyShape")
    private final KeyShape keyShape;
    @JsonProperty(value="protectionMode")
    private final ProtectionMode protectionMode;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="timeOfDeletion")
    private final Date timeOfDeletion;
    @JsonProperty(value="vaultId")
    private final String vaultId;
    @JsonProperty(value="restoredFromKeyId")
    private final String restoredFromKeyId;
    @JsonIgnore
    private final Set<String> __explicitlySet__ = new HashSet<String>();

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().compartmentId(this.compartmentId).currentKeyVersion(this.currentKeyVersion).definedTags(this.definedTags).displayName(this.displayName).freeformTags(this.freeformTags).id(this.id).keyShape(this.keyShape).protectionMode(this.protectionMode).lifecycleState(this.lifecycleState).timeCreated(this.timeCreated).timeOfDeletion(this.timeOfDeletion).vaultId(this.vaultId).restoredFromKeyId(this.restoredFromKeyId);
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getCurrentKeyVersion() {
        return this.currentKeyVersion;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public String getId() {
        return this.id;
    }

    public KeyShape getKeyShape() {
        return this.keyShape;
    }

    public ProtectionMode getProtectionMode() {
        return this.protectionMode;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Date getTimeOfDeletion() {
        return this.timeOfDeletion;
    }

    public String getVaultId() {
        return this.vaultId;
    }

    public String getRestoredFromKeyId() {
        return this.restoredFromKeyId;
    }

    public Set<String> get__explicitlySet__() {
        return this.__explicitlySet__;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Key)) {
            return false;
        }
        Key other = (Key)o;
        String this$compartmentId = this.getCompartmentId();
        String other$compartmentId = other.getCompartmentId();
        if (this$compartmentId == null ? other$compartmentId != null : !this$compartmentId.equals(other$compartmentId)) {
            return false;
        }
        String this$currentKeyVersion = this.getCurrentKeyVersion();
        String other$currentKeyVersion = other.getCurrentKeyVersion();
        if (this$currentKeyVersion == null ? other$currentKeyVersion != null : !this$currentKeyVersion.equals(other$currentKeyVersion)) {
            return false;
        }
        Map<String, Map<String, Object>> this$definedTags = this.getDefinedTags();
        Map<String, Map<String, Object>> other$definedTags = other.getDefinedTags();
        if (this$definedTags == null ? other$definedTags != null : !((Object)this$definedTags).equals(other$definedTags)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        Map<String, String> this$freeformTags = this.getFreeformTags();
        Map<String, String> other$freeformTags = other.getFreeformTags();
        if (this$freeformTags == null ? other$freeformTags != null : !((Object)this$freeformTags).equals(other$freeformTags)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        KeyShape this$keyShape = this.getKeyShape();
        KeyShape other$keyShape = other.getKeyShape();
        if (this$keyShape == null ? other$keyShape != null : !((Object)this$keyShape).equals(other$keyShape)) {
            return false;
        }
        ProtectionMode this$protectionMode = this.getProtectionMode();
        ProtectionMode other$protectionMode = other.getProtectionMode();
        if (this$protectionMode == null ? other$protectionMode != null : !((Object)((Object)this$protectionMode)).equals((Object)other$protectionMode)) {
            return false;
        }
        LifecycleState this$lifecycleState = this.getLifecycleState();
        LifecycleState other$lifecycleState = other.getLifecycleState();
        if (this$lifecycleState == null ? other$lifecycleState != null : !((Object)((Object)this$lifecycleState)).equals((Object)other$lifecycleState)) {
            return false;
        }
        Date this$timeCreated = this.getTimeCreated();
        Date other$timeCreated = other.getTimeCreated();
        if (this$timeCreated == null ? other$timeCreated != null : !((Object)this$timeCreated).equals(other$timeCreated)) {
            return false;
        }
        Date this$timeOfDeletion = this.getTimeOfDeletion();
        Date other$timeOfDeletion = other.getTimeOfDeletion();
        if (this$timeOfDeletion == null ? other$timeOfDeletion != null : !((Object)this$timeOfDeletion).equals(other$timeOfDeletion)) {
            return false;
        }
        String this$vaultId = this.getVaultId();
        String other$vaultId = other.getVaultId();
        if (this$vaultId == null ? other$vaultId != null : !this$vaultId.equals(other$vaultId)) {
            return false;
        }
        String this$restoredFromKeyId = this.getRestoredFromKeyId();
        String other$restoredFromKeyId = other.getRestoredFromKeyId();
        if (this$restoredFromKeyId == null ? other$restoredFromKeyId != null : !this$restoredFromKeyId.equals(other$restoredFromKeyId)) {
            return false;
        }
        Set<String> this$__explicitlySet__ = this.get__explicitlySet__();
        Set<String> other$__explicitlySet__ = other.get__explicitlySet__();
        return !(this$__explicitlySet__ == null ? other$__explicitlySet__ != null : !((Object)this$__explicitlySet__).equals(other$__explicitlySet__));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $compartmentId = this.getCompartmentId();
        result = result * 59 + ($compartmentId == null ? 43 : $compartmentId.hashCode());
        String $currentKeyVersion = this.getCurrentKeyVersion();
        result = result * 59 + ($currentKeyVersion == null ? 43 : $currentKeyVersion.hashCode());
        Map<String, Map<String, Object>> $definedTags = this.getDefinedTags();
        result = result * 59 + ($definedTags == null ? 43 : ((Object)$definedTags).hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        Map<String, String> $freeformTags = this.getFreeformTags();
        result = result * 59 + ($freeformTags == null ? 43 : ((Object)$freeformTags).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        KeyShape $keyShape = this.getKeyShape();
        result = result * 59 + ($keyShape == null ? 43 : ((Object)$keyShape).hashCode());
        ProtectionMode $protectionMode = this.getProtectionMode();
        result = result * 59 + ($protectionMode == null ? 43 : ((Object)((Object)$protectionMode)).hashCode());
        LifecycleState $lifecycleState = this.getLifecycleState();
        result = result * 59 + ($lifecycleState == null ? 43 : ((Object)((Object)$lifecycleState)).hashCode());
        Date $timeCreated = this.getTimeCreated();
        result = result * 59 + ($timeCreated == null ? 43 : ((Object)$timeCreated).hashCode());
        Date $timeOfDeletion = this.getTimeOfDeletion();
        result = result * 59 + ($timeOfDeletion == null ? 43 : ((Object)$timeOfDeletion).hashCode());
        String $vaultId = this.getVaultId();
        result = result * 59 + ($vaultId == null ? 43 : $vaultId.hashCode());
        String $restoredFromKeyId = this.getRestoredFromKeyId();
        result = result * 59 + ($restoredFromKeyId == null ? 43 : $restoredFromKeyId.hashCode());
        Set<String> $__explicitlySet__ = this.get__explicitlySet__();
        result = result * 59 + ($__explicitlySet__ == null ? 43 : ((Object)$__explicitlySet__).hashCode());
        return result;
    }

    public String toString() {
        return "Key(compartmentId=" + this.getCompartmentId() + ", currentKeyVersion=" + this.getCurrentKeyVersion() + ", definedTags=" + this.getDefinedTags() + ", displayName=" + this.getDisplayName() + ", freeformTags=" + this.getFreeformTags() + ", id=" + this.getId() + ", keyShape=" + this.getKeyShape() + ", protectionMode=" + (Object)((Object)this.getProtectionMode()) + ", lifecycleState=" + (Object)((Object)this.getLifecycleState()) + ", timeCreated=" + this.getTimeCreated() + ", timeOfDeletion=" + this.getTimeOfDeletion() + ", vaultId=" + this.getVaultId() + ", restoredFromKeyId=" + this.getRestoredFromKeyId() + ", __explicitlySet__=" + this.get__explicitlySet__() + ")";
    }

    @ConstructorProperties(value={"compartmentId", "currentKeyVersion", "definedTags", "displayName", "freeformTags", "id", "keyShape", "protectionMode", "lifecycleState", "timeCreated", "timeOfDeletion", "vaultId", "restoredFromKeyId"})
    @Deprecated
    public Key(String compartmentId, String currentKeyVersion, Map<String, Map<String, Object>> definedTags, String displayName, Map<String, String> freeformTags, String id, KeyShape keyShape, ProtectionMode protectionMode, LifecycleState lifecycleState, Date timeCreated, Date timeOfDeletion, String vaultId, String restoredFromKeyId) {
        this.compartmentId = compartmentId;
        this.currentKeyVersion = currentKeyVersion;
        this.definedTags = definedTags;
        this.displayName = displayName;
        this.freeformTags = freeformTags;
        this.id = id;
        this.keyShape = keyShape;
        this.protectionMode = protectionMode;
        this.lifecycleState = lifecycleState;
        this.timeCreated = timeCreated;
        this.timeOfDeletion = timeOfDeletion;
        this.vaultId = vaultId;
        this.restoredFromKeyId = restoredFromKeyId;
    }

    public static enum LifecycleState {
        Creating("CREATING"),
        Enabling("ENABLING"),
        Enabled("ENABLED"),
        Disabling("DISABLING"),
        Disabled("DISABLED"),
        Deleting("DELETING"),
        Deleted("DELETED"),
        PendingDeletion("PENDING_DELETION"),
        SchedulingDeletion("SCHEDULING_DELETION"),
        CancellingDeletion("CANCELLING_DELETION"),
        Updating("UPDATING"),
        BackupInProgress("BACKUP_IN_PROGRESS"),
        Restoring("RESTORING"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LifecycleState> map;

        private LifecycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LifecycleState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LifecycleState.class);
            map = new HashMap<String, LifecycleState>();
            for (LifecycleState v : LifecycleState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum ProtectionMode {
        Hsm("HSM"),
        Software("SOFTWARE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ProtectionMode> map;

        private ProtectionMode(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ProtectionMode create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ProtectionMode', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ProtectionMode.class);
            map = new HashMap<String, ProtectionMode>();
            for (ProtectionMode v : ProtectionMode.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="currentKeyVersion")
        private String currentKeyVersion;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="keyShape")
        private KeyShape keyShape;
        @JsonProperty(value="protectionMode")
        private ProtectionMode protectionMode;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="timeOfDeletion")
        private Date timeOfDeletion;
        @JsonProperty(value="vaultId")
        private String vaultId;
        @JsonProperty(value="restoredFromKeyId")
        private String restoredFromKeyId;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder currentKeyVersion(String currentKeyVersion) {
            this.currentKeyVersion = currentKeyVersion;
            this.__explicitlySet__.add("currentKeyVersion");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder keyShape(KeyShape keyShape) {
            this.keyShape = keyShape;
            this.__explicitlySet__.add("keyShape");
            return this;
        }

        public Builder protectionMode(ProtectionMode protectionMode) {
            this.protectionMode = protectionMode;
            this.__explicitlySet__.add("protectionMode");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder timeOfDeletion(Date timeOfDeletion) {
            this.timeOfDeletion = timeOfDeletion;
            this.__explicitlySet__.add("timeOfDeletion");
            return this;
        }

        public Builder vaultId(String vaultId) {
            this.vaultId = vaultId;
            this.__explicitlySet__.add("vaultId");
            return this;
        }

        public Builder restoredFromKeyId(String restoredFromKeyId) {
            this.restoredFromKeyId = restoredFromKeyId;
            this.__explicitlySet__.add("restoredFromKeyId");
            return this;
        }

        public Key build() {
            Key __instance__ = new Key(this.compartmentId, this.currentKeyVersion, this.definedTags, this.displayName, this.freeformTags, this.id, this.keyShape, this.protectionMode, this.lifecycleState, this.timeCreated, this.timeOfDeletion, this.vaultId, this.restoredFromKeyId);
            __instance__.__explicitlySet__.addAll(this.__explicitlySet__);
            return __instance__;
        }

        @JsonIgnore
        public Builder copy(Key o) {
            Builder copiedBuilder = this.compartmentId(o.getCompartmentId()).currentKeyVersion(o.getCurrentKeyVersion()).definedTags(o.getDefinedTags()).displayName(o.getDisplayName()).freeformTags(o.getFreeformTags()).id(o.getId()).keyShape(o.getKeyShape()).protectionMode(o.getProtectionMode()).lifecycleState(o.getLifecycleState()).timeCreated(o.getTimeCreated()).timeOfDeletion(o.getTimeOfDeletion()).vaultId(o.getVaultId()).restoredFromKeyId(o.getRestoredFromKeyId());
            copiedBuilder.__explicitlySet__.retainAll(o.__explicitlySet__);
            return copiedBuilder;
        }

        Builder() {
        }

        public String toString() {
            return "Key.Builder(compartmentId=" + this.compartmentId + ", currentKeyVersion=" + this.currentKeyVersion + ", definedTags=" + this.definedTags + ", displayName=" + this.displayName + ", freeformTags=" + this.freeformTags + ", id=" + this.id + ", keyShape=" + this.keyShape + ", protectionMode=" + (Object)((Object)this.protectionMode) + ", lifecycleState=" + (Object)((Object)this.lifecycleState) + ", timeCreated=" + this.timeCreated + ", timeOfDeletion=" + this.timeOfDeletion + ", vaultId=" + this.vaultId + ", restoredFromKeyId=" + this.restoredFromKeyId + ")";
        }
    }
}

