/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.keymanagement.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.keymanagement.model.BackupKeyDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class BackupKeyRequest
extends BmcRequest<BackupKeyDetails> {
    private String keyId;
    private String ifMatch;
    private String opcRequestId;
    private String opcRetryToken;
    private BackupKeyDetails backupKeyDetails;

    @InternalSdk
    public BackupKeyDetails getBody$() {
        return this.backupKeyDetails;
    }

    @ConstructorProperties(value={"keyId", "ifMatch", "opcRequestId", "opcRetryToken", "backupKeyDetails"})
    BackupKeyRequest(String keyId, String ifMatch, String opcRequestId, String opcRetryToken, BackupKeyDetails backupKeyDetails) {
        this.keyId = keyId;
        this.ifMatch = ifMatch;
        this.opcRequestId = opcRequestId;
        this.opcRetryToken = opcRetryToken;
        this.backupKeyDetails = backupKeyDetails;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getKeyId() {
        return this.keyId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public BackupKeyDetails getBackupKeyDetails() {
        return this.backupKeyDetails;
    }

    public static class Builder
    implements BmcRequest.Builder<BackupKeyRequest, BackupKeyDetails> {
        private String keyId;
        private String ifMatch;
        private String opcRequestId;
        private String opcRetryToken;
        private BackupKeyDetails backupKeyDetails;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(BackupKeyRequest o) {
            this.keyId(o.getKeyId());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.backupKeyDetails(o.getBackupKeyDetails());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public BackupKeyRequest build() {
            BackupKeyRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(BackupKeyDetails body) {
            this.backupKeyDetails(body);
            return this;
        }

        Builder() {
        }

        public Builder keyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder backupKeyDetails(BackupKeyDetails backupKeyDetails) {
            this.backupKeyDetails = backupKeyDetails;
            return this;
        }

        public BackupKeyRequest buildWithoutInvocationCallback() {
            return new BackupKeyRequest(this.keyId, this.ifMatch, this.opcRequestId, this.opcRetryToken, this.backupKeyDetails);
        }

        public String toString() {
            return "BackupKeyRequest.Builder(keyId=" + this.keyId + ", ifMatch=" + this.ifMatch + ", opcRequestId=" + this.opcRequestId + ", opcRetryToken=" + this.opcRetryToken + ", backupKeyDetails=" + this.backupKeyDetails + ")";
        }
    }
}

