/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.keymanagement.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetKeyVersionRequest
extends BmcRequest<Void> {
    private String keyId;
    private String keyVersionId;
    private String opcRequestId;

    @ConstructorProperties(value={"keyId", "keyVersionId", "opcRequestId"})
    GetKeyVersionRequest(String keyId, String keyVersionId, String opcRequestId) {
        this.keyId = keyId;
        this.keyVersionId = keyVersionId;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getKeyId() {
        return this.keyId;
    }

    public String getKeyVersionId() {
        return this.keyVersionId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<GetKeyVersionRequest, Void> {
        private String keyId;
        private String keyVersionId;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetKeyVersionRequest o) {
            this.keyId(o.getKeyId());
            this.keyVersionId(o.getKeyVersionId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetKeyVersionRequest build() {
            GetKeyVersionRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder keyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        public Builder keyVersionId(String keyVersionId) {
            this.keyVersionId = keyVersionId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetKeyVersionRequest buildWithoutInvocationCallback() {
            return new GetKeyVersionRequest(this.keyId, this.keyVersionId, this.opcRequestId);
        }

        public String toString() {
            return "GetKeyVersionRequest.Builder(keyId=" + this.keyId + ", keyVersionId=" + this.keyVersionId + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

