/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.keymanagement.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.keymanagement.model.ImportKeyDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class ImportKeyRequest
extends BmcRequest<ImportKeyDetails> {
    private ImportKeyDetails importKeyDetails;
    private String opcRequestId;
    private String opcRetryToken;

    @InternalSdk
    public ImportKeyDetails getBody$() {
        return this.importKeyDetails;
    }

    @ConstructorProperties(value={"importKeyDetails", "opcRequestId", "opcRetryToken"})
    ImportKeyRequest(ImportKeyDetails importKeyDetails, String opcRequestId, String opcRetryToken) {
        this.importKeyDetails = importKeyDetails;
        this.opcRequestId = opcRequestId;
        this.opcRetryToken = opcRetryToken;
    }

    public static Builder builder() {
        return new Builder();
    }

    public ImportKeyDetails getImportKeyDetails() {
        return this.importKeyDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public static class Builder
    implements BmcRequest.Builder<ImportKeyRequest, ImportKeyDetails> {
        private ImportKeyDetails importKeyDetails;
        private String opcRequestId;
        private String opcRetryToken;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ImportKeyRequest o) {
            this.importKeyDetails(o.getImportKeyDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ImportKeyRequest build() {
            ImportKeyRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(ImportKeyDetails body) {
            this.importKeyDetails(body);
            return this;
        }

        Builder() {
        }

        public Builder importKeyDetails(ImportKeyDetails importKeyDetails) {
            this.importKeyDetails = importKeyDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public ImportKeyRequest buildWithoutInvocationCallback() {
            return new ImportKeyRequest(this.importKeyDetails, this.opcRequestId, this.opcRetryToken);
        }

        public String toString() {
            return "ImportKeyRequest.Builder(importKeyDetails=" + this.importKeyDetails + ", opcRequestId=" + this.opcRequestId + ", opcRetryToken=" + this.opcRetryToken + ")";
        }
    }
}

