/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.keymanagement;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.internal.ClientThreadFactory;
import com.oracle.bmc.keymanagement.KmsManagement;
import com.oracle.bmc.keymanagement.KmsManagementClientBuilder;
import com.oracle.bmc.keymanagement.KmsManagementPaginators;
import com.oracle.bmc.keymanagement.KmsManagementWaiters;
import com.oracle.bmc.keymanagement.model.Key;
import com.oracle.bmc.keymanagement.model.KeySummary;
import com.oracle.bmc.keymanagement.model.KeyVersion;
import com.oracle.bmc.keymanagement.model.KeyVersionSummary;
import com.oracle.bmc.keymanagement.model.ReplicationStatusDetails;
import com.oracle.bmc.keymanagement.model.WrappingKey;
import com.oracle.bmc.keymanagement.requests.BackupKeyRequest;
import com.oracle.bmc.keymanagement.requests.CancelKeyDeletionRequest;
import com.oracle.bmc.keymanagement.requests.CancelKeyVersionDeletionRequest;
import com.oracle.bmc.keymanagement.requests.ChangeKeyCompartmentRequest;
import com.oracle.bmc.keymanagement.requests.CreateKeyRequest;
import com.oracle.bmc.keymanagement.requests.CreateKeyVersionRequest;
import com.oracle.bmc.keymanagement.requests.DisableKeyRequest;
import com.oracle.bmc.keymanagement.requests.EnableKeyRequest;
import com.oracle.bmc.keymanagement.requests.GetKeyRequest;
import com.oracle.bmc.keymanagement.requests.GetKeyVersionRequest;
import com.oracle.bmc.keymanagement.requests.GetReplicationStatusRequest;
import com.oracle.bmc.keymanagement.requests.GetWrappingKeyRequest;
import com.oracle.bmc.keymanagement.requests.ImportKeyRequest;
import com.oracle.bmc.keymanagement.requests.ImportKeyVersionRequest;
import com.oracle.bmc.keymanagement.requests.ListKeyVersionsRequest;
import com.oracle.bmc.keymanagement.requests.ListKeysRequest;
import com.oracle.bmc.keymanagement.requests.RestoreKeyFromFileRequest;
import com.oracle.bmc.keymanagement.requests.RestoreKeyFromObjectStoreRequest;
import com.oracle.bmc.keymanagement.requests.ScheduleKeyDeletionRequest;
import com.oracle.bmc.keymanagement.requests.ScheduleKeyVersionDeletionRequest;
import com.oracle.bmc.keymanagement.requests.UpdateKeyRequest;
import com.oracle.bmc.keymanagement.responses.BackupKeyResponse;
import com.oracle.bmc.keymanagement.responses.CancelKeyDeletionResponse;
import com.oracle.bmc.keymanagement.responses.CancelKeyVersionDeletionResponse;
import com.oracle.bmc.keymanagement.responses.ChangeKeyCompartmentResponse;
import com.oracle.bmc.keymanagement.responses.CreateKeyResponse;
import com.oracle.bmc.keymanagement.responses.CreateKeyVersionResponse;
import com.oracle.bmc.keymanagement.responses.DisableKeyResponse;
import com.oracle.bmc.keymanagement.responses.EnableKeyResponse;
import com.oracle.bmc.keymanagement.responses.GetKeyResponse;
import com.oracle.bmc.keymanagement.responses.GetKeyVersionResponse;
import com.oracle.bmc.keymanagement.responses.GetReplicationStatusResponse;
import com.oracle.bmc.keymanagement.responses.GetWrappingKeyResponse;
import com.oracle.bmc.keymanagement.responses.ImportKeyResponse;
import com.oracle.bmc.keymanagement.responses.ImportKeyVersionResponse;
import com.oracle.bmc.keymanagement.responses.ListKeyVersionsResponse;
import com.oracle.bmc.keymanagement.responses.ListKeysResponse;
import com.oracle.bmc.keymanagement.responses.RestoreKeyFromFileResponse;
import com.oracle.bmc.keymanagement.responses.RestoreKeyFromObjectStoreResponse;
import com.oracle.bmc.keymanagement.responses.ScheduleKeyDeletionResponse;
import com.oracle.bmc.keymanagement.responses.ScheduleKeyVersionDeletionResponse;
import com.oracle.bmc.keymanagement.responses.UpdateKeyResponse;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.internal.Validate;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KmsManagementClient
extends BaseSyncClient
implements KmsManagement {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("KMSMANAGEMENT").serviceEndpointPrefix("kms").serviceEndpointTemplate("https://kms.{region}.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(KmsManagementClient.class);
    private final KmsManagementWaiters waiters;
    private final KmsManagementPaginators paginators;

    KmsManagementClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)ClientThreadFactory.builder().isDaemon(true).nameFormat("KmsManagement-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new KmsManagementWaiters(executorService, this);
        this.paginators = new KmsManagementPaginators(this);
    }

    public static KmsManagementClientBuilder builder() {
        return new KmsManagementClientBuilder(SERVICE);
    }

    @Override
    public BackupKeyResponse backupKey(BackupKeyRequest request) {
        Validate.notBlank((String)request.getKeyId(), (String)"keyId must not be blank", (Object[])new Object[0]);
        return (BackupKeyResponse)this.clientCall(request, BackupKeyResponse::builder).logger(LOG, "backupKey").serviceDetails("KmsManagement", "BackupKey", "").method(Method.POST).requestBuilder(BackupKeyRequest::builder).basePath("/").appendPathParam("20180608").appendPathParam("keys").appendPathParam(request.getKeyId()).appendPathParam("actions").appendPathParam("backup").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(Key.class, BackupKeyResponse.Builder::key).handleResponseHeaderString("etag", BackupKeyResponse.Builder::etag).handleResponseHeaderString("opc-request-id", BackupKeyResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", BackupKeyResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public CancelKeyDeletionResponse cancelKeyDeletion(CancelKeyDeletionRequest request) {
        Validate.notBlank((String)request.getKeyId(), (String)"keyId must not be blank", (Object[])new Object[0]);
        return (CancelKeyDeletionResponse)this.clientCall(request, CancelKeyDeletionResponse::builder).logger(LOG, "cancelKeyDeletion").serviceDetails("KmsManagement", "CancelKeyDeletion", "").method(Method.POST).requestBuilder(CancelKeyDeletionRequest::builder).basePath("/").appendPathParam("20180608").appendPathParam("keys").appendPathParam(request.getKeyId()).appendPathParam("actions").appendPathParam("cancelDeletion").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleBody(Key.class, CancelKeyDeletionResponse.Builder::key).handleResponseHeaderString("etag", CancelKeyDeletionResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CancelKeyDeletionResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CancelKeyVersionDeletionResponse cancelKeyVersionDeletion(CancelKeyVersionDeletionRequest request) {
        Validate.notBlank((String)request.getKeyId(), (String)"keyId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getKeyVersionId(), (String)"keyVersionId must not be blank", (Object[])new Object[0]);
        return (CancelKeyVersionDeletionResponse)this.clientCall(request, CancelKeyVersionDeletionResponse::builder).logger(LOG, "cancelKeyVersionDeletion").serviceDetails("KmsManagement", "CancelKeyVersionDeletion", "").method(Method.POST).requestBuilder(CancelKeyVersionDeletionRequest::builder).basePath("/").appendPathParam("20180608").appendPathParam("keys").appendPathParam(request.getKeyId()).appendPathParam("keyVersions").appendPathParam(request.getKeyVersionId()).appendPathParam("actions").appendPathParam("cancelDeletion").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleBody(KeyVersion.class, CancelKeyVersionDeletionResponse.Builder::keyVersion).handleResponseHeaderString("etag", CancelKeyVersionDeletionResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CancelKeyVersionDeletionResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ChangeKeyCompartmentResponse changeKeyCompartment(ChangeKeyCompartmentRequest request) {
        Validate.notBlank((String)request.getKeyId(), (String)"keyId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeKeyCompartmentDetails(), "changeKeyCompartmentDetails is required");
        return (ChangeKeyCompartmentResponse)this.clientCall(request, ChangeKeyCompartmentResponse::builder).logger(LOG, "changeKeyCompartment").serviceDetails("KmsManagement", "ChangeKeyCompartment", "").method(Method.POST).requestBuilder(ChangeKeyCompartmentRequest::builder).basePath("/").appendPathParam("20180608").appendPathParam("keys").appendPathParam(request.getKeyId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("etag", ChangeKeyCompartmentResponse.Builder::etag).handleResponseHeaderString("opc-request-id", ChangeKeyCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateKeyResponse createKey(CreateKeyRequest request) {
        Objects.requireNonNull(request.getCreateKeyDetails(), "createKeyDetails is required");
        return (CreateKeyResponse)this.clientCall(request, CreateKeyResponse::builder).logger(LOG, "createKey").serviceDetails("KmsManagement", "CreateKey", "").method(Method.POST).requestBuilder(CreateKeyRequest::builder).basePath("/").appendPathParam("20180608").appendPathParam("keys").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(Key.class, CreateKeyResponse.Builder::key).handleResponseHeaderString("etag", CreateKeyResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateKeyResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateKeyVersionResponse createKeyVersion(CreateKeyVersionRequest request) {
        Validate.notBlank((String)request.getKeyId(), (String)"keyId must not be blank", (Object[])new Object[0]);
        return (CreateKeyVersionResponse)this.clientCall(request, CreateKeyVersionResponse::builder).logger(LOG, "createKeyVersion").serviceDetails("KmsManagement", "CreateKeyVersion", "").method(Method.POST).requestBuilder(CreateKeyVersionRequest::builder).basePath("/").appendPathParam("20180608").appendPathParam("keys").appendPathParam(request.getKeyId()).appendPathParam("keyVersions").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleBody(KeyVersion.class, CreateKeyVersionResponse.Builder::keyVersion).handleResponseHeaderString("etag", CreateKeyVersionResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateKeyVersionResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DisableKeyResponse disableKey(DisableKeyRequest request) {
        Validate.notBlank((String)request.getKeyId(), (String)"keyId must not be blank", (Object[])new Object[0]);
        return (DisableKeyResponse)this.clientCall(request, DisableKeyResponse::builder).logger(LOG, "disableKey").serviceDetails("KmsManagement", "DisableKey", "").method(Method.POST).requestBuilder(DisableKeyRequest::builder).basePath("/").appendPathParam("20180608").appendPathParam("keys").appendPathParam(request.getKeyId()).appendPathParam("actions").appendPathParam("disable").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleBody(Key.class, DisableKeyResponse.Builder::key).handleResponseHeaderString("etag", DisableKeyResponse.Builder::etag).handleResponseHeaderString("opc-request-id", DisableKeyResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public EnableKeyResponse enableKey(EnableKeyRequest request) {
        Validate.notBlank((String)request.getKeyId(), (String)"keyId must not be blank", (Object[])new Object[0]);
        return (EnableKeyResponse)this.clientCall(request, EnableKeyResponse::builder).logger(LOG, "enableKey").serviceDetails("KmsManagement", "EnableKey", "").method(Method.POST).requestBuilder(EnableKeyRequest::builder).basePath("/").appendPathParam("20180608").appendPathParam("keys").appendPathParam(request.getKeyId()).appendPathParam("actions").appendPathParam("enable").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleBody(Key.class, EnableKeyResponse.Builder::key).handleResponseHeaderString("etag", EnableKeyResponse.Builder::etag).handleResponseHeaderString("opc-request-id", EnableKeyResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetKeyResponse getKey(GetKeyRequest request) {
        Validate.notBlank((String)request.getKeyId(), (String)"keyId must not be blank", (Object[])new Object[0]);
        return (GetKeyResponse)this.clientCall(request, GetKeyResponse::builder).logger(LOG, "getKey").serviceDetails("KmsManagement", "GetKey", "").method(Method.GET).requestBuilder(GetKeyRequest::builder).basePath("/").appendPathParam("20180608").appendPathParam("keys").appendPathParam(request.getKeyId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Key.class, GetKeyResponse.Builder::key).handleResponseHeaderString("etag", GetKeyResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetKeyResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetKeyVersionResponse getKeyVersion(GetKeyVersionRequest request) {
        Validate.notBlank((String)request.getKeyId(), (String)"keyId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getKeyVersionId(), (String)"keyVersionId must not be blank", (Object[])new Object[0]);
        return (GetKeyVersionResponse)this.clientCall(request, GetKeyVersionResponse::builder).logger(LOG, "getKeyVersion").serviceDetails("KmsManagement", "GetKeyVersion", "").method(Method.GET).requestBuilder(GetKeyVersionRequest::builder).basePath("/").appendPathParam("20180608").appendPathParam("keys").appendPathParam(request.getKeyId()).appendPathParam("keyVersions").appendPathParam(request.getKeyVersionId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(KeyVersion.class, GetKeyVersionResponse.Builder::keyVersion).handleResponseHeaderString("etag", GetKeyVersionResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetKeyVersionResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetReplicationStatusResponse getReplicationStatus(GetReplicationStatusRequest request) {
        Validate.notBlank((String)request.getReplicationId(), (String)"replicationId must not be blank", (Object[])new Object[0]);
        return (GetReplicationStatusResponse)this.clientCall(request, GetReplicationStatusResponse::builder).logger(LOG, "getReplicationStatus").serviceDetails("KmsManagement", "GetReplicationStatus", "").method(Method.GET).requestBuilder(GetReplicationStatusRequest::builder).basePath("/").appendPathParam("20180608").appendPathParam("replicaOperations").appendPathParam(request.getReplicationId()).appendPathParam("status").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ReplicationStatusDetails.class, GetReplicationStatusResponse.Builder::replicationStatusDetails).handleResponseHeaderString("etag", GetReplicationStatusResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetReplicationStatusResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetWrappingKeyResponse getWrappingKey(GetWrappingKeyRequest request) {
        return (GetWrappingKeyResponse)this.clientCall(request, GetWrappingKeyResponse::builder).logger(LOG, "getWrappingKey").serviceDetails("KmsManagement", "GetWrappingKey", "").method(Method.GET).requestBuilder(GetWrappingKeyRequest::builder).basePath("/").appendPathParam("20180608").appendPathParam("wrappingKeys").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WrappingKey.class, GetWrappingKeyResponse.Builder::wrappingKey).handleResponseHeaderString("etag", GetWrappingKeyResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetWrappingKeyResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ImportKeyResponse importKey(ImportKeyRequest request) {
        Objects.requireNonNull(request.getImportKeyDetails(), "importKeyDetails is required");
        return (ImportKeyResponse)this.clientCall(request, ImportKeyResponse::builder).logger(LOG, "importKey").serviceDetails("KmsManagement", "ImportKey", "").method(Method.POST).requestBuilder(ImportKeyRequest::builder).basePath("/").appendPathParam("20180608").appendPathParam("keys").appendPathParam("import").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(Key.class, ImportKeyResponse.Builder::key).handleResponseHeaderString("etag", ImportKeyResponse.Builder::etag).handleResponseHeaderString("opc-request-id", ImportKeyResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ImportKeyVersionResponse importKeyVersion(ImportKeyVersionRequest request) {
        Validate.notBlank((String)request.getKeyId(), (String)"keyId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getImportKeyVersionDetails(), "importKeyVersionDetails is required");
        return (ImportKeyVersionResponse)this.clientCall(request, ImportKeyVersionResponse::builder).logger(LOG, "importKeyVersion").serviceDetails("KmsManagement", "ImportKeyVersion", "").method(Method.POST).requestBuilder(ImportKeyVersionRequest::builder).basePath("/").appendPathParam("20180608").appendPathParam("keys").appendPathParam(request.getKeyId()).appendPathParam("keyVersions").appendPathParam("import").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(KeyVersion.class, ImportKeyVersionResponse.Builder::keyVersion).handleResponseHeaderString("etag", ImportKeyVersionResponse.Builder::etag).handleResponseHeaderString("opc-request-id", ImportKeyVersionResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListKeyVersionsResponse listKeyVersions(ListKeyVersionsRequest request) {
        Validate.notBlank((String)request.getKeyId(), (String)"keyId must not be blank", (Object[])new Object[0]);
        return (ListKeyVersionsResponse)this.clientCall(request, ListKeyVersionsResponse::builder).logger(LOG, "listKeyVersions").serviceDetails("KmsManagement", "ListKeyVersions", "").method(Method.GET).requestBuilder(ListKeyVersionsRequest::builder).basePath("/").appendPathParam("20180608").appendPathParam("keys").appendPathParam(request.getKeyId()).appendPathParam("keyVersions").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(KeyVersionSummary.class, ListKeyVersionsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListKeyVersionsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListKeyVersionsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListKeysResponse listKeys(ListKeysRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListKeysResponse)this.clientCall(request, ListKeysResponse::builder).logger(LOG, "listKeys").serviceDetails("KmsManagement", "ListKeys", "").method(Method.GET).requestBuilder(ListKeysRequest::builder).basePath("/").appendPathParam("20180608").appendPathParam("keys").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("protectionMode", (BmcEnum)request.getProtectionMode()).appendEnumQueryParam("algorithm", (BmcEnum)request.getAlgorithm()).appendQueryParam("length", (Object)request.getLength()).appendEnumQueryParam("curveId", (BmcEnum)request.getCurveId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(KeySummary.class, ListKeysResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListKeysResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListKeysResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public RestoreKeyFromFileResponse restoreKeyFromFile(RestoreKeyFromFileRequest request) {
        Objects.requireNonNull(request.getRestoreKeyFromFileDetails(), "restoreKeyFromFileDetails is required");
        return (RestoreKeyFromFileResponse)this.clientCall(request, RestoreKeyFromFileResponse::builder).logger(LOG, "restoreKeyFromFile").serviceDetails("KmsManagement", "RestoreKeyFromFile", "").method(Method.POST).requestBuilder(RestoreKeyFromFileRequest::builder).basePath("/").appendPathParam("20180608").appendPathParam("keys").appendPathParam("actions").appendPathParam("restoreFromFile").accept(new String[]{"application/json"}).appendHeader("content-length", (Number)request.getContentLength()).appendHeader("if-match", request.getIfMatch()).appendHeader("content-md5", request.getContentMd5()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBinaryRequestBody().hasBody().handleBody(Key.class, RestoreKeyFromFileResponse.Builder::key).handleResponseHeaderString("etag", RestoreKeyFromFileResponse.Builder::etag).handleResponseHeaderString("opc-content-md5", RestoreKeyFromFileResponse.Builder::opcContentMd5).handleResponseHeaderString("opc-request-id", RestoreKeyFromFileResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", RestoreKeyFromFileResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public RestoreKeyFromObjectStoreResponse restoreKeyFromObjectStore(RestoreKeyFromObjectStoreRequest request) {
        return (RestoreKeyFromObjectStoreResponse)this.clientCall(request, RestoreKeyFromObjectStoreResponse::builder).logger(LOG, "restoreKeyFromObjectStore").serviceDetails("KmsManagement", "RestoreKeyFromObjectStore", "").method(Method.POST).requestBuilder(RestoreKeyFromObjectStoreRequest::builder).basePath("/").appendPathParam("20180608").appendPathParam("keys").appendPathParam("actions").appendPathParam("restoreFromObjectStore").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(Key.class, RestoreKeyFromObjectStoreResponse.Builder::key).handleResponseHeaderString("etag", RestoreKeyFromObjectStoreResponse.Builder::etag).handleResponseHeaderString("opc-request-id", RestoreKeyFromObjectStoreResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", RestoreKeyFromObjectStoreResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public ScheduleKeyDeletionResponse scheduleKeyDeletion(ScheduleKeyDeletionRequest request) {
        Validate.notBlank((String)request.getKeyId(), (String)"keyId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getScheduleKeyDeletionDetails(), "scheduleKeyDeletionDetails is required");
        return (ScheduleKeyDeletionResponse)this.clientCall(request, ScheduleKeyDeletionResponse::builder).logger(LOG, "scheduleKeyDeletion").serviceDetails("KmsManagement", "ScheduleKeyDeletion", "").method(Method.POST).requestBuilder(ScheduleKeyDeletionRequest::builder).basePath("/").appendPathParam("20180608").appendPathParam("keys").appendPathParam(request.getKeyId()).appendPathParam("actions").appendPathParam("scheduleDeletion").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(Key.class, ScheduleKeyDeletionResponse.Builder::key).handleResponseHeaderString("etag", ScheduleKeyDeletionResponse.Builder::etag).handleResponseHeaderString("opc-request-id", ScheduleKeyDeletionResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ScheduleKeyVersionDeletionResponse scheduleKeyVersionDeletion(ScheduleKeyVersionDeletionRequest request) {
        Validate.notBlank((String)request.getKeyId(), (String)"keyId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getKeyVersionId(), (String)"keyVersionId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getScheduleKeyVersionDeletionDetails(), "scheduleKeyVersionDeletionDetails is required");
        return (ScheduleKeyVersionDeletionResponse)this.clientCall(request, ScheduleKeyVersionDeletionResponse::builder).logger(LOG, "scheduleKeyVersionDeletion").serviceDetails("KmsManagement", "ScheduleKeyVersionDeletion", "").method(Method.POST).requestBuilder(ScheduleKeyVersionDeletionRequest::builder).basePath("/").appendPathParam("20180608").appendPathParam("keys").appendPathParam(request.getKeyId()).appendPathParam("keyVersions").appendPathParam(request.getKeyVersionId()).appendPathParam("actions").appendPathParam("scheduleDeletion").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(KeyVersion.class, ScheduleKeyVersionDeletionResponse.Builder::keyVersion).handleResponseHeaderString("etag", ScheduleKeyVersionDeletionResponse.Builder::etag).handleResponseHeaderString("opc-request-id", ScheduleKeyVersionDeletionResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateKeyResponse updateKey(UpdateKeyRequest request) {
        Validate.notBlank((String)request.getKeyId(), (String)"keyId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateKeyDetails(), "updateKeyDetails is required");
        return (UpdateKeyResponse)this.clientCall(request, UpdateKeyResponse::builder).logger(LOG, "updateKey").serviceDetails("KmsManagement", "UpdateKey", "").method(Method.PUT).requestBuilder(UpdateKeyRequest::builder).basePath("/").appendPathParam("20180608").appendPathParam("keys").appendPathParam(request.getKeyId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Key.class, UpdateKeyResponse.Builder::key).handleResponseHeaderString("etag", UpdateKeyResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateKeyResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public KmsManagementWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public KmsManagementPaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public KmsManagementClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(KmsManagementClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public KmsManagementClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(KmsManagementClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public KmsManagementClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((KmsManagementClientBuilder)KmsManagementClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public KmsManagementClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((KmsManagementClientBuilder)((KmsManagementClientBuilder)KmsManagementClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider, null);
    }

    @Deprecated
    public KmsManagementClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((KmsManagementClientBuilder)((KmsManagementClientBuilder)((KmsManagementClientBuilder)KmsManagementClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider, null);
    }

    @Deprecated
    public KmsManagementClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((KmsManagementClientBuilder)((KmsManagementClientBuilder)((KmsManagementClientBuilder)((KmsManagementClientBuilder)KmsManagementClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider, null);
    }

    @Deprecated
    public KmsManagementClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((KmsManagementClientBuilder)((KmsManagementClientBuilder)((KmsManagementClientBuilder)((KmsManagementClientBuilder)((KmsManagementClientBuilder)KmsManagementClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, null);
    }

    @Deprecated
    public KmsManagementClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(((KmsManagementClientBuilder)((KmsManagementClientBuilder)((KmsManagementClientBuilder)((KmsManagementClientBuilder)((KmsManagementClientBuilder)KmsManagementClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, executorService);
    }
}

