/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.keymanagement;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.keymanagement.EkmAsync;
import com.oracle.bmc.keymanagement.model.EkmsPrivateEndpoint;
import com.oracle.bmc.keymanagement.model.EkmsPrivateEndpointSummary;
import com.oracle.bmc.keymanagement.requests.CreateEkmsPrivateEndpointRequest;
import com.oracle.bmc.keymanagement.requests.DeleteEkmsPrivateEndpointRequest;
import com.oracle.bmc.keymanagement.requests.GetEkmsPrivateEndpointRequest;
import com.oracle.bmc.keymanagement.requests.ListEkmsPrivateEndpointsRequest;
import com.oracle.bmc.keymanagement.requests.UpdateEkmsPrivateEndpointRequest;
import com.oracle.bmc.keymanagement.responses.CreateEkmsPrivateEndpointResponse;
import com.oracle.bmc.keymanagement.responses.DeleteEkmsPrivateEndpointResponse;
import com.oracle.bmc.keymanagement.responses.GetEkmsPrivateEndpointResponse;
import com.oracle.bmc.keymanagement.responses.ListEkmsPrivateEndpointsResponse;
import com.oracle.bmc.keymanagement.responses.UpdateEkmsPrivateEndpointResponse;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EkmAsyncClient
extends BaseAsyncClient
implements EkmAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("EKM").serviceEndpointPrefix("kms").serviceEndpointTemplate("https://kms.{region}.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(EkmAsyncClient.class);

    EkmAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<CreateEkmsPrivateEndpointResponse> createEkmsPrivateEndpoint(CreateEkmsPrivateEndpointRequest request, AsyncHandler<CreateEkmsPrivateEndpointRequest, CreateEkmsPrivateEndpointResponse> handler) {
        Objects.requireNonNull(request.getCreateEkmsPrivateEndpointDetails(), "createEkmsPrivateEndpointDetails is required");
        return this.clientCall(request, CreateEkmsPrivateEndpointResponse::builder).logger(LOG, "createEkmsPrivateEndpoint").serviceDetails("Ekm", "CreateEkmsPrivateEndpoint", "https://docs.oracle.com/iaas/api/#/en/key/release/EkmsPrivateEndpoint/CreateEkmsPrivateEndpoint").method(Method.POST).requestBuilder(CreateEkmsPrivateEndpointRequest::builder).basePath("/").appendPathParam("20180608").appendPathParam("ekmsPrivateEndpoints").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(EkmsPrivateEndpoint.class, CreateEkmsPrivateEndpointResponse.Builder::ekmsPrivateEndpoint).handleResponseHeaderString("etag", CreateEkmsPrivateEndpointResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateEkmsPrivateEndpointResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", CreateEkmsPrivateEndpointResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteEkmsPrivateEndpointResponse> deleteEkmsPrivateEndpoint(DeleteEkmsPrivateEndpointRequest request, AsyncHandler<DeleteEkmsPrivateEndpointRequest, DeleteEkmsPrivateEndpointResponse> handler) {
        Validate.notBlank((String)request.getEkmsPrivateEndpointId(), (String)"ekmsPrivateEndpointId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteEkmsPrivateEndpointResponse::builder).logger(LOG, "deleteEkmsPrivateEndpoint").serviceDetails("Ekm", "DeleteEkmsPrivateEndpoint", "https://docs.oracle.com/iaas/api/#/en/key/release/EkmsPrivateEndpoint/DeleteEkmsPrivateEndpoint").method(Method.DELETE).requestBuilder(DeleteEkmsPrivateEndpointRequest::builder).basePath("/").appendPathParam("20180608").appendPathParam("ekmsPrivateEndpoints").appendPathParam(request.getEkmsPrivateEndpointId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteEkmsPrivateEndpointResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteEkmsPrivateEndpointResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetEkmsPrivateEndpointResponse> getEkmsPrivateEndpoint(GetEkmsPrivateEndpointRequest request, AsyncHandler<GetEkmsPrivateEndpointRequest, GetEkmsPrivateEndpointResponse> handler) {
        Validate.notBlank((String)request.getEkmsPrivateEndpointId(), (String)"ekmsPrivateEndpointId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetEkmsPrivateEndpointResponse::builder).logger(LOG, "getEkmsPrivateEndpoint").serviceDetails("Ekm", "GetEkmsPrivateEndpoint", "https://docs.oracle.com/iaas/api/#/en/key/release/EkmsPrivateEndpoint/GetEkmsPrivateEndpoint").method(Method.GET).requestBuilder(GetEkmsPrivateEndpointRequest::builder).basePath("/").appendPathParam("20180608").appendPathParam("ekmsPrivateEndpoints").appendPathParam(request.getEkmsPrivateEndpointId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(EkmsPrivateEndpoint.class, GetEkmsPrivateEndpointResponse.Builder::ekmsPrivateEndpoint).handleResponseHeaderString("opc-request-id", GetEkmsPrivateEndpointResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetEkmsPrivateEndpointResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<ListEkmsPrivateEndpointsResponse> listEkmsPrivateEndpoints(ListEkmsPrivateEndpointsRequest request, AsyncHandler<ListEkmsPrivateEndpointsRequest, ListEkmsPrivateEndpointsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListEkmsPrivateEndpointsResponse::builder).logger(LOG, "listEkmsPrivateEndpoints").serviceDetails("Ekm", "ListEkmsPrivateEndpoints", "https://docs.oracle.com/iaas/api/#/en/key/release/EkmsPrivateEndpointSummary/ListEkmsPrivateEndpoints").method(Method.GET).requestBuilder(ListEkmsPrivateEndpointsRequest::builder).basePath("/").appendPathParam("20180608").appendPathParam("ekmsPrivateEndpoints").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(EkmsPrivateEndpointSummary.class, ListEkmsPrivateEndpointsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListEkmsPrivateEndpointsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListEkmsPrivateEndpointsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateEkmsPrivateEndpointResponse> updateEkmsPrivateEndpoint(UpdateEkmsPrivateEndpointRequest request, AsyncHandler<UpdateEkmsPrivateEndpointRequest, UpdateEkmsPrivateEndpointResponse> handler) {
        Validate.notBlank((String)request.getEkmsPrivateEndpointId(), (String)"ekmsPrivateEndpointId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateEkmsPrivateEndpointDetails(), "updateEkmsPrivateEndpointDetails is required");
        return this.clientCall(request, UpdateEkmsPrivateEndpointResponse::builder).logger(LOG, "updateEkmsPrivateEndpoint").serviceDetails("Ekm", "UpdateEkmsPrivateEndpoint", "https://docs.oracle.com/iaas/api/#/en/key/release/EkmsPrivateEndpoint/UpdateEkmsPrivateEndpoint").method(Method.PUT).requestBuilder(UpdateEkmsPrivateEndpointRequest::builder).basePath("/").appendPathParam("20180608").appendPathParam("ekmsPrivateEndpoints").appendPathParam(request.getEkmsPrivateEndpointId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(EkmsPrivateEndpoint.class, UpdateEkmsPrivateEndpointResponse.Builder::ekmsPrivateEndpoint).handleResponseHeaderString("etag", UpdateEkmsPrivateEndpointResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateEkmsPrivateEndpointResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Deprecated
    public EkmAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)EkmAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public EkmAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(EkmAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public EkmAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)EkmAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public EkmAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)EkmAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public EkmAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)EkmAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public EkmAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)EkmAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public EkmAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)EkmAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, EkmAsyncClient> {
        private Builder(Service service) {
            super(service);
            String packageName = "keymanagement";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"keymanagement");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public EkmAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new EkmAsyncClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider);
        }
    }
}

