/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.keymanagement;

import com.oracle.bmc.keymanagement.KmsHsmCluster;
import com.oracle.bmc.keymanagement.model.HsmClusterSummary;
import com.oracle.bmc.keymanagement.model.HsmPartitionSummary;
import com.oracle.bmc.keymanagement.requests.ListHsmClustersRequest;
import com.oracle.bmc.keymanagement.requests.ListHsmPartitionsRequest;
import com.oracle.bmc.keymanagement.responses.ListHsmClustersResponse;
import com.oracle.bmc.keymanagement.responses.ListHsmPartitionsResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class KmsHsmClusterPaginators {
    private final KmsHsmCluster client;

    public KmsHsmClusterPaginators(KmsHsmCluster client) {
        this.client = client;
    }

    public Iterable<ListHsmClustersResponse> listHsmClustersResponseIterator(final ListHsmClustersRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListHsmClustersRequest.Builder>(){

            @Override
            public ListHsmClustersRequest.Builder get() {
                return ListHsmClustersRequest.builder().copy(request);
            }
        }, (Function)new Function<ListHsmClustersResponse, String>(){

            @Override
            public String apply(ListHsmClustersResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListHsmClustersRequest.Builder>, ListHsmClustersRequest>(){

            @Override
            public ListHsmClustersRequest apply(RequestBuilderAndToken<ListHsmClustersRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListHsmClustersRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListHsmClustersRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListHsmClustersRequest, ListHsmClustersResponse>(){

            @Override
            public ListHsmClustersResponse apply(ListHsmClustersRequest request) {
                return KmsHsmClusterPaginators.this.client.listHsmClusters(request);
            }
        });
    }

    public Iterable<HsmClusterSummary> listHsmClustersRecordIterator(final ListHsmClustersRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListHsmClustersRequest.Builder>(){

            @Override
            public ListHsmClustersRequest.Builder get() {
                return ListHsmClustersRequest.builder().copy(request);
            }
        }, (Function)new Function<ListHsmClustersResponse, String>(){

            @Override
            public String apply(ListHsmClustersResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListHsmClustersRequest.Builder>, ListHsmClustersRequest>(){

            @Override
            public ListHsmClustersRequest apply(RequestBuilderAndToken<ListHsmClustersRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListHsmClustersRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListHsmClustersRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListHsmClustersRequest, ListHsmClustersResponse>(){

            @Override
            public ListHsmClustersResponse apply(ListHsmClustersRequest request) {
                return KmsHsmClusterPaginators.this.client.listHsmClusters(request);
            }
        }, (Function)new Function<ListHsmClustersResponse, List<HsmClusterSummary>>(){

            @Override
            public List<HsmClusterSummary> apply(ListHsmClustersResponse response) {
                return response.getHsmClusterCollection().getItems();
            }
        });
    }

    public Iterable<ListHsmPartitionsResponse> listHsmPartitionsResponseIterator(final ListHsmPartitionsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListHsmPartitionsRequest.Builder>(){

            @Override
            public ListHsmPartitionsRequest.Builder get() {
                return ListHsmPartitionsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListHsmPartitionsResponse, String>(){

            @Override
            public String apply(ListHsmPartitionsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListHsmPartitionsRequest.Builder>, ListHsmPartitionsRequest>(){

            @Override
            public ListHsmPartitionsRequest apply(RequestBuilderAndToken<ListHsmPartitionsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListHsmPartitionsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListHsmPartitionsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListHsmPartitionsRequest, ListHsmPartitionsResponse>(){

            @Override
            public ListHsmPartitionsResponse apply(ListHsmPartitionsRequest request) {
                return KmsHsmClusterPaginators.this.client.listHsmPartitions(request);
            }
        });
    }

    public Iterable<HsmPartitionSummary> listHsmPartitionsRecordIterator(final ListHsmPartitionsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListHsmPartitionsRequest.Builder>(){

            @Override
            public ListHsmPartitionsRequest.Builder get() {
                return ListHsmPartitionsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListHsmPartitionsResponse, String>(){

            @Override
            public String apply(ListHsmPartitionsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListHsmPartitionsRequest.Builder>, ListHsmPartitionsRequest>(){

            @Override
            public ListHsmPartitionsRequest apply(RequestBuilderAndToken<ListHsmPartitionsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListHsmPartitionsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListHsmPartitionsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListHsmPartitionsRequest, ListHsmPartitionsResponse>(){

            @Override
            public ListHsmPartitionsResponse apply(ListHsmPartitionsRequest request) {
                return KmsHsmClusterPaginators.this.client.listHsmPartitions(request);
            }
        }, (Function)new Function<ListHsmPartitionsResponse, List<HsmPartitionSummary>>(){

            @Override
            public List<HsmPartitionSummary> apply(ListHsmPartitionsResponse response) {
                return response.getHsmPartitionCollection().getItems();
            }
        });
    }
}

