/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.keymanagement.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class SignDataDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="message")
    private final String message;
    @JsonProperty(value="keyId")
    private final String keyId;
    @JsonProperty(value="keyVersionId")
    private final String keyVersionId;
    @JsonProperty(value="messageType")
    private final MessageType messageType;
    @JsonProperty(value="signingAlgorithm")
    private final SigningAlgorithm signingAlgorithm;
    @JsonProperty(value="loggingContext")
    private final Map<String, String> loggingContext;

    @Deprecated
    @ConstructorProperties(value={"message", "keyId", "keyVersionId", "messageType", "signingAlgorithm", "loggingContext"})
    public SignDataDetails(String message, String keyId, String keyVersionId, MessageType messageType, SigningAlgorithm signingAlgorithm, Map<String, String> loggingContext) {
        this.message = message;
        this.keyId = keyId;
        this.keyVersionId = keyVersionId;
        this.messageType = messageType;
        this.signingAlgorithm = signingAlgorithm;
        this.loggingContext = loggingContext;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getMessage() {
        return this.message;
    }

    public String getKeyId() {
        return this.keyId;
    }

    public String getKeyVersionId() {
        return this.keyVersionId;
    }

    public MessageType getMessageType() {
        return this.messageType;
    }

    public SigningAlgorithm getSigningAlgorithm() {
        return this.signingAlgorithm;
    }

    public Map<String, String> getLoggingContext() {
        return this.loggingContext;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("SignDataDetails(");
        sb.append("super=").append(super.toString());
        sb.append("message=").append(String.valueOf(this.message));
        sb.append(", keyId=").append(String.valueOf(this.keyId));
        sb.append(", keyVersionId=").append(String.valueOf(this.keyVersionId));
        sb.append(", messageType=").append(String.valueOf((Object)this.messageType));
        sb.append(", signingAlgorithm=").append(String.valueOf((Object)this.signingAlgorithm));
        sb.append(", loggingContext=").append(String.valueOf(this.loggingContext));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SignDataDetails)) {
            return false;
        }
        SignDataDetails other = (SignDataDetails)((Object)o);
        return Objects.equals(this.message, other.message) && Objects.equals(this.keyId, other.keyId) && Objects.equals(this.keyVersionId, other.keyVersionId) && Objects.equals((Object)this.messageType, (Object)other.messageType) && Objects.equals((Object)this.signingAlgorithm, (Object)other.signingAlgorithm) && Objects.equals(this.loggingContext, other.loggingContext) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.message == null ? 43 : this.message.hashCode());
        result = result * 59 + (this.keyId == null ? 43 : this.keyId.hashCode());
        result = result * 59 + (this.keyVersionId == null ? 43 : this.keyVersionId.hashCode());
        result = result * 59 + (this.messageType == null ? 43 : this.messageType.hashCode());
        result = result * 59 + (this.signingAlgorithm == null ? 43 : this.signingAlgorithm.hashCode());
        result = result * 59 + (this.loggingContext == null ? 43 : this.loggingContext.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum SigningAlgorithm implements BmcEnum
    {
        Sha224RsaPkcsPss("SHA_224_RSA_PKCS_PSS"),
        Sha256RsaPkcsPss("SHA_256_RSA_PKCS_PSS"),
        Sha384RsaPkcsPss("SHA_384_RSA_PKCS_PSS"),
        Sha512RsaPkcsPss("SHA_512_RSA_PKCS_PSS"),
        Sha224RsaPkcs1V15("SHA_224_RSA_PKCS1_V1_5"),
        Sha256RsaPkcs1V15("SHA_256_RSA_PKCS1_V1_5"),
        Sha384RsaPkcs1V15("SHA_384_RSA_PKCS1_V1_5"),
        Sha512RsaPkcs1V15("SHA_512_RSA_PKCS1_V1_5"),
        EcdsaSha256("ECDSA_SHA_256"),
        EcdsaSha384("ECDSA_SHA_384"),
        EcdsaSha512("ECDSA_SHA_512");

        private final String value;
        private static Map<String, SigningAlgorithm> map;

        private SigningAlgorithm(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SigningAlgorithm create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SigningAlgorithm: " + key);
        }

        static {
            map = new HashMap<String, SigningAlgorithm>();
            for (SigningAlgorithm v : SigningAlgorithm.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum MessageType implements BmcEnum
    {
        Raw("RAW"),
        Digest("DIGEST");

        private final String value;
        private static Map<String, MessageType> map;

        private MessageType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static MessageType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid MessageType: " + key);
        }

        static {
            map = new HashMap<String, MessageType>();
            for (MessageType v : MessageType.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="message")
        private String message;
        @JsonProperty(value="keyId")
        private String keyId;
        @JsonProperty(value="keyVersionId")
        private String keyVersionId;
        @JsonProperty(value="messageType")
        private MessageType messageType;
        @JsonProperty(value="signingAlgorithm")
        private SigningAlgorithm signingAlgorithm;
        @JsonProperty(value="loggingContext")
        private Map<String, String> loggingContext;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder message(String message) {
            this.message = message;
            this.__explicitlySet__.add("message");
            return this;
        }

        public Builder keyId(String keyId) {
            this.keyId = keyId;
            this.__explicitlySet__.add("keyId");
            return this;
        }

        public Builder keyVersionId(String keyVersionId) {
            this.keyVersionId = keyVersionId;
            this.__explicitlySet__.add("keyVersionId");
            return this;
        }

        public Builder messageType(MessageType messageType) {
            this.messageType = messageType;
            this.__explicitlySet__.add("messageType");
            return this;
        }

        public Builder signingAlgorithm(SigningAlgorithm signingAlgorithm) {
            this.signingAlgorithm = signingAlgorithm;
            this.__explicitlySet__.add("signingAlgorithm");
            return this;
        }

        public Builder loggingContext(Map<String, String> loggingContext) {
            this.loggingContext = loggingContext;
            this.__explicitlySet__.add("loggingContext");
            return this;
        }

        public SignDataDetails build() {
            SignDataDetails model = new SignDataDetails(this.message, this.keyId, this.keyVersionId, this.messageType, this.signingAlgorithm, this.loggingContext);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(SignDataDetails model) {
            if (model.wasPropertyExplicitlySet("message")) {
                this.message(model.getMessage());
            }
            if (model.wasPropertyExplicitlySet("keyId")) {
                this.keyId(model.getKeyId());
            }
            if (model.wasPropertyExplicitlySet("keyVersionId")) {
                this.keyVersionId(model.getKeyVersionId());
            }
            if (model.wasPropertyExplicitlySet("messageType")) {
                this.messageType(model.getMessageType());
            }
            if (model.wasPropertyExplicitlySet("signingAlgorithm")) {
                this.signingAlgorithm(model.getSigningAlgorithm());
            }
            if (model.wasPropertyExplicitlySet("loggingContext")) {
                this.loggingContext(model.getLoggingContext());
            }
            return this;
        }
    }
}

