/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.keymanagement.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class AutoKeyRotationDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="rotationIntervalInDays")
    private final Integer rotationIntervalInDays;
    @JsonProperty(value="timeOfScheduleStart")
    private final Date timeOfScheduleStart;
    @JsonProperty(value="timeOfNextRotation")
    private final Date timeOfNextRotation;
    @JsonProperty(value="timeOfLastRotation")
    private final Date timeOfLastRotation;
    @JsonProperty(value="lastRotationStatus")
    private final LastRotationStatus lastRotationStatus;
    @JsonProperty(value="lastRotationMessage")
    private final String lastRotationMessage;

    @Deprecated
    @ConstructorProperties(value={"rotationIntervalInDays", "timeOfScheduleStart", "timeOfNextRotation", "timeOfLastRotation", "lastRotationStatus", "lastRotationMessage"})
    public AutoKeyRotationDetails(Integer rotationIntervalInDays, Date timeOfScheduleStart, Date timeOfNextRotation, Date timeOfLastRotation, LastRotationStatus lastRotationStatus, String lastRotationMessage) {
        this.rotationIntervalInDays = rotationIntervalInDays;
        this.timeOfScheduleStart = timeOfScheduleStart;
        this.timeOfNextRotation = timeOfNextRotation;
        this.timeOfLastRotation = timeOfLastRotation;
        this.lastRotationStatus = lastRotationStatus;
        this.lastRotationMessage = lastRotationMessage;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Integer getRotationIntervalInDays() {
        return this.rotationIntervalInDays;
    }

    public Date getTimeOfScheduleStart() {
        return this.timeOfScheduleStart;
    }

    public Date getTimeOfNextRotation() {
        return this.timeOfNextRotation;
    }

    public Date getTimeOfLastRotation() {
        return this.timeOfLastRotation;
    }

    public LastRotationStatus getLastRotationStatus() {
        return this.lastRotationStatus;
    }

    public String getLastRotationMessage() {
        return this.lastRotationMessage;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("AutoKeyRotationDetails(");
        sb.append("super=").append(super.toString());
        sb.append("rotationIntervalInDays=").append(String.valueOf(this.rotationIntervalInDays));
        sb.append(", timeOfScheduleStart=").append(String.valueOf(this.timeOfScheduleStart));
        sb.append(", timeOfNextRotation=").append(String.valueOf(this.timeOfNextRotation));
        sb.append(", timeOfLastRotation=").append(String.valueOf(this.timeOfLastRotation));
        sb.append(", lastRotationStatus=").append(String.valueOf((Object)this.lastRotationStatus));
        sb.append(", lastRotationMessage=").append(String.valueOf(this.lastRotationMessage));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AutoKeyRotationDetails)) {
            return false;
        }
        AutoKeyRotationDetails other = (AutoKeyRotationDetails)((Object)o);
        return Objects.equals(this.rotationIntervalInDays, other.rotationIntervalInDays) && Objects.equals(this.timeOfScheduleStart, other.timeOfScheduleStart) && Objects.equals(this.timeOfNextRotation, other.timeOfNextRotation) && Objects.equals(this.timeOfLastRotation, other.timeOfLastRotation) && Objects.equals((Object)this.lastRotationStatus, (Object)other.lastRotationStatus) && Objects.equals(this.lastRotationMessage, other.lastRotationMessage) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.rotationIntervalInDays == null ? 43 : this.rotationIntervalInDays.hashCode());
        result = result * 59 + (this.timeOfScheduleStart == null ? 43 : this.timeOfScheduleStart.hashCode());
        result = result * 59 + (this.timeOfNextRotation == null ? 43 : this.timeOfNextRotation.hashCode());
        result = result * 59 + (this.timeOfLastRotation == null ? 43 : this.timeOfLastRotation.hashCode());
        result = result * 59 + (this.lastRotationStatus == null ? 43 : this.lastRotationStatus.hashCode());
        result = result * 59 + (this.lastRotationMessage == null ? 43 : this.lastRotationMessage.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum LastRotationStatus implements BmcEnum
    {
        Success("SUCCESS"),
        Failed("FAILED"),
        InProgress("IN_PROGRESS"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LastRotationStatus> map;

        private LastRotationStatus(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LastRotationStatus create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LastRotationStatus', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LastRotationStatus.class);
            map = new HashMap<String, LastRotationStatus>();
            for (LastRotationStatus v : LastRotationStatus.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="rotationIntervalInDays")
        private Integer rotationIntervalInDays;
        @JsonProperty(value="timeOfScheduleStart")
        private Date timeOfScheduleStart;
        @JsonProperty(value="timeOfNextRotation")
        private Date timeOfNextRotation;
        @JsonProperty(value="timeOfLastRotation")
        private Date timeOfLastRotation;
        @JsonProperty(value="lastRotationStatus")
        private LastRotationStatus lastRotationStatus;
        @JsonProperty(value="lastRotationMessage")
        private String lastRotationMessage;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder rotationIntervalInDays(Integer rotationIntervalInDays) {
            this.rotationIntervalInDays = rotationIntervalInDays;
            this.__explicitlySet__.add("rotationIntervalInDays");
            return this;
        }

        public Builder timeOfScheduleStart(Date timeOfScheduleStart) {
            this.timeOfScheduleStart = timeOfScheduleStart;
            this.__explicitlySet__.add("timeOfScheduleStart");
            return this;
        }

        public Builder timeOfNextRotation(Date timeOfNextRotation) {
            this.timeOfNextRotation = timeOfNextRotation;
            this.__explicitlySet__.add("timeOfNextRotation");
            return this;
        }

        public Builder timeOfLastRotation(Date timeOfLastRotation) {
            this.timeOfLastRotation = timeOfLastRotation;
            this.__explicitlySet__.add("timeOfLastRotation");
            return this;
        }

        public Builder lastRotationStatus(LastRotationStatus lastRotationStatus) {
            this.lastRotationStatus = lastRotationStatus;
            this.__explicitlySet__.add("lastRotationStatus");
            return this;
        }

        public Builder lastRotationMessage(String lastRotationMessage) {
            this.lastRotationMessage = lastRotationMessage;
            this.__explicitlySet__.add("lastRotationMessage");
            return this;
        }

        public AutoKeyRotationDetails build() {
            AutoKeyRotationDetails model = new AutoKeyRotationDetails(this.rotationIntervalInDays, this.timeOfScheduleStart, this.timeOfNextRotation, this.timeOfLastRotation, this.lastRotationStatus, this.lastRotationMessage);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(AutoKeyRotationDetails model) {
            if (model.wasPropertyExplicitlySet("rotationIntervalInDays")) {
                this.rotationIntervalInDays(model.getRotationIntervalInDays());
            }
            if (model.wasPropertyExplicitlySet("timeOfScheduleStart")) {
                this.timeOfScheduleStart(model.getTimeOfScheduleStart());
            }
            if (model.wasPropertyExplicitlySet("timeOfNextRotation")) {
                this.timeOfNextRotation(model.getTimeOfNextRotation());
            }
            if (model.wasPropertyExplicitlySet("timeOfLastRotation")) {
                this.timeOfLastRotation(model.getTimeOfLastRotation());
            }
            if (model.wasPropertyExplicitlySet("lastRotationStatus")) {
                this.lastRotationStatus(model.getLastRotationStatus());
            }
            if (model.wasPropertyExplicitlySet("lastRotationMessage")) {
                this.lastRotationMessage(model.getLastRotationMessage());
            }
            return this;
        }
    }
}

