/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.keymanagement.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.keymanagement.model.DecryptDataDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class DecryptRequest
extends BmcRequest<DecryptDataDetails> {
    private DecryptDataDetails decryptDataDetails;
    private String opcRequestId;

    public DecryptDataDetails getDecryptDataDetails() {
        return this.decryptDataDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public DecryptDataDetails getBody$() {
        return this.decryptDataDetails;
    }

    public Builder toBuilder() {
        return new Builder().decryptDataDetails(this.decryptDataDetails).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",decryptDataDetails=").append(String.valueOf((Object)this.decryptDataDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DecryptRequest)) {
            return false;
        }
        DecryptRequest other = (DecryptRequest)((Object)o);
        return super.equals(o) && Objects.equals((Object)this.decryptDataDetails, (Object)other.decryptDataDetails) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.decryptDataDetails == null ? 43 : this.decryptDataDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<DecryptRequest, DecryptDataDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private DecryptDataDetails decryptDataDetails = null;
        private String opcRequestId = null;

        public Builder decryptDataDetails(DecryptDataDetails decryptDataDetails) {
            this.decryptDataDetails = decryptDataDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DecryptRequest o) {
            this.decryptDataDetails(o.getDecryptDataDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DecryptRequest build() {
            DecryptRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(DecryptDataDetails body) {
            this.decryptDataDetails(body);
            return this;
        }

        public DecryptRequest buildWithoutInvocationCallback() {
            DecryptRequest request = new DecryptRequest();
            request.decryptDataDetails = this.decryptDataDetails;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

