/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.keymanagement;

import com.oracle.bmc.keymanagement.KmsHsmCluster;
import com.oracle.bmc.keymanagement.model.HsmCluster;
import com.oracle.bmc.keymanagement.model.HsmPartition;
import com.oracle.bmc.keymanagement.requests.GetHsmClusterRequest;
import com.oracle.bmc.keymanagement.requests.GetHsmPartitionRequest;
import com.oracle.bmc.keymanagement.responses.GetHsmClusterResponse;
import com.oracle.bmc.keymanagement.responses.GetHsmPartitionResponse;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class KmsHsmClusterWaiters {
    private final ExecutorService executorService;
    private final KmsHsmCluster client;

    public KmsHsmClusterWaiters(ExecutorService executorService, KmsHsmCluster client) {
        this.executorService = executorService;
        this.client = client;
    }

    public Waiter<GetHsmClusterRequest, GetHsmClusterResponse> forHsmCluster(GetHsmClusterRequest request, HsmCluster.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forHsmCluster(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetHsmClusterRequest, GetHsmClusterResponse> forHsmCluster(GetHsmClusterRequest request, HsmCluster.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forHsmCluster(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetHsmClusterRequest, GetHsmClusterResponse> forHsmCluster(GetHsmClusterRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, HsmCluster.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forHsmCluster(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetHsmClusterRequest, GetHsmClusterResponse> forHsmCluster(BmcGenericWaiter waiter, GetHsmClusterRequest request, HsmCluster.LifecycleState ... targetStates) {
        final HashSet<HsmCluster.LifecycleState> targetStatesSet = new HashSet<HsmCluster.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetHsmClusterRequest, GetHsmClusterResponse>(){

            @Override
            public GetHsmClusterResponse apply(GetHsmClusterRequest request) {
                return KmsHsmClusterWaiters.this.client.getHsmCluster(request);
            }
        }, (Predicate)new Predicate<GetHsmClusterResponse>(){

            @Override
            public boolean test(GetHsmClusterResponse response) {
                return targetStatesSet.contains((Object)response.getHsmCluster().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)HsmCluster.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetHsmPartitionRequest, GetHsmPartitionResponse> forHsmPartition(GetHsmPartitionRequest request, HsmPartition.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forHsmPartition(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetHsmPartitionRequest, GetHsmPartitionResponse> forHsmPartition(GetHsmPartitionRequest request, HsmPartition.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forHsmPartition(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetHsmPartitionRequest, GetHsmPartitionResponse> forHsmPartition(GetHsmPartitionRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, HsmPartition.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forHsmPartition(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetHsmPartitionRequest, GetHsmPartitionResponse> forHsmPartition(BmcGenericWaiter waiter, GetHsmPartitionRequest request, HsmPartition.LifecycleState ... targetStates) {
        final HashSet<HsmPartition.LifecycleState> targetStatesSet = new HashSet<HsmPartition.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetHsmPartitionRequest, GetHsmPartitionResponse>(){

            @Override
            public GetHsmPartitionResponse apply(GetHsmPartitionRequest request) {
                return KmsHsmClusterWaiters.this.client.getHsmPartition(request);
            }
        }, (Predicate)new Predicate<GetHsmPartitionResponse>(){

            @Override
            public boolean test(GetHsmPartitionResponse response) {
                return targetStatesSet.contains((Object)response.getHsmPartition().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)HsmPartition.LifecycleState.Deleted)), (Object)request);
    }
}

