/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.keymanagement.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class PortInformation
extends ExplicitlySetBmcModel {
    @JsonProperty(value="portNumber")
    private final Integer portNumber;
    @JsonProperty(value="portType")
    private final PortType portType;

    @Deprecated
    @ConstructorProperties(value={"portNumber", "portType"})
    public PortInformation(Integer portNumber, PortType portType) {
        this.portNumber = portNumber;
        this.portType = portType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Integer getPortNumber() {
        return this.portNumber;
    }

    public PortType getPortType() {
        return this.portType;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("PortInformation(");
        sb.append("super=").append(super.toString());
        sb.append("portNumber=").append(String.valueOf(this.portNumber));
        sb.append(", portType=").append(String.valueOf((Object)this.portType));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PortInformation)) {
            return false;
        }
        PortInformation other = (PortInformation)((Object)o);
        return Objects.equals(this.portNumber, other.portNumber) && Objects.equals((Object)this.portType, (Object)other.portType) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.portNumber == null ? 43 : this.portNumber.hashCode());
        result = result * 59 + (this.portType == null ? 43 : this.portType.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum PortType implements BmcEnum
    {
        Clientutility("CLIENTUTILITY"),
        Managementutility("MANAGEMENTUTILITY"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, PortType> map;

        private PortType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static PortType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'PortType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(PortType.class);
            map = new HashMap<String, PortType>();
            for (PortType v : PortType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="portNumber")
        private Integer portNumber;
        @JsonProperty(value="portType")
        private PortType portType;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder portNumber(Integer portNumber) {
            this.portNumber = portNumber;
            this.__explicitlySet__.add("portNumber");
            return this;
        }

        public Builder portType(PortType portType) {
            this.portType = portType;
            this.__explicitlySet__.add("portType");
            return this;
        }

        public PortInformation build() {
            PortInformation model = new PortInformation(this.portNumber, this.portType);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(PortInformation model) {
            if (model.wasPropertyExplicitlySet("portNumber")) {
                this.portNumber(model.getPortNumber());
            }
            if (model.wasPropertyExplicitlySet("portType")) {
                this.portType(model.getPortType());
            }
            return this;
        }
    }
}

