/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.keymanagement.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetHsmPartitionRequest
extends BmcRequest<Void> {
    private String hsmClusterId;
    private String hsmPartitionId;
    private String opcRequestId;
    private String opcRetryToken;

    public String getHsmClusterId() {
        return this.hsmClusterId;
    }

    public String getHsmPartitionId() {
        return this.hsmPartitionId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public Builder toBuilder() {
        return new Builder().hsmClusterId(this.hsmClusterId).hsmPartitionId(this.hsmPartitionId).opcRequestId(this.opcRequestId).opcRetryToken(this.opcRetryToken);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",hsmClusterId=").append(String.valueOf(this.hsmClusterId));
        sb.append(",hsmPartitionId=").append(String.valueOf(this.hsmPartitionId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetHsmPartitionRequest)) {
            return false;
        }
        GetHsmPartitionRequest other = (GetHsmPartitionRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.hsmClusterId, other.hsmClusterId) && Objects.equals(this.hsmPartitionId, other.hsmPartitionId) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcRetryToken, other.opcRetryToken);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.hsmClusterId == null ? 43 : this.hsmClusterId.hashCode());
        result = result * 59 + (this.hsmPartitionId == null ? 43 : this.hsmPartitionId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetHsmPartitionRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String hsmClusterId = null;
        private String hsmPartitionId = null;
        private String opcRequestId = null;
        private String opcRetryToken = null;

        public Builder hsmClusterId(String hsmClusterId) {
            this.hsmClusterId = hsmClusterId;
            return this;
        }

        public Builder hsmPartitionId(String hsmPartitionId) {
            this.hsmPartitionId = hsmPartitionId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetHsmPartitionRequest o) {
            this.hsmClusterId(o.getHsmClusterId());
            this.hsmPartitionId(o.getHsmPartitionId());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetHsmPartitionRequest build() {
            GetHsmPartitionRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetHsmPartitionRequest buildWithoutInvocationCallback() {
            GetHsmPartitionRequest request = new GetHsmPartitionRequest();
            request.hsmClusterId = this.hsmClusterId;
            request.hsmPartitionId = this.hsmPartitionId;
            request.opcRequestId = this.opcRequestId;
            request.opcRetryToken = this.opcRetryToken;
            return request;
        }
    }
}

