/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.keymanagement;

import com.oracle.bmc.keymanagement.Ekm;
import com.oracle.bmc.keymanagement.model.EkmsPrivateEndpointSummary;
import com.oracle.bmc.keymanagement.requests.ListEkmsPrivateEndpointsRequest;
import com.oracle.bmc.keymanagement.responses.ListEkmsPrivateEndpointsResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class EkmPaginators {
    private final Ekm client;

    public EkmPaginators(Ekm client) {
        this.client = client;
    }

    public Iterable<ListEkmsPrivateEndpointsResponse> listEkmsPrivateEndpointsResponseIterator(final ListEkmsPrivateEndpointsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListEkmsPrivateEndpointsRequest.Builder>(){

            @Override
            public ListEkmsPrivateEndpointsRequest.Builder get() {
                return ListEkmsPrivateEndpointsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListEkmsPrivateEndpointsResponse, String>(){

            @Override
            public String apply(ListEkmsPrivateEndpointsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListEkmsPrivateEndpointsRequest.Builder>, ListEkmsPrivateEndpointsRequest>(){

            @Override
            public ListEkmsPrivateEndpointsRequest apply(RequestBuilderAndToken<ListEkmsPrivateEndpointsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListEkmsPrivateEndpointsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListEkmsPrivateEndpointsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListEkmsPrivateEndpointsRequest, ListEkmsPrivateEndpointsResponse>(){

            @Override
            public ListEkmsPrivateEndpointsResponse apply(ListEkmsPrivateEndpointsRequest request) {
                return EkmPaginators.this.client.listEkmsPrivateEndpoints(request);
            }
        });
    }

    public Iterable<EkmsPrivateEndpointSummary> listEkmsPrivateEndpointsRecordIterator(final ListEkmsPrivateEndpointsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListEkmsPrivateEndpointsRequest.Builder>(){

            @Override
            public ListEkmsPrivateEndpointsRequest.Builder get() {
                return ListEkmsPrivateEndpointsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListEkmsPrivateEndpointsResponse, String>(){

            @Override
            public String apply(ListEkmsPrivateEndpointsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListEkmsPrivateEndpointsRequest.Builder>, ListEkmsPrivateEndpointsRequest>(){

            @Override
            public ListEkmsPrivateEndpointsRequest apply(RequestBuilderAndToken<ListEkmsPrivateEndpointsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListEkmsPrivateEndpointsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListEkmsPrivateEndpointsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListEkmsPrivateEndpointsRequest, ListEkmsPrivateEndpointsResponse>(){

            @Override
            public ListEkmsPrivateEndpointsResponse apply(ListEkmsPrivateEndpointsRequest request) {
                return EkmPaginators.this.client.listEkmsPrivateEndpoints(request);
            }
        }, (Function)new Function<ListEkmsPrivateEndpointsResponse, List<EkmsPrivateEndpointSummary>>(){

            @Override
            public List<EkmsPrivateEndpointSummary> apply(ListEkmsPrivateEndpointsResponse response) {
                return response.getItems();
            }
        });
    }
}

