/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.keymanagement.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.keymanagement.model.AutoKeyRotationDetails;
import com.oracle.bmc.keymanagement.model.ExternalKeyReference;
import com.oracle.bmc.keymanagement.model.KeyShape;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class CreateKeyDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="keyShape")
    private final KeyShape keyShape;
    @JsonProperty(value="isAutoRotationEnabled")
    private final Boolean isAutoRotationEnabled;
    @JsonProperty(value="autoKeyRotationDetails")
    private final AutoKeyRotationDetails autoKeyRotationDetails;
    @JsonProperty(value="protectionMode")
    private final ProtectionMode protectionMode;
    @JsonProperty(value="externalKeyReference")
    private final ExternalKeyReference externalKeyReference;

    @Deprecated
    @ConstructorProperties(value={"compartmentId", "definedTags", "displayName", "freeformTags", "keyShape", "isAutoRotationEnabled", "autoKeyRotationDetails", "protectionMode", "externalKeyReference"})
    public CreateKeyDetails(String compartmentId, Map<String, Map<String, Object>> definedTags, String displayName, Map<String, String> freeformTags, KeyShape keyShape, Boolean isAutoRotationEnabled, AutoKeyRotationDetails autoKeyRotationDetails, ProtectionMode protectionMode, ExternalKeyReference externalKeyReference) {
        this.compartmentId = compartmentId;
        this.definedTags = definedTags;
        this.displayName = displayName;
        this.freeformTags = freeformTags;
        this.keyShape = keyShape;
        this.isAutoRotationEnabled = isAutoRotationEnabled;
        this.autoKeyRotationDetails = autoKeyRotationDetails;
        this.protectionMode = protectionMode;
        this.externalKeyReference = externalKeyReference;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public KeyShape getKeyShape() {
        return this.keyShape;
    }

    public Boolean getIsAutoRotationEnabled() {
        return this.isAutoRotationEnabled;
    }

    public AutoKeyRotationDetails getAutoKeyRotationDetails() {
        return this.autoKeyRotationDetails;
    }

    public ProtectionMode getProtectionMode() {
        return this.protectionMode;
    }

    public ExternalKeyReference getExternalKeyReference() {
        return this.externalKeyReference;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CreateKeyDetails(");
        sb.append("super=").append(super.toString());
        sb.append("compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", keyShape=").append(String.valueOf((Object)this.keyShape));
        sb.append(", isAutoRotationEnabled=").append(String.valueOf(this.isAutoRotationEnabled));
        sb.append(", autoKeyRotationDetails=").append(String.valueOf((Object)this.autoKeyRotationDetails));
        sb.append(", protectionMode=").append(String.valueOf((Object)this.protectionMode));
        sb.append(", externalKeyReference=").append(String.valueOf((Object)this.externalKeyReference));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateKeyDetails)) {
            return false;
        }
        CreateKeyDetails other = (CreateKeyDetails)((Object)o);
        return Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals((Object)this.keyShape, (Object)other.keyShape) && Objects.equals(this.isAutoRotationEnabled, other.isAutoRotationEnabled) && Objects.equals((Object)this.autoKeyRotationDetails, (Object)other.autoKeyRotationDetails) && Objects.equals((Object)this.protectionMode, (Object)other.protectionMode) && Objects.equals((Object)this.externalKeyReference, (Object)other.externalKeyReference) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.keyShape == null ? 43 : this.keyShape.hashCode());
        result = result * 59 + (this.isAutoRotationEnabled == null ? 43 : this.isAutoRotationEnabled.hashCode());
        result = result * 59 + (this.autoKeyRotationDetails == null ? 43 : this.autoKeyRotationDetails.hashCode());
        result = result * 59 + (this.protectionMode == null ? 43 : this.protectionMode.hashCode());
        result = result * 59 + (this.externalKeyReference == null ? 43 : this.externalKeyReference.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum ProtectionMode implements BmcEnum
    {
        Hsm("HSM"),
        Software("SOFTWARE"),
        External("EXTERNAL");

        private final String value;
        private static Map<String, ProtectionMode> map;

        private ProtectionMode(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ProtectionMode create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid ProtectionMode: " + key);
        }

        static {
            map = new HashMap<String, ProtectionMode>();
            for (ProtectionMode v : ProtectionMode.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="keyShape")
        private KeyShape keyShape;
        @JsonProperty(value="isAutoRotationEnabled")
        private Boolean isAutoRotationEnabled;
        @JsonProperty(value="autoKeyRotationDetails")
        private AutoKeyRotationDetails autoKeyRotationDetails;
        @JsonProperty(value="protectionMode")
        private ProtectionMode protectionMode;
        @JsonProperty(value="externalKeyReference")
        private ExternalKeyReference externalKeyReference;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder keyShape(KeyShape keyShape) {
            this.keyShape = keyShape;
            this.__explicitlySet__.add("keyShape");
            return this;
        }

        public Builder isAutoRotationEnabled(Boolean isAutoRotationEnabled) {
            this.isAutoRotationEnabled = isAutoRotationEnabled;
            this.__explicitlySet__.add("isAutoRotationEnabled");
            return this;
        }

        public Builder autoKeyRotationDetails(AutoKeyRotationDetails autoKeyRotationDetails) {
            this.autoKeyRotationDetails = autoKeyRotationDetails;
            this.__explicitlySet__.add("autoKeyRotationDetails");
            return this;
        }

        public Builder protectionMode(ProtectionMode protectionMode) {
            this.protectionMode = protectionMode;
            this.__explicitlySet__.add("protectionMode");
            return this;
        }

        public Builder externalKeyReference(ExternalKeyReference externalKeyReference) {
            this.externalKeyReference = externalKeyReference;
            this.__explicitlySet__.add("externalKeyReference");
            return this;
        }

        public CreateKeyDetails build() {
            CreateKeyDetails model = new CreateKeyDetails(this.compartmentId, this.definedTags, this.displayName, this.freeformTags, this.keyShape, this.isAutoRotationEnabled, this.autoKeyRotationDetails, this.protectionMode, this.externalKeyReference);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CreateKeyDetails model) {
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("keyShape")) {
                this.keyShape(model.getKeyShape());
            }
            if (model.wasPropertyExplicitlySet("isAutoRotationEnabled")) {
                this.isAutoRotationEnabled(model.getIsAutoRotationEnabled());
            }
            if (model.wasPropertyExplicitlySet("autoKeyRotationDetails")) {
                this.autoKeyRotationDetails(model.getAutoKeyRotationDetails());
            }
            if (model.wasPropertyExplicitlySet("protectionMode")) {
                this.protectionMode(model.getProtectionMode());
            }
            if (model.wasPropertyExplicitlySet("externalKeyReference")) {
                this.externalKeyReference(model.getExternalKeyReference());
            }
            return this;
        }
    }
}

