/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.keymanagement.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.keymanagement.model.ReplicaVaultMetadata;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="vaultType")
@JsonFilter(value="explicitlySetFilter")
public final class ReplicaExternalVaultMetadata
extends ReplicaVaultMetadata {
    @JsonProperty(value="privateEndpointId")
    private final String privateEndpointId;
    @JsonProperty(value="idcsAccountNameUrl")
    private final String idcsAccountNameUrl;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public ReplicaExternalVaultMetadata(String privateEndpointId, String idcsAccountNameUrl) {
        this.privateEndpointId = privateEndpointId;
        this.idcsAccountNameUrl = idcsAccountNameUrl;
    }

    public String getPrivateEndpointId() {
        return this.privateEndpointId;
    }

    public String getIdcsAccountNameUrl() {
        return this.idcsAccountNameUrl;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ReplicaExternalVaultMetadata(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", privateEndpointId=").append(String.valueOf(this.privateEndpointId));
        sb.append(", idcsAccountNameUrl=").append(String.valueOf(this.idcsAccountNameUrl));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ReplicaExternalVaultMetadata)) {
            return false;
        }
        ReplicaExternalVaultMetadata other = (ReplicaExternalVaultMetadata)((Object)o);
        return Objects.equals(this.privateEndpointId, other.privateEndpointId) && Objects.equals(this.idcsAccountNameUrl, other.idcsAccountNameUrl) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.privateEndpointId == null ? 43 : this.privateEndpointId.hashCode());
        result = result * 59 + (this.idcsAccountNameUrl == null ? 43 : this.idcsAccountNameUrl.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="privateEndpointId")
        private String privateEndpointId;
        @JsonProperty(value="idcsAccountNameUrl")
        private String idcsAccountNameUrl;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder privateEndpointId(String privateEndpointId) {
            this.privateEndpointId = privateEndpointId;
            this.__explicitlySet__.add("privateEndpointId");
            return this;
        }

        public Builder idcsAccountNameUrl(String idcsAccountNameUrl) {
            this.idcsAccountNameUrl = idcsAccountNameUrl;
            this.__explicitlySet__.add("idcsAccountNameUrl");
            return this;
        }

        public ReplicaExternalVaultMetadata build() {
            ReplicaExternalVaultMetadata model = new ReplicaExternalVaultMetadata(this.privateEndpointId, this.idcsAccountNameUrl);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ReplicaExternalVaultMetadata model) {
            if (model.wasPropertyExplicitlySet("privateEndpointId")) {
                this.privateEndpointId(model.getPrivateEndpointId());
            }
            if (model.wasPropertyExplicitlySet("idcsAccountNameUrl")) {
                this.idcsAccountNameUrl(model.getIdcsAccountNameUrl());
            }
            return this;
        }
    }
}

