/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.keymanagement;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.keymanagement.KmsHsmClusterAsync;
import com.oracle.bmc.keymanagement.model.HsmCluster;
import com.oracle.bmc.keymanagement.model.HsmClusterCollection;
import com.oracle.bmc.keymanagement.model.HsmPartition;
import com.oracle.bmc.keymanagement.model.HsmPartitionCollection;
import com.oracle.bmc.keymanagement.model.PreCoUserCredentials;
import com.oracle.bmc.keymanagement.requests.CancelHsmClusterDeletionRequest;
import com.oracle.bmc.keymanagement.requests.ChangeHsmClusterCompartmentRequest;
import com.oracle.bmc.keymanagement.requests.CreateHsmClusterRequest;
import com.oracle.bmc.keymanagement.requests.DownloadCertificateSigningRequestRequest;
import com.oracle.bmc.keymanagement.requests.GetHsmClusterRequest;
import com.oracle.bmc.keymanagement.requests.GetHsmPartitionRequest;
import com.oracle.bmc.keymanagement.requests.GetPreCoUserCredentialsRequest;
import com.oracle.bmc.keymanagement.requests.ListHsmClustersRequest;
import com.oracle.bmc.keymanagement.requests.ListHsmPartitionsRequest;
import com.oracle.bmc.keymanagement.requests.ScheduleHsmClusterDeletionRequest;
import com.oracle.bmc.keymanagement.requests.UpdateHsmClusterRequest;
import com.oracle.bmc.keymanagement.requests.UploadPartitionCertificatesRequest;
import com.oracle.bmc.keymanagement.responses.CancelHsmClusterDeletionResponse;
import com.oracle.bmc.keymanagement.responses.ChangeHsmClusterCompartmentResponse;
import com.oracle.bmc.keymanagement.responses.CreateHsmClusterResponse;
import com.oracle.bmc.keymanagement.responses.DownloadCertificateSigningRequestResponse;
import com.oracle.bmc.keymanagement.responses.GetHsmClusterResponse;
import com.oracle.bmc.keymanagement.responses.GetHsmPartitionResponse;
import com.oracle.bmc.keymanagement.responses.GetPreCoUserCredentialsResponse;
import com.oracle.bmc.keymanagement.responses.ListHsmClustersResponse;
import com.oracle.bmc.keymanagement.responses.ListHsmPartitionsResponse;
import com.oracle.bmc.keymanagement.responses.ScheduleHsmClusterDeletionResponse;
import com.oracle.bmc.keymanagement.responses.UpdateHsmClusterResponse;
import com.oracle.bmc.keymanagement.responses.UploadPartitionCertificatesResponse;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KmsHsmClusterAsyncClient
extends BaseAsyncClient
implements KmsHsmClusterAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("KMSHSMCLUSTER").serviceEndpointPrefix("kms").serviceEndpointTemplate("https://kms.{region}.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(KmsHsmClusterAsyncClient.class);

    KmsHsmClusterAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<CancelHsmClusterDeletionResponse> cancelHsmClusterDeletion(CancelHsmClusterDeletionRequest request, AsyncHandler<CancelHsmClusterDeletionRequest, CancelHsmClusterDeletionResponse> handler) {
        Validate.notBlank((String)request.getHsmClusterId(), (String)"hsmClusterId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, CancelHsmClusterDeletionResponse::builder).logger(LOG, "cancelHsmClusterDeletion").serviceDetails("KmsHsmCluster", "CancelHsmClusterDeletion", "https://docs.oracle.com/iaas/api/#/en/key/release/HsmCluster/CancelHsmClusterDeletion").method(Method.POST).requestBuilder(CancelHsmClusterDeletionRequest::builder).basePath("/").appendPathParam("20180608").appendPathParam("hsmClusters").appendPathParam(request.getHsmClusterId()).appendPathParam("actions").appendPathParam("cancelDeletion").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleBody(HsmCluster.class, CancelHsmClusterDeletionResponse.Builder::hsmCluster).handleResponseHeaderString("etag", CancelHsmClusterDeletionResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CancelHsmClusterDeletionResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ChangeHsmClusterCompartmentResponse> changeHsmClusterCompartment(ChangeHsmClusterCompartmentRequest request, AsyncHandler<ChangeHsmClusterCompartmentRequest, ChangeHsmClusterCompartmentResponse> handler) {
        Validate.notBlank((String)request.getHsmClusterId(), (String)"hsmClusterId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeHsmClusterCompartmentDetails(), "changeHsmClusterCompartmentDetails is required");
        return this.clientCall(request, ChangeHsmClusterCompartmentResponse::builder).logger(LOG, "changeHsmClusterCompartment").serviceDetails("KmsHsmCluster", "ChangeHsmClusterCompartment", "https://docs.oracle.com/iaas/api/#/en/key/release/HsmCluster/ChangeHsmClusterCompartment").method(Method.POST).requestBuilder(ChangeHsmClusterCompartmentRequest::builder).basePath("/").appendPathParam("20180608").appendPathParam("hsmClusters").appendPathParam(request.getHsmClusterId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("etag", ChangeHsmClusterCompartmentResponse.Builder::etag).handleResponseHeaderString("opc-request-id", ChangeHsmClusterCompartmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateHsmClusterResponse> createHsmCluster(CreateHsmClusterRequest request, AsyncHandler<CreateHsmClusterRequest, CreateHsmClusterResponse> handler) {
        Objects.requireNonNull(request.getCreateHsmClusterDetails(), "createHsmClusterDetails is required");
        return this.clientCall(request, CreateHsmClusterResponse::builder).logger(LOG, "createHsmCluster").serviceDetails("KmsHsmCluster", "CreateHsmCluster", "https://docs.oracle.com/iaas/api/#/en/key/release/HsmCluster/CreateHsmCluster").method(Method.POST).requestBuilder(CreateHsmClusterRequest::builder).basePath("/").appendPathParam("20180608").appendPathParam("hsmClusters").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(HsmCluster.class, CreateHsmClusterResponse.Builder::hsmCluster).handleResponseHeaderString("etag", CreateHsmClusterResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateHsmClusterResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DownloadCertificateSigningRequestResponse> downloadCertificateSigningRequest(DownloadCertificateSigningRequestRequest request, AsyncHandler<DownloadCertificateSigningRequestRequest, DownloadCertificateSigningRequestResponse> handler) {
        Validate.notBlank((String)request.getHsmClusterId(), (String)"hsmClusterId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DownloadCertificateSigningRequestResponse::builder).logger(LOG, "downloadCertificateSigningRequest").serviceDetails("KmsHsmCluster", "DownloadCertificateSigningRequest", "https://docs.oracle.com/iaas/api/#/en/key/release/HsmCluster/DownloadCertificateSigningRequest").method(Method.POST).requestBuilder(DownloadCertificateSigningRequestRequest::builder).basePath("/").appendPathParam("20180608").appendPathParam("hsmClusters").appendPathParam(request.getHsmClusterId()).appendPathParam("actions").appendPathParam("downloadCertificateSigningRequest").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).handleBody(String.class, DownloadCertificateSigningRequestResponse.Builder::value).handleResponseHeaderString("etag", DownloadCertificateSigningRequestResponse.Builder::etag).handleResponseHeaderString("opc-request-id", DownloadCertificateSigningRequestResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetHsmClusterResponse> getHsmCluster(GetHsmClusterRequest request, AsyncHandler<GetHsmClusterRequest, GetHsmClusterResponse> handler) {
        Validate.notBlank((String)request.getHsmClusterId(), (String)"hsmClusterId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetHsmClusterResponse::builder).logger(LOG, "getHsmCluster").serviceDetails("KmsHsmCluster", "GetHsmCluster", "https://docs.oracle.com/iaas/api/#/en/key/release/HsmCluster/GetHsmCluster").method(Method.GET).requestBuilder(GetHsmClusterRequest::builder).basePath("/").appendPathParam("20180608").appendPathParam("hsmClusters").appendPathParam(request.getHsmClusterId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(HsmCluster.class, GetHsmClusterResponse.Builder::hsmCluster).handleResponseHeaderString("etag", GetHsmClusterResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetHsmClusterResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetHsmPartitionResponse> getHsmPartition(GetHsmPartitionRequest request, AsyncHandler<GetHsmPartitionRequest, GetHsmPartitionResponse> handler) {
        Validate.notBlank((String)request.getHsmClusterId(), (String)"hsmClusterId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getHsmPartitionId(), (String)"hsmPartitionId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetHsmPartitionResponse::builder).logger(LOG, "getHsmPartition").serviceDetails("KmsHsmCluster", "GetHsmPartition", "https://docs.oracle.com/iaas/api/#/en/key/release/HsmPartition/GetHsmPartition").method(Method.GET).requestBuilder(GetHsmPartitionRequest::builder).basePath("/").appendPathParam("20180608").appendPathParam("hsmClusters").appendPathParam(request.getHsmClusterId()).appendPathParam("hsmPartitions").appendPathParam(request.getHsmPartitionId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleBody(HsmPartition.class, GetHsmPartitionResponse.Builder::hsmPartition).handleResponseHeaderString("etag", GetHsmPartitionResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetHsmPartitionResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetPreCoUserCredentialsResponse> getPreCoUserCredentials(GetPreCoUserCredentialsRequest request, AsyncHandler<GetPreCoUserCredentialsRequest, GetPreCoUserCredentialsResponse> handler) {
        Validate.notBlank((String)request.getHsmClusterId(), (String)"hsmClusterId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetPreCoUserCredentialsResponse::builder).logger(LOG, "getPreCoUserCredentials").serviceDetails("KmsHsmCluster", "GetPreCoUserCredentials", "https://docs.oracle.com/iaas/api/#/en/key/release/HsmCluster/GetPreCoUserCredentials").method(Method.GET).requestBuilder(GetPreCoUserCredentialsRequest::builder).basePath("/").appendPathParam("20180608").appendPathParam("hsmClusters").appendPathParam(request.getHsmClusterId()).appendPathParam("preCoUserCredentials").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleBody(PreCoUserCredentials.class, GetPreCoUserCredentialsResponse.Builder::preCoUserCredentials).handleResponseHeaderString("etag", GetPreCoUserCredentialsResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetPreCoUserCredentialsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListHsmClustersResponse> listHsmClusters(ListHsmClustersRequest request, AsyncHandler<ListHsmClustersRequest, ListHsmClustersResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListHsmClustersResponse::builder).logger(LOG, "listHsmClusters").serviceDetails("KmsHsmCluster", "ListHsmClusters", "https://docs.oracle.com/iaas/api/#/en/key/release/HsmCluster/ListHsmClusters").method(Method.GET).requestBuilder(ListHsmClustersRequest::builder).basePath("/").appendPathParam("20180608").appendPathParam("hsmClusters").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(HsmClusterCollection.class, ListHsmClustersResponse.Builder::hsmClusterCollection).handleResponseHeaderString("opc-next-page", ListHsmClustersResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListHsmClustersResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListHsmPartitionsResponse> listHsmPartitions(ListHsmPartitionsRequest request, AsyncHandler<ListHsmPartitionsRequest, ListHsmPartitionsResponse> handler) {
        Validate.notBlank((String)request.getHsmClusterId(), (String)"hsmClusterId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListHsmPartitionsResponse::builder).logger(LOG, "listHsmPartitions").serviceDetails("KmsHsmCluster", "ListHsmPartitions", "https://docs.oracle.com/iaas/api/#/en/key/release/HsmPartition/ListHsmPartitions").method(Method.GET).requestBuilder(ListHsmPartitionsRequest::builder).basePath("/").appendPathParam("20180608").appendPathParam("hsmClusters").appendPathParam(request.getHsmClusterId()).appendPathParam("hsmPartitions").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(HsmPartitionCollection.class, ListHsmPartitionsResponse.Builder::hsmPartitionCollection).handleResponseHeaderString("opc-next-page", ListHsmPartitionsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListHsmPartitionsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ScheduleHsmClusterDeletionResponse> scheduleHsmClusterDeletion(ScheduleHsmClusterDeletionRequest request, AsyncHandler<ScheduleHsmClusterDeletionRequest, ScheduleHsmClusterDeletionResponse> handler) {
        Validate.notBlank((String)request.getHsmClusterId(), (String)"hsmClusterId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getScheduleHsmClusterDeletionDetails(), "scheduleHsmClusterDeletionDetails is required");
        return this.clientCall(request, ScheduleHsmClusterDeletionResponse::builder).logger(LOG, "scheduleHsmClusterDeletion").serviceDetails("KmsHsmCluster", "ScheduleHsmClusterDeletion", "https://docs.oracle.com/iaas/api/#/en/key/release/HsmCluster/ScheduleHsmClusterDeletion").method(Method.POST).requestBuilder(ScheduleHsmClusterDeletionRequest::builder).basePath("/").appendPathParam("20180608").appendPathParam("hsmClusters").appendPathParam(request.getHsmClusterId()).appendPathParam("actions").appendPathParam("scheduleDeletion").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(HsmCluster.class, ScheduleHsmClusterDeletionResponse.Builder::hsmCluster).handleResponseHeaderString("etag", ScheduleHsmClusterDeletionResponse.Builder::etag).handleResponseHeaderString("opc-request-id", ScheduleHsmClusterDeletionResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateHsmClusterResponse> updateHsmCluster(UpdateHsmClusterRequest request, AsyncHandler<UpdateHsmClusterRequest, UpdateHsmClusterResponse> handler) {
        Validate.notBlank((String)request.getHsmClusterId(), (String)"hsmClusterId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateHsmClusterDetails(), "updateHsmClusterDetails is required");
        return this.clientCall(request, UpdateHsmClusterResponse::builder).logger(LOG, "updateHsmCluster").serviceDetails("KmsHsmCluster", "UpdateHsmCluster", "https://docs.oracle.com/iaas/api/#/en/key/release/HsmCluster/UpdateHsmCluster").method(Method.PUT).requestBuilder(UpdateHsmClusterRequest::builder).basePath("/").appendPathParam("20180608").appendPathParam("hsmClusters").appendPathParam(request.getHsmClusterId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(HsmCluster.class, UpdateHsmClusterResponse.Builder::hsmCluster).handleResponseHeaderString("etag", UpdateHsmClusterResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateHsmClusterResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UploadPartitionCertificatesResponse> uploadPartitionCertificates(UploadPartitionCertificatesRequest request, AsyncHandler<UploadPartitionCertificatesRequest, UploadPartitionCertificatesResponse> handler) {
        Validate.notBlank((String)request.getHsmClusterId(), (String)"hsmClusterId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUploadPartitionCertificatesDetails(), "uploadPartitionCertificatesDetails is required");
        return this.clientCall(request, UploadPartitionCertificatesResponse::builder).logger(LOG, "uploadPartitionCertificates").serviceDetails("KmsHsmCluster", "UploadPartitionCertificates", "https://docs.oracle.com/iaas/api/#/en/key/release/HsmCluster/UploadPartitionCertificates").method(Method.POST).requestBuilder(UploadPartitionCertificatesRequest::builder).basePath("/").appendPathParam("20180608").appendPathParam("hsmClusters").appendPathParam(request.getHsmClusterId()).appendPathParam("actions").appendPathParam("uploadPartitionCertificates").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("etag", UploadPartitionCertificatesResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UploadPartitionCertificatesResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Deprecated
    public KmsHsmClusterAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)KmsHsmClusterAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public KmsHsmClusterAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(KmsHsmClusterAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public KmsHsmClusterAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)KmsHsmClusterAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public KmsHsmClusterAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)KmsHsmClusterAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public KmsHsmClusterAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)KmsHsmClusterAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public KmsHsmClusterAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)KmsHsmClusterAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public KmsHsmClusterAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)KmsHsmClusterAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, KmsHsmClusterAsyncClient> {
        private Builder(Service service) {
            super(service);
            String packageName = "keymanagement";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"keymanagement");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public KmsHsmClusterAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new KmsHsmClusterAsyncClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider);
        }
    }
}

