/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.keymanagement.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.keymanagement.model.ExternalKeyReferenceDetails;
import com.oracle.bmc.keymanagement.model.KeyVersionReplicaDetails;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class KeyVersion
extends ExplicitlySetBmcModel {
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="keyId")
    private final String keyId;
    @JsonProperty(value="publicKey")
    private final String publicKey;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="origin")
    private final Origin origin;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="timeOfDeletion")
    private final Date timeOfDeletion;
    @JsonProperty(value="vaultId")
    private final String vaultId;
    @JsonProperty(value="restoredFromKeyVersionId")
    private final String restoredFromKeyVersionId;
    @JsonProperty(value="replicaDetails")
    private final KeyVersionReplicaDetails replicaDetails;
    @JsonProperty(value="isPrimary")
    private final Boolean isPrimary;
    @JsonProperty(value="externalKeyReferenceDetails")
    private final ExternalKeyReferenceDetails externalKeyReferenceDetails;
    @JsonProperty(value="isAutoRotated")
    private final Boolean isAutoRotated;

    @Deprecated
    @ConstructorProperties(value={"compartmentId", "id", "keyId", "publicKey", "lifecycleState", "origin", "timeCreated", "timeOfDeletion", "vaultId", "restoredFromKeyVersionId", "replicaDetails", "isPrimary", "externalKeyReferenceDetails", "isAutoRotated"})
    public KeyVersion(String compartmentId, String id, String keyId, String publicKey, LifecycleState lifecycleState, Origin origin, Date timeCreated, Date timeOfDeletion, String vaultId, String restoredFromKeyVersionId, KeyVersionReplicaDetails replicaDetails, Boolean isPrimary, ExternalKeyReferenceDetails externalKeyReferenceDetails, Boolean isAutoRotated) {
        this.compartmentId = compartmentId;
        this.id = id;
        this.keyId = keyId;
        this.publicKey = publicKey;
        this.lifecycleState = lifecycleState;
        this.origin = origin;
        this.timeCreated = timeCreated;
        this.timeOfDeletion = timeOfDeletion;
        this.vaultId = vaultId;
        this.restoredFromKeyVersionId = restoredFromKeyVersionId;
        this.replicaDetails = replicaDetails;
        this.isPrimary = isPrimary;
        this.externalKeyReferenceDetails = externalKeyReferenceDetails;
        this.isAutoRotated = isAutoRotated;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getId() {
        return this.id;
    }

    public String getKeyId() {
        return this.keyId;
    }

    public String getPublicKey() {
        return this.publicKey;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public Origin getOrigin() {
        return this.origin;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Date getTimeOfDeletion() {
        return this.timeOfDeletion;
    }

    public String getVaultId() {
        return this.vaultId;
    }

    public String getRestoredFromKeyVersionId() {
        return this.restoredFromKeyVersionId;
    }

    public KeyVersionReplicaDetails getReplicaDetails() {
        return this.replicaDetails;
    }

    public Boolean getIsPrimary() {
        return this.isPrimary;
    }

    public ExternalKeyReferenceDetails getExternalKeyReferenceDetails() {
        return this.externalKeyReferenceDetails;
    }

    public Boolean getIsAutoRotated() {
        return this.isAutoRotated;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("KeyVersion(");
        sb.append("super=").append(super.toString());
        sb.append("compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", id=").append(String.valueOf(this.id));
        sb.append(", keyId=").append(String.valueOf(this.keyId));
        sb.append(", publicKey=").append(String.valueOf(this.publicKey));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", origin=").append(String.valueOf((Object)this.origin));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", timeOfDeletion=").append(String.valueOf(this.timeOfDeletion));
        sb.append(", vaultId=").append(String.valueOf(this.vaultId));
        sb.append(", restoredFromKeyVersionId=").append(String.valueOf(this.restoredFromKeyVersionId));
        sb.append(", replicaDetails=").append(String.valueOf((Object)this.replicaDetails));
        sb.append(", isPrimary=").append(String.valueOf(this.isPrimary));
        sb.append(", externalKeyReferenceDetails=").append(String.valueOf((Object)this.externalKeyReferenceDetails));
        sb.append(", isAutoRotated=").append(String.valueOf(this.isAutoRotated));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof KeyVersion)) {
            return false;
        }
        KeyVersion other = (KeyVersion)((Object)o);
        return Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.id, other.id) && Objects.equals(this.keyId, other.keyId) && Objects.equals(this.publicKey, other.publicKey) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals((Object)this.origin, (Object)other.origin) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.timeOfDeletion, other.timeOfDeletion) && Objects.equals(this.vaultId, other.vaultId) && Objects.equals(this.restoredFromKeyVersionId, other.restoredFromKeyVersionId) && Objects.equals((Object)this.replicaDetails, (Object)other.replicaDetails) && Objects.equals(this.isPrimary, other.isPrimary) && Objects.equals((Object)this.externalKeyReferenceDetails, (Object)other.externalKeyReferenceDetails) && Objects.equals(this.isAutoRotated, other.isAutoRotated) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.keyId == null ? 43 : this.keyId.hashCode());
        result = result * 59 + (this.publicKey == null ? 43 : this.publicKey.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.origin == null ? 43 : this.origin.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.timeOfDeletion == null ? 43 : this.timeOfDeletion.hashCode());
        result = result * 59 + (this.vaultId == null ? 43 : this.vaultId.hashCode());
        result = result * 59 + (this.restoredFromKeyVersionId == null ? 43 : this.restoredFromKeyVersionId.hashCode());
        result = result * 59 + (this.replicaDetails == null ? 43 : this.replicaDetails.hashCode());
        result = result * 59 + (this.isPrimary == null ? 43 : this.isPrimary.hashCode());
        result = result * 59 + (this.externalKeyReferenceDetails == null ? 43 : this.externalKeyReferenceDetails.hashCode());
        result = result * 59 + (this.isAutoRotated == null ? 43 : this.isAutoRotated.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Origin implements BmcEnum
    {
        Internal("INTERNAL"),
        External("EXTERNAL"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Origin> map;

        private Origin(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Origin create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Origin', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Origin.class);
            map = new HashMap<String, Origin>();
            for (Origin v : Origin.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum LifecycleState implements BmcEnum
    {
        Creating("CREATING"),
        Enabling("ENABLING"),
        Enabled("ENABLED"),
        Disabling("DISABLING"),
        Disabled("DISABLED"),
        Deleting("DELETING"),
        Deleted("DELETED"),
        PendingDeletion("PENDING_DELETION"),
        SchedulingDeletion("SCHEDULING_DELETION"),
        CancellingDeletion("CANCELLING_DELETION"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LifecycleState> map;

        private LifecycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LifecycleState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LifecycleState.class);
            map = new HashMap<String, LifecycleState>();
            for (LifecycleState v : LifecycleState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="keyId")
        private String keyId;
        @JsonProperty(value="publicKey")
        private String publicKey;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="origin")
        private Origin origin;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="timeOfDeletion")
        private Date timeOfDeletion;
        @JsonProperty(value="vaultId")
        private String vaultId;
        @JsonProperty(value="restoredFromKeyVersionId")
        private String restoredFromKeyVersionId;
        @JsonProperty(value="replicaDetails")
        private KeyVersionReplicaDetails replicaDetails;
        @JsonProperty(value="isPrimary")
        private Boolean isPrimary;
        @JsonProperty(value="externalKeyReferenceDetails")
        private ExternalKeyReferenceDetails externalKeyReferenceDetails;
        @JsonProperty(value="isAutoRotated")
        private Boolean isAutoRotated;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder keyId(String keyId) {
            this.keyId = keyId;
            this.__explicitlySet__.add("keyId");
            return this;
        }

        public Builder publicKey(String publicKey) {
            this.publicKey = publicKey;
            this.__explicitlySet__.add("publicKey");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder origin(Origin origin) {
            this.origin = origin;
            this.__explicitlySet__.add("origin");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder timeOfDeletion(Date timeOfDeletion) {
            this.timeOfDeletion = timeOfDeletion;
            this.__explicitlySet__.add("timeOfDeletion");
            return this;
        }

        public Builder vaultId(String vaultId) {
            this.vaultId = vaultId;
            this.__explicitlySet__.add("vaultId");
            return this;
        }

        public Builder restoredFromKeyVersionId(String restoredFromKeyVersionId) {
            this.restoredFromKeyVersionId = restoredFromKeyVersionId;
            this.__explicitlySet__.add("restoredFromKeyVersionId");
            return this;
        }

        public Builder replicaDetails(KeyVersionReplicaDetails replicaDetails) {
            this.replicaDetails = replicaDetails;
            this.__explicitlySet__.add("replicaDetails");
            return this;
        }

        public Builder isPrimary(Boolean isPrimary) {
            this.isPrimary = isPrimary;
            this.__explicitlySet__.add("isPrimary");
            return this;
        }

        public Builder externalKeyReferenceDetails(ExternalKeyReferenceDetails externalKeyReferenceDetails) {
            this.externalKeyReferenceDetails = externalKeyReferenceDetails;
            this.__explicitlySet__.add("externalKeyReferenceDetails");
            return this;
        }

        public Builder isAutoRotated(Boolean isAutoRotated) {
            this.isAutoRotated = isAutoRotated;
            this.__explicitlySet__.add("isAutoRotated");
            return this;
        }

        public KeyVersion build() {
            KeyVersion model = new KeyVersion(this.compartmentId, this.id, this.keyId, this.publicKey, this.lifecycleState, this.origin, this.timeCreated, this.timeOfDeletion, this.vaultId, this.restoredFromKeyVersionId, this.replicaDetails, this.isPrimary, this.externalKeyReferenceDetails, this.isAutoRotated);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(KeyVersion model) {
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("keyId")) {
                this.keyId(model.getKeyId());
            }
            if (model.wasPropertyExplicitlySet("publicKey")) {
                this.publicKey(model.getPublicKey());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("origin")) {
                this.origin(model.getOrigin());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("timeOfDeletion")) {
                this.timeOfDeletion(model.getTimeOfDeletion());
            }
            if (model.wasPropertyExplicitlySet("vaultId")) {
                this.vaultId(model.getVaultId());
            }
            if (model.wasPropertyExplicitlySet("restoredFromKeyVersionId")) {
                this.restoredFromKeyVersionId(model.getRestoredFromKeyVersionId());
            }
            if (model.wasPropertyExplicitlySet("replicaDetails")) {
                this.replicaDetails(model.getReplicaDetails());
            }
            if (model.wasPropertyExplicitlySet("isPrimary")) {
                this.isPrimary(model.getIsPrimary());
            }
            if (model.wasPropertyExplicitlySet("externalKeyReferenceDetails")) {
                this.externalKeyReferenceDetails(model.getExternalKeyReferenceDetails());
            }
            if (model.wasPropertyExplicitlySet("isAutoRotated")) {
                this.isAutoRotated(model.getIsAutoRotated());
            }
            return this;
        }
    }
}

