/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.licensemanager;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.licensemanager.LicenseManagerAsync;
import com.oracle.bmc.licensemanager.model.BulkUploadResponse;
import com.oracle.bmc.licensemanager.model.BulkUploadTemplate;
import com.oracle.bmc.licensemanager.model.Configuration;
import com.oracle.bmc.licensemanager.model.LicenseMetric;
import com.oracle.bmc.licensemanager.model.LicenseRecord;
import com.oracle.bmc.licensemanager.model.LicenseRecordCollection;
import com.oracle.bmc.licensemanager.model.ProductLicense;
import com.oracle.bmc.licensemanager.model.ProductLicenseCollection;
import com.oracle.bmc.licensemanager.model.ProductLicenseConsumerCollection;
import com.oracle.bmc.licensemanager.model.TopUtilizedProductLicenseCollection;
import com.oracle.bmc.licensemanager.model.TopUtilizedResourceCollection;
import com.oracle.bmc.licensemanager.requests.BulkUploadLicenseRecordsRequest;
import com.oracle.bmc.licensemanager.requests.CreateLicenseRecordRequest;
import com.oracle.bmc.licensemanager.requests.CreateProductLicenseRequest;
import com.oracle.bmc.licensemanager.requests.DeleteLicenseRecordRequest;
import com.oracle.bmc.licensemanager.requests.DeleteProductLicenseRequest;
import com.oracle.bmc.licensemanager.requests.GetBulkUploadTemplateRequest;
import com.oracle.bmc.licensemanager.requests.GetConfigurationRequest;
import com.oracle.bmc.licensemanager.requests.GetLicenseMetricRequest;
import com.oracle.bmc.licensemanager.requests.GetLicenseRecordRequest;
import com.oracle.bmc.licensemanager.requests.GetProductLicenseRequest;
import com.oracle.bmc.licensemanager.requests.ListLicenseRecordsRequest;
import com.oracle.bmc.licensemanager.requests.ListProductLicenseConsumersRequest;
import com.oracle.bmc.licensemanager.requests.ListProductLicensesRequest;
import com.oracle.bmc.licensemanager.requests.ListTopUtilizedProductLicensesRequest;
import com.oracle.bmc.licensemanager.requests.ListTopUtilizedResourcesRequest;
import com.oracle.bmc.licensemanager.requests.UpdateConfigurationRequest;
import com.oracle.bmc.licensemanager.requests.UpdateLicenseRecordRequest;
import com.oracle.bmc.licensemanager.requests.UpdateProductLicenseRequest;
import com.oracle.bmc.licensemanager.responses.BulkUploadLicenseRecordsResponse;
import com.oracle.bmc.licensemanager.responses.CreateLicenseRecordResponse;
import com.oracle.bmc.licensemanager.responses.CreateProductLicenseResponse;
import com.oracle.bmc.licensemanager.responses.DeleteLicenseRecordResponse;
import com.oracle.bmc.licensemanager.responses.DeleteProductLicenseResponse;
import com.oracle.bmc.licensemanager.responses.GetBulkUploadTemplateResponse;
import com.oracle.bmc.licensemanager.responses.GetConfigurationResponse;
import com.oracle.bmc.licensemanager.responses.GetLicenseMetricResponse;
import com.oracle.bmc.licensemanager.responses.GetLicenseRecordResponse;
import com.oracle.bmc.licensemanager.responses.GetProductLicenseResponse;
import com.oracle.bmc.licensemanager.responses.ListLicenseRecordsResponse;
import com.oracle.bmc.licensemanager.responses.ListProductLicenseConsumersResponse;
import com.oracle.bmc.licensemanager.responses.ListProductLicensesResponse;
import com.oracle.bmc.licensemanager.responses.ListTopUtilizedProductLicensesResponse;
import com.oracle.bmc.licensemanager.responses.ListTopUtilizedResourcesResponse;
import com.oracle.bmc.licensemanager.responses.UpdateConfigurationResponse;
import com.oracle.bmc.licensemanager.responses.UpdateLicenseRecordResponse;
import com.oracle.bmc.licensemanager.responses.UpdateProductLicenseResponse;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LicenseManagerAsyncClient
extends BaseAsyncClient
implements LicenseManagerAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("LICENSEMANAGER").serviceEndpointPrefix("").serviceEndpointTemplate("https://licensemanager.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(LicenseManagerAsyncClient.class);

    LicenseManagerAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<BulkUploadLicenseRecordsResponse> bulkUploadLicenseRecords(BulkUploadLicenseRecordsRequest request, AsyncHandler<BulkUploadLicenseRecordsRequest, BulkUploadLicenseRecordsResponse> handler) {
        Objects.requireNonNull(request.getBulkUploadLicenseRecordsDetails(), "bulkUploadLicenseRecordsDetails is required");
        return this.clientCall(request, BulkUploadLicenseRecordsResponse::builder).logger(LOG, "bulkUploadLicenseRecords").serviceDetails("LicenseManager", "BulkUploadLicenseRecords", "https://docs.oracle.com/iaas/api/#/en/licensemanager/20220430/BulkUploadLicenseRecordsDetails/BulkUploadLicenseRecords").method(Method.POST).requestBuilder(BulkUploadLicenseRecordsRequest::builder).basePath("/20220430").appendPathParam("licenses").appendPathParam("actions").appendPathParam("bulkUpload").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(BulkUploadResponse.class, BulkUploadLicenseRecordsResponse.Builder::bulkUploadResponse).handleResponseHeaderString("opc-request-id", BulkUploadLicenseRecordsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateLicenseRecordResponse> createLicenseRecord(CreateLicenseRecordRequest request, AsyncHandler<CreateLicenseRecordRequest, CreateLicenseRecordResponse> handler) {
        Objects.requireNonNull(request.getCreateLicenseRecordDetails(), "createLicenseRecordDetails is required");
        Objects.requireNonNull(request.getProductLicenseId(), "productLicenseId is required");
        return this.clientCall(request, CreateLicenseRecordResponse::builder).logger(LOG, "createLicenseRecord").serviceDetails("LicenseManager", "CreateLicenseRecord", "https://docs.oracle.com/iaas/api/#/en/licensemanager/20220430/LicenseRecord/CreateLicenseRecord").method(Method.POST).requestBuilder(CreateLicenseRecordRequest::builder).basePath("/20220430").appendPathParam("licenseRecords").appendQueryParam("productLicenseId", (Object)request.getProductLicenseId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(LicenseRecord.class, CreateLicenseRecordResponse.Builder::licenseRecord).handleResponseHeaderString("etag", CreateLicenseRecordResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", CreateLicenseRecordResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateLicenseRecordResponse.Builder::opcRequestId).handleResponseHeaderString("location", CreateLicenseRecordResponse.Builder::location).callAsync(handler);
    }

    @Override
    public Future<CreateProductLicenseResponse> createProductLicense(CreateProductLicenseRequest request, AsyncHandler<CreateProductLicenseRequest, CreateProductLicenseResponse> handler) {
        Objects.requireNonNull(request.getCreateProductLicenseDetails(), "createProductLicenseDetails is required");
        return this.clientCall(request, CreateProductLicenseResponse::builder).logger(LOG, "createProductLicense").serviceDetails("LicenseManager", "CreateProductLicense", "https://docs.oracle.com/iaas/api/#/en/licensemanager/20220430/ProductLicense/CreateProductLicense").method(Method.POST).requestBuilder(CreateProductLicenseRequest::builder).basePath("/20220430").appendPathParam("productLicenses").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(ProductLicense.class, CreateProductLicenseResponse.Builder::productLicense).handleResponseHeaderString("etag", CreateProductLicenseResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", CreateProductLicenseResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateProductLicenseResponse.Builder::opcRequestId).handleResponseHeaderString("location", CreateProductLicenseResponse.Builder::location).callAsync(handler);
    }

    @Override
    public Future<DeleteLicenseRecordResponse> deleteLicenseRecord(DeleteLicenseRecordRequest request, AsyncHandler<DeleteLicenseRecordRequest, DeleteLicenseRecordResponse> handler) {
        Validate.notBlank((String)request.getLicenseRecordId(), (String)"licenseRecordId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteLicenseRecordResponse::builder).logger(LOG, "deleteLicenseRecord").serviceDetails("LicenseManager", "DeleteLicenseRecord", "https://docs.oracle.com/iaas/api/#/en/licensemanager/20220430/LicenseRecord/DeleteLicenseRecord").method(Method.DELETE).requestBuilder(DeleteLicenseRecordRequest::builder).basePath("/20220430").appendPathParam("licenseRecords").appendPathParam(request.getLicenseRecordId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-work-request-id", DeleteLicenseRecordResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteLicenseRecordResponse.Builder::opcRequestId).handleResponseHeaderString("location", DeleteLicenseRecordResponse.Builder::location).callAsync(handler);
    }

    @Override
    public Future<DeleteProductLicenseResponse> deleteProductLicense(DeleteProductLicenseRequest request, AsyncHandler<DeleteProductLicenseRequest, DeleteProductLicenseResponse> handler) {
        Validate.notBlank((String)request.getProductLicenseId(), (String)"productLicenseId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteProductLicenseResponse::builder).logger(LOG, "deleteProductLicense").serviceDetails("LicenseManager", "DeleteProductLicense", "https://docs.oracle.com/iaas/api/#/en/licensemanager/20220430/ProductLicense/DeleteProductLicense").method(Method.DELETE).requestBuilder(DeleteProductLicenseRequest::builder).basePath("/20220430").appendPathParam("productLicenses").appendPathParam(request.getProductLicenseId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-work-request-id", DeleteProductLicenseResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteProductLicenseResponse.Builder::opcRequestId).handleResponseHeaderString("location", DeleteProductLicenseResponse.Builder::location).callAsync(handler);
    }

    @Override
    public Future<GetBulkUploadTemplateResponse> getBulkUploadTemplate(GetBulkUploadTemplateRequest request, AsyncHandler<GetBulkUploadTemplateRequest, GetBulkUploadTemplateResponse> handler) {
        return this.clientCall(request, GetBulkUploadTemplateResponse::builder).logger(LOG, "getBulkUploadTemplate").serviceDetails("LicenseManager", "GetBulkUploadTemplate", "https://docs.oracle.com/iaas/api/#/en/licensemanager/20220430/BulkUploadTemplate/GetBulkUploadTemplate").method(Method.GET).requestBuilder(GetBulkUploadTemplateRequest::builder).basePath("/20220430").appendPathParam("licenses").appendPathParam("actions").appendPathParam("bulkUploadTemplate").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(BulkUploadTemplate.class, GetBulkUploadTemplateResponse.Builder::bulkUploadTemplate).handleResponseHeaderString("opc-request-id", GetBulkUploadTemplateResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", GetBulkUploadTemplateResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<GetConfigurationResponse> getConfiguration(GetConfigurationRequest request, AsyncHandler<GetConfigurationRequest, GetConfigurationResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, GetConfigurationResponse::builder).logger(LOG, "getConfiguration").serviceDetails("LicenseManager", "GetConfiguration", "https://docs.oracle.com/iaas/api/#/en/licensemanager/20220430/Configuration/GetConfiguration").method(Method.GET).requestBuilder(GetConfigurationRequest::builder).basePath("/20220430").appendPathParam("configuration").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Configuration.class, GetConfigurationResponse.Builder::configuration).handleResponseHeaderString("etag", GetConfigurationResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetConfigurationResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetLicenseMetricResponse> getLicenseMetric(GetLicenseMetricRequest request, AsyncHandler<GetLicenseMetricRequest, GetLicenseMetricResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, GetLicenseMetricResponse::builder).logger(LOG, "getLicenseMetric").serviceDetails("LicenseManager", "GetLicenseMetric", "https://docs.oracle.com/iaas/api/#/en/licensemanager/20220430/LicenseMetric/GetLicenseMetric").method(Method.GET).requestBuilder(GetLicenseMetricRequest::builder).basePath("/20220430").appendPathParam("licenseMetrics").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("isCompartmentIdInSubtree", (Object)request.getIsCompartmentIdInSubtree()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(LicenseMetric.class, GetLicenseMetricResponse.Builder::licenseMetric).handleResponseHeaderString("etag", GetLicenseMetricResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetLicenseMetricResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetLicenseRecordResponse> getLicenseRecord(GetLicenseRecordRequest request, AsyncHandler<GetLicenseRecordRequest, GetLicenseRecordResponse> handler) {
        Validate.notBlank((String)request.getLicenseRecordId(), (String)"licenseRecordId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetLicenseRecordResponse::builder).logger(LOG, "getLicenseRecord").serviceDetails("LicenseManager", "GetLicenseRecord", "https://docs.oracle.com/iaas/api/#/en/licensemanager/20220430/LicenseRecord/GetLicenseRecord").method(Method.GET).requestBuilder(GetLicenseRecordRequest::builder).basePath("/20220430").appendPathParam("licenseRecords").appendPathParam(request.getLicenseRecordId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(LicenseRecord.class, GetLicenseRecordResponse.Builder::licenseRecord).handleResponseHeaderString("etag", GetLicenseRecordResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetLicenseRecordResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetProductLicenseResponse> getProductLicense(GetProductLicenseRequest request, AsyncHandler<GetProductLicenseRequest, GetProductLicenseResponse> handler) {
        Validate.notBlank((String)request.getProductLicenseId(), (String)"productLicenseId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetProductLicenseResponse::builder).logger(LOG, "getProductLicense").serviceDetails("LicenseManager", "GetProductLicense", "https://docs.oracle.com/iaas/api/#/en/licensemanager/20220430/ProductLicense/GetProductLicense").method(Method.GET).requestBuilder(GetProductLicenseRequest::builder).basePath("/20220430").appendPathParam("productLicenses").appendPathParam(request.getProductLicenseId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ProductLicense.class, GetProductLicenseResponse.Builder::productLicense).handleResponseHeaderString("etag", GetProductLicenseResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetProductLicenseResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListLicenseRecordsResponse> listLicenseRecords(ListLicenseRecordsRequest request, AsyncHandler<ListLicenseRecordsRequest, ListLicenseRecordsResponse> handler) {
        Objects.requireNonNull(request.getProductLicenseId(), "productLicenseId is required");
        return this.clientCall(request, ListLicenseRecordsResponse::builder).logger(LOG, "listLicenseRecords").serviceDetails("LicenseManager", "ListLicenseRecords", "https://docs.oracle.com/iaas/api/#/en/licensemanager/20220430/LicenseRecordCollection/ListLicenseRecords").method(Method.GET).requestBuilder(ListLicenseRecordsRequest::builder).basePath("/20220430").appendPathParam("licenseRecords").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("productLicenseId", (Object)request.getProductLicenseId()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(LicenseRecordCollection.class, ListLicenseRecordsResponse.Builder::licenseRecordCollection).handleResponseHeaderString("opc-request-id", ListLicenseRecordsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListLicenseRecordsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListProductLicenseConsumersResponse> listProductLicenseConsumers(ListProductLicenseConsumersRequest request, AsyncHandler<ListProductLicenseConsumersRequest, ListProductLicenseConsumersResponse> handler) {
        Objects.requireNonNull(request.getProductLicenseId(), "productLicenseId is required");
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListProductLicenseConsumersResponse::builder).logger(LOG, "listProductLicenseConsumers").serviceDetails("LicenseManager", "ListProductLicenseConsumers", "https://docs.oracle.com/iaas/api/#/en/licensemanager/20220430/ProductLicenseConsumerCollection/ListProductLicenseConsumers").method(Method.GET).requestBuilder(ListProductLicenseConsumersRequest::builder).basePath("/20220430").appendPathParam("productLicenseConsumers").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("productLicenseId", (Object)request.getProductLicenseId()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("isCompartmentIdInSubtree", (Object)request.getIsCompartmentIdInSubtree()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ProductLicenseConsumerCollection.class, ListProductLicenseConsumersResponse.Builder::productLicenseConsumerCollection).handleResponseHeaderString("opc-request-id", ListProductLicenseConsumersResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListProductLicenseConsumersResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListProductLicensesResponse> listProductLicenses(ListProductLicensesRequest request, AsyncHandler<ListProductLicensesRequest, ListProductLicensesResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListProductLicensesResponse::builder).logger(LOG, "listProductLicenses").serviceDetails("LicenseManager", "ListProductLicenses", "https://docs.oracle.com/iaas/api/#/en/licensemanager/20220430/ProductLicenseCollection/ListProductLicenses").method(Method.GET).requestBuilder(ListProductLicensesRequest::builder).basePath("/20220430").appendPathParam("productLicenses").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("isCompartmentIdInSubtree", (Object)request.getIsCompartmentIdInSubtree()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ProductLicenseCollection.class, ListProductLicensesResponse.Builder::productLicenseCollection).handleResponseHeaderString("opc-request-id", ListProductLicensesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListProductLicensesResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListTopUtilizedProductLicensesResponse> listTopUtilizedProductLicenses(ListTopUtilizedProductLicensesRequest request, AsyncHandler<ListTopUtilizedProductLicensesRequest, ListTopUtilizedProductLicensesResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListTopUtilizedProductLicensesResponse::builder).logger(LOG, "listTopUtilizedProductLicenses").serviceDetails("LicenseManager", "ListTopUtilizedProductLicenses", "https://docs.oracle.com/iaas/api/#/en/licensemanager/20220430/TopUtilizedProductLicenseCollection/ListTopUtilizedProductLicenses").method(Method.GET).requestBuilder(ListTopUtilizedProductLicensesRequest::builder).basePath("/20220430").appendPathParam("topUtilizedProductLicenses").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("isCompartmentIdInSubtree", (Object)request.getIsCompartmentIdInSubtree()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(TopUtilizedProductLicenseCollection.class, ListTopUtilizedProductLicensesResponse.Builder::topUtilizedProductLicenseCollection).handleResponseHeaderString("opc-request-id", ListTopUtilizedProductLicensesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListTopUtilizedProductLicensesResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListTopUtilizedResourcesResponse> listTopUtilizedResources(ListTopUtilizedResourcesRequest request, AsyncHandler<ListTopUtilizedResourcesRequest, ListTopUtilizedResourcesResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListTopUtilizedResourcesResponse::builder).logger(LOG, "listTopUtilizedResources").serviceDetails("LicenseManager", "ListTopUtilizedResources", "https://docs.oracle.com/iaas/api/#/en/licensemanager/20220430/TopUtilizedResourceCollection/ListTopUtilizedResources").method(Method.GET).requestBuilder(ListTopUtilizedResourcesRequest::builder).basePath("/20220430").appendPathParam("topUtilizedResources").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("isCompartmentIdInSubtree", (Object)request.getIsCompartmentIdInSubtree()).appendEnumQueryParam("resourceUnitType", (BmcEnum)request.getResourceUnitType()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(TopUtilizedResourceCollection.class, ListTopUtilizedResourcesResponse.Builder::topUtilizedResourceCollection).handleResponseHeaderString("opc-request-id", ListTopUtilizedResourcesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListTopUtilizedResourcesResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<UpdateConfigurationResponse> updateConfiguration(UpdateConfigurationRequest request, AsyncHandler<UpdateConfigurationRequest, UpdateConfigurationResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        Objects.requireNonNull(request.getUpdateConfigurationDetails(), "updateConfigurationDetails is required");
        return this.clientCall(request, UpdateConfigurationResponse::builder).logger(LOG, "updateConfiguration").serviceDetails("LicenseManager", "UpdateConfiguration", "https://docs.oracle.com/iaas/api/#/en/licensemanager/20220430/Configuration/UpdateConfiguration").method(Method.PUT).requestBuilder(UpdateConfigurationRequest::builder).basePath("/20220430").appendPathParam("configuration").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Configuration.class, UpdateConfigurationResponse.Builder::configuration).handleResponseHeaderString("etag", UpdateConfigurationResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateConfigurationResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateLicenseRecordResponse> updateLicenseRecord(UpdateLicenseRecordRequest request, AsyncHandler<UpdateLicenseRecordRequest, UpdateLicenseRecordResponse> handler) {
        Validate.notBlank((String)request.getLicenseRecordId(), (String)"licenseRecordId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateLicenseRecordDetails(), "updateLicenseRecordDetails is required");
        return this.clientCall(request, UpdateLicenseRecordResponse::builder).logger(LOG, "updateLicenseRecord").serviceDetails("LicenseManager", "UpdateLicenseRecord", "https://docs.oracle.com/iaas/api/#/en/licensemanager/20220430/LicenseRecord/UpdateLicenseRecord").method(Method.PUT).requestBuilder(UpdateLicenseRecordRequest::builder).basePath("/20220430").appendPathParam("licenseRecords").appendPathParam(request.getLicenseRecordId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(LicenseRecord.class, UpdateLicenseRecordResponse.Builder::licenseRecord).handleResponseHeaderString("etag", UpdateLicenseRecordResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateLicenseRecordResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateProductLicenseResponse> updateProductLicense(UpdateProductLicenseRequest request, AsyncHandler<UpdateProductLicenseRequest, UpdateProductLicenseResponse> handler) {
        Validate.notBlank((String)request.getProductLicenseId(), (String)"productLicenseId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateProductLicenseDetails(), "updateProductLicenseDetails is required");
        return this.clientCall(request, UpdateProductLicenseResponse::builder).logger(LOG, "updateProductLicense").serviceDetails("LicenseManager", "UpdateProductLicense", "https://docs.oracle.com/iaas/api/#/en/licensemanager/20220430/ProductLicense/UpdateProductLicense").method(Method.PUT).requestBuilder(UpdateProductLicenseRequest::builder).basePath("/20220430").appendPathParam("productLicenses").appendPathParam(request.getProductLicenseId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(ProductLicense.class, UpdateProductLicenseResponse.Builder::productLicense).handleResponseHeaderString("etag", UpdateProductLicenseResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateProductLicenseResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Deprecated
    public LicenseManagerAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)LicenseManagerAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public LicenseManagerAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(LicenseManagerAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public LicenseManagerAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)LicenseManagerAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public LicenseManagerAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)LicenseManagerAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public LicenseManagerAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)LicenseManagerAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public LicenseManagerAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)LicenseManagerAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public LicenseManagerAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)LicenseManagerAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, LicenseManagerAsyncClient> {
        private Builder(Service service) {
            super(service);
            String packageName = "licensemanager";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"licensemanager");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public LicenseManagerAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new LicenseManagerAsyncClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider);
        }
    }
}

