/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.licensemanager;

import com.oracle.bmc.licensemanager.LicenseManager;
import com.oracle.bmc.licensemanager.model.LicenseRecordSummary;
import com.oracle.bmc.licensemanager.model.ProductLicenseConsumerSummary;
import com.oracle.bmc.licensemanager.model.ProductLicenseSummary;
import com.oracle.bmc.licensemanager.model.TopUtilizedProductLicenseSummary;
import com.oracle.bmc.licensemanager.model.TopUtilizedResourceSummary;
import com.oracle.bmc.licensemanager.requests.ListLicenseRecordsRequest;
import com.oracle.bmc.licensemanager.requests.ListProductLicenseConsumersRequest;
import com.oracle.bmc.licensemanager.requests.ListProductLicensesRequest;
import com.oracle.bmc.licensemanager.requests.ListTopUtilizedProductLicensesRequest;
import com.oracle.bmc.licensemanager.requests.ListTopUtilizedResourcesRequest;
import com.oracle.bmc.licensemanager.responses.ListLicenseRecordsResponse;
import com.oracle.bmc.licensemanager.responses.ListProductLicenseConsumersResponse;
import com.oracle.bmc.licensemanager.responses.ListProductLicensesResponse;
import com.oracle.bmc.licensemanager.responses.ListTopUtilizedProductLicensesResponse;
import com.oracle.bmc.licensemanager.responses.ListTopUtilizedResourcesResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class LicenseManagerPaginators {
    private final LicenseManager client;

    public LicenseManagerPaginators(LicenseManager client) {
        this.client = client;
    }

    public Iterable<ListLicenseRecordsResponse> listLicenseRecordsResponseIterator(final ListLicenseRecordsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListLicenseRecordsRequest.Builder>(){

            @Override
            public ListLicenseRecordsRequest.Builder get() {
                return ListLicenseRecordsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListLicenseRecordsResponse, String>(){

            @Override
            public String apply(ListLicenseRecordsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListLicenseRecordsRequest.Builder>, ListLicenseRecordsRequest>(){

            @Override
            public ListLicenseRecordsRequest apply(RequestBuilderAndToken<ListLicenseRecordsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListLicenseRecordsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListLicenseRecordsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListLicenseRecordsRequest, ListLicenseRecordsResponse>(){

            @Override
            public ListLicenseRecordsResponse apply(ListLicenseRecordsRequest request) {
                return LicenseManagerPaginators.this.client.listLicenseRecords(request);
            }
        });
    }

    public Iterable<LicenseRecordSummary> listLicenseRecordsRecordIterator(final ListLicenseRecordsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListLicenseRecordsRequest.Builder>(){

            @Override
            public ListLicenseRecordsRequest.Builder get() {
                return ListLicenseRecordsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListLicenseRecordsResponse, String>(){

            @Override
            public String apply(ListLicenseRecordsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListLicenseRecordsRequest.Builder>, ListLicenseRecordsRequest>(){

            @Override
            public ListLicenseRecordsRequest apply(RequestBuilderAndToken<ListLicenseRecordsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListLicenseRecordsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListLicenseRecordsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListLicenseRecordsRequest, ListLicenseRecordsResponse>(){

            @Override
            public ListLicenseRecordsResponse apply(ListLicenseRecordsRequest request) {
                return LicenseManagerPaginators.this.client.listLicenseRecords(request);
            }
        }, (Function)new Function<ListLicenseRecordsResponse, List<LicenseRecordSummary>>(){

            @Override
            public List<LicenseRecordSummary> apply(ListLicenseRecordsResponse response) {
                return response.getLicenseRecordCollection().getItems();
            }
        });
    }

    public Iterable<ListProductLicenseConsumersResponse> listProductLicenseConsumersResponseIterator(final ListProductLicenseConsumersRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListProductLicenseConsumersRequest.Builder>(){

            @Override
            public ListProductLicenseConsumersRequest.Builder get() {
                return ListProductLicenseConsumersRequest.builder().copy(request);
            }
        }, (Function)new Function<ListProductLicenseConsumersResponse, String>(){

            @Override
            public String apply(ListProductLicenseConsumersResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListProductLicenseConsumersRequest.Builder>, ListProductLicenseConsumersRequest>(){

            @Override
            public ListProductLicenseConsumersRequest apply(RequestBuilderAndToken<ListProductLicenseConsumersRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListProductLicenseConsumersRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListProductLicenseConsumersRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListProductLicenseConsumersRequest, ListProductLicenseConsumersResponse>(){

            @Override
            public ListProductLicenseConsumersResponse apply(ListProductLicenseConsumersRequest request) {
                return LicenseManagerPaginators.this.client.listProductLicenseConsumers(request);
            }
        });
    }

    public Iterable<ProductLicenseConsumerSummary> listProductLicenseConsumersRecordIterator(final ListProductLicenseConsumersRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListProductLicenseConsumersRequest.Builder>(){

            @Override
            public ListProductLicenseConsumersRequest.Builder get() {
                return ListProductLicenseConsumersRequest.builder().copy(request);
            }
        }, (Function)new Function<ListProductLicenseConsumersResponse, String>(){

            @Override
            public String apply(ListProductLicenseConsumersResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListProductLicenseConsumersRequest.Builder>, ListProductLicenseConsumersRequest>(){

            @Override
            public ListProductLicenseConsumersRequest apply(RequestBuilderAndToken<ListProductLicenseConsumersRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListProductLicenseConsumersRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListProductLicenseConsumersRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListProductLicenseConsumersRequest, ListProductLicenseConsumersResponse>(){

            @Override
            public ListProductLicenseConsumersResponse apply(ListProductLicenseConsumersRequest request) {
                return LicenseManagerPaginators.this.client.listProductLicenseConsumers(request);
            }
        }, (Function)new Function<ListProductLicenseConsumersResponse, List<ProductLicenseConsumerSummary>>(){

            @Override
            public List<ProductLicenseConsumerSummary> apply(ListProductLicenseConsumersResponse response) {
                return response.getProductLicenseConsumerCollection().getItems();
            }
        });
    }

    public Iterable<ListProductLicensesResponse> listProductLicensesResponseIterator(final ListProductLicensesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListProductLicensesRequest.Builder>(){

            @Override
            public ListProductLicensesRequest.Builder get() {
                return ListProductLicensesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListProductLicensesResponse, String>(){

            @Override
            public String apply(ListProductLicensesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListProductLicensesRequest.Builder>, ListProductLicensesRequest>(){

            @Override
            public ListProductLicensesRequest apply(RequestBuilderAndToken<ListProductLicensesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListProductLicensesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListProductLicensesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListProductLicensesRequest, ListProductLicensesResponse>(){

            @Override
            public ListProductLicensesResponse apply(ListProductLicensesRequest request) {
                return LicenseManagerPaginators.this.client.listProductLicenses(request);
            }
        });
    }

    public Iterable<ProductLicenseSummary> listProductLicensesRecordIterator(final ListProductLicensesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListProductLicensesRequest.Builder>(){

            @Override
            public ListProductLicensesRequest.Builder get() {
                return ListProductLicensesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListProductLicensesResponse, String>(){

            @Override
            public String apply(ListProductLicensesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListProductLicensesRequest.Builder>, ListProductLicensesRequest>(){

            @Override
            public ListProductLicensesRequest apply(RequestBuilderAndToken<ListProductLicensesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListProductLicensesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListProductLicensesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListProductLicensesRequest, ListProductLicensesResponse>(){

            @Override
            public ListProductLicensesResponse apply(ListProductLicensesRequest request) {
                return LicenseManagerPaginators.this.client.listProductLicenses(request);
            }
        }, (Function)new Function<ListProductLicensesResponse, List<ProductLicenseSummary>>(){

            @Override
            public List<ProductLicenseSummary> apply(ListProductLicensesResponse response) {
                return response.getProductLicenseCollection().getItems();
            }
        });
    }

    public Iterable<ListTopUtilizedProductLicensesResponse> listTopUtilizedProductLicensesResponseIterator(final ListTopUtilizedProductLicensesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListTopUtilizedProductLicensesRequest.Builder>(){

            @Override
            public ListTopUtilizedProductLicensesRequest.Builder get() {
                return ListTopUtilizedProductLicensesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListTopUtilizedProductLicensesResponse, String>(){

            @Override
            public String apply(ListTopUtilizedProductLicensesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListTopUtilizedProductLicensesRequest.Builder>, ListTopUtilizedProductLicensesRequest>(){

            @Override
            public ListTopUtilizedProductLicensesRequest apply(RequestBuilderAndToken<ListTopUtilizedProductLicensesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListTopUtilizedProductLicensesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListTopUtilizedProductLicensesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListTopUtilizedProductLicensesRequest, ListTopUtilizedProductLicensesResponse>(){

            @Override
            public ListTopUtilizedProductLicensesResponse apply(ListTopUtilizedProductLicensesRequest request) {
                return LicenseManagerPaginators.this.client.listTopUtilizedProductLicenses(request);
            }
        });
    }

    public Iterable<TopUtilizedProductLicenseSummary> listTopUtilizedProductLicensesRecordIterator(final ListTopUtilizedProductLicensesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListTopUtilizedProductLicensesRequest.Builder>(){

            @Override
            public ListTopUtilizedProductLicensesRequest.Builder get() {
                return ListTopUtilizedProductLicensesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListTopUtilizedProductLicensesResponse, String>(){

            @Override
            public String apply(ListTopUtilizedProductLicensesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListTopUtilizedProductLicensesRequest.Builder>, ListTopUtilizedProductLicensesRequest>(){

            @Override
            public ListTopUtilizedProductLicensesRequest apply(RequestBuilderAndToken<ListTopUtilizedProductLicensesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListTopUtilizedProductLicensesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListTopUtilizedProductLicensesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListTopUtilizedProductLicensesRequest, ListTopUtilizedProductLicensesResponse>(){

            @Override
            public ListTopUtilizedProductLicensesResponse apply(ListTopUtilizedProductLicensesRequest request) {
                return LicenseManagerPaginators.this.client.listTopUtilizedProductLicenses(request);
            }
        }, (Function)new Function<ListTopUtilizedProductLicensesResponse, List<TopUtilizedProductLicenseSummary>>(){

            @Override
            public List<TopUtilizedProductLicenseSummary> apply(ListTopUtilizedProductLicensesResponse response) {
                return response.getTopUtilizedProductLicenseCollection().getItems();
            }
        });
    }

    public Iterable<ListTopUtilizedResourcesResponse> listTopUtilizedResourcesResponseIterator(final ListTopUtilizedResourcesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListTopUtilizedResourcesRequest.Builder>(){

            @Override
            public ListTopUtilizedResourcesRequest.Builder get() {
                return ListTopUtilizedResourcesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListTopUtilizedResourcesResponse, String>(){

            @Override
            public String apply(ListTopUtilizedResourcesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListTopUtilizedResourcesRequest.Builder>, ListTopUtilizedResourcesRequest>(){

            @Override
            public ListTopUtilizedResourcesRequest apply(RequestBuilderAndToken<ListTopUtilizedResourcesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListTopUtilizedResourcesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListTopUtilizedResourcesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListTopUtilizedResourcesRequest, ListTopUtilizedResourcesResponse>(){

            @Override
            public ListTopUtilizedResourcesResponse apply(ListTopUtilizedResourcesRequest request) {
                return LicenseManagerPaginators.this.client.listTopUtilizedResources(request);
            }
        });
    }

    public Iterable<TopUtilizedResourceSummary> listTopUtilizedResourcesRecordIterator(final ListTopUtilizedResourcesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListTopUtilizedResourcesRequest.Builder>(){

            @Override
            public ListTopUtilizedResourcesRequest.Builder get() {
                return ListTopUtilizedResourcesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListTopUtilizedResourcesResponse, String>(){

            @Override
            public String apply(ListTopUtilizedResourcesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListTopUtilizedResourcesRequest.Builder>, ListTopUtilizedResourcesRequest>(){

            @Override
            public ListTopUtilizedResourcesRequest apply(RequestBuilderAndToken<ListTopUtilizedResourcesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListTopUtilizedResourcesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListTopUtilizedResourcesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListTopUtilizedResourcesRequest, ListTopUtilizedResourcesResponse>(){

            @Override
            public ListTopUtilizedResourcesResponse apply(ListTopUtilizedResourcesRequest request) {
                return LicenseManagerPaginators.this.client.listTopUtilizedResources(request);
            }
        }, (Function)new Function<ListTopUtilizedResourcesResponse, List<TopUtilizedResourceSummary>>(){

            @Override
            public List<TopUtilizedResourceSummary> apply(ListTopUtilizedResourcesResponse response) {
                return response.getTopUtilizedResourceCollection().getItems();
            }
        });
    }
}

