/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.licensemanager.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class LicenseMetric
extends ExplicitlySetBmcModel {
    @JsonProperty(value="totalProductLicenseCount")
    private final Integer totalProductLicenseCount;
    @JsonProperty(value="totalByolInstanceCount")
    private final Integer totalByolInstanceCount;
    @JsonProperty(value="totalLicenseIncludedInstanceCount")
    private final Integer totalLicenseIncludedInstanceCount;
    @JsonProperty(value="licenseRecordExpiringSoonCount")
    private final Integer licenseRecordExpiringSoonCount;

    @Deprecated
    @ConstructorProperties(value={"totalProductLicenseCount", "totalByolInstanceCount", "totalLicenseIncludedInstanceCount", "licenseRecordExpiringSoonCount"})
    public LicenseMetric(Integer totalProductLicenseCount, Integer totalByolInstanceCount, Integer totalLicenseIncludedInstanceCount, Integer licenseRecordExpiringSoonCount) {
        this.totalProductLicenseCount = totalProductLicenseCount;
        this.totalByolInstanceCount = totalByolInstanceCount;
        this.totalLicenseIncludedInstanceCount = totalLicenseIncludedInstanceCount;
        this.licenseRecordExpiringSoonCount = licenseRecordExpiringSoonCount;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Integer getTotalProductLicenseCount() {
        return this.totalProductLicenseCount;
    }

    public Integer getTotalByolInstanceCount() {
        return this.totalByolInstanceCount;
    }

    public Integer getTotalLicenseIncludedInstanceCount() {
        return this.totalLicenseIncludedInstanceCount;
    }

    public Integer getLicenseRecordExpiringSoonCount() {
        return this.licenseRecordExpiringSoonCount;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("LicenseMetric(");
        sb.append("super=").append(super.toString());
        sb.append("totalProductLicenseCount=").append(String.valueOf(this.totalProductLicenseCount));
        sb.append(", totalByolInstanceCount=").append(String.valueOf(this.totalByolInstanceCount));
        sb.append(", totalLicenseIncludedInstanceCount=").append(String.valueOf(this.totalLicenseIncludedInstanceCount));
        sb.append(", licenseRecordExpiringSoonCount=").append(String.valueOf(this.licenseRecordExpiringSoonCount));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LicenseMetric)) {
            return false;
        }
        LicenseMetric other = (LicenseMetric)((Object)o);
        return Objects.equals(this.totalProductLicenseCount, other.totalProductLicenseCount) && Objects.equals(this.totalByolInstanceCount, other.totalByolInstanceCount) && Objects.equals(this.totalLicenseIncludedInstanceCount, other.totalLicenseIncludedInstanceCount) && Objects.equals(this.licenseRecordExpiringSoonCount, other.licenseRecordExpiringSoonCount) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.totalProductLicenseCount == null ? 43 : this.totalProductLicenseCount.hashCode());
        result = result * 59 + (this.totalByolInstanceCount == null ? 43 : this.totalByolInstanceCount.hashCode());
        result = result * 59 + (this.totalLicenseIncludedInstanceCount == null ? 43 : this.totalLicenseIncludedInstanceCount.hashCode());
        result = result * 59 + (this.licenseRecordExpiringSoonCount == null ? 43 : this.licenseRecordExpiringSoonCount.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="totalProductLicenseCount")
        private Integer totalProductLicenseCount;
        @JsonProperty(value="totalByolInstanceCount")
        private Integer totalByolInstanceCount;
        @JsonProperty(value="totalLicenseIncludedInstanceCount")
        private Integer totalLicenseIncludedInstanceCount;
        @JsonProperty(value="licenseRecordExpiringSoonCount")
        private Integer licenseRecordExpiringSoonCount;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder totalProductLicenseCount(Integer totalProductLicenseCount) {
            this.totalProductLicenseCount = totalProductLicenseCount;
            this.__explicitlySet__.add("totalProductLicenseCount");
            return this;
        }

        public Builder totalByolInstanceCount(Integer totalByolInstanceCount) {
            this.totalByolInstanceCount = totalByolInstanceCount;
            this.__explicitlySet__.add("totalByolInstanceCount");
            return this;
        }

        public Builder totalLicenseIncludedInstanceCount(Integer totalLicenseIncludedInstanceCount) {
            this.totalLicenseIncludedInstanceCount = totalLicenseIncludedInstanceCount;
            this.__explicitlySet__.add("totalLicenseIncludedInstanceCount");
            return this;
        }

        public Builder licenseRecordExpiringSoonCount(Integer licenseRecordExpiringSoonCount) {
            this.licenseRecordExpiringSoonCount = licenseRecordExpiringSoonCount;
            this.__explicitlySet__.add("licenseRecordExpiringSoonCount");
            return this;
        }

        public LicenseMetric build() {
            LicenseMetric model = new LicenseMetric(this.totalProductLicenseCount, this.totalByolInstanceCount, this.totalLicenseIncludedInstanceCount, this.licenseRecordExpiringSoonCount);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(LicenseMetric model) {
            if (model.wasPropertyExplicitlySet("totalProductLicenseCount")) {
                this.totalProductLicenseCount(model.getTotalProductLicenseCount());
            }
            if (model.wasPropertyExplicitlySet("totalByolInstanceCount")) {
                this.totalByolInstanceCount(model.getTotalByolInstanceCount());
            }
            if (model.wasPropertyExplicitlySet("totalLicenseIncludedInstanceCount")) {
                this.totalLicenseIncludedInstanceCount(model.getTotalLicenseIncludedInstanceCount());
            }
            if (model.wasPropertyExplicitlySet("licenseRecordExpiringSoonCount")) {
                this.licenseRecordExpiringSoonCount(model.getLicenseRecordExpiringSoonCount());
            }
            return this;
        }
    }
}

