/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.licensemanager.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.licensemanager.model.ResourceUnit;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class TopUtilizedResourceSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="resourceId")
    private final String resourceId;
    @JsonProperty(value="resourceName")
    private final String resourceName;
    @JsonProperty(value="resourceCompartmentId")
    private final String resourceCompartmentId;
    @JsonProperty(value="resourceCompartmentName")
    private final String resourceCompartmentName;
    @JsonProperty(value="totalUnits")
    private final Double totalUnits;
    @JsonProperty(value="unitType")
    private final ResourceUnit unitType;

    @Deprecated
    @ConstructorProperties(value={"resourceId", "resourceName", "resourceCompartmentId", "resourceCompartmentName", "totalUnits", "unitType"})
    public TopUtilizedResourceSummary(String resourceId, String resourceName, String resourceCompartmentId, String resourceCompartmentName, Double totalUnits, ResourceUnit unitType) {
        this.resourceId = resourceId;
        this.resourceName = resourceName;
        this.resourceCompartmentId = resourceCompartmentId;
        this.resourceCompartmentName = resourceCompartmentName;
        this.totalUnits = totalUnits;
        this.unitType = unitType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public String getResourceCompartmentId() {
        return this.resourceCompartmentId;
    }

    public String getResourceCompartmentName() {
        return this.resourceCompartmentName;
    }

    public Double getTotalUnits() {
        return this.totalUnits;
    }

    public ResourceUnit getUnitType() {
        return this.unitType;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("TopUtilizedResourceSummary(");
        sb.append("super=").append(super.toString());
        sb.append("resourceId=").append(String.valueOf(this.resourceId));
        sb.append(", resourceName=").append(String.valueOf(this.resourceName));
        sb.append(", resourceCompartmentId=").append(String.valueOf(this.resourceCompartmentId));
        sb.append(", resourceCompartmentName=").append(String.valueOf(this.resourceCompartmentName));
        sb.append(", totalUnits=").append(String.valueOf(this.totalUnits));
        sb.append(", unitType=").append(String.valueOf((Object)this.unitType));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TopUtilizedResourceSummary)) {
            return false;
        }
        TopUtilizedResourceSummary other = (TopUtilizedResourceSummary)((Object)o);
        return Objects.equals(this.resourceId, other.resourceId) && Objects.equals(this.resourceName, other.resourceName) && Objects.equals(this.resourceCompartmentId, other.resourceCompartmentId) && Objects.equals(this.resourceCompartmentName, other.resourceCompartmentName) && Objects.equals(this.totalUnits, other.totalUnits) && Objects.equals((Object)this.unitType, (Object)other.unitType) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.resourceId == null ? 43 : this.resourceId.hashCode());
        result = result * 59 + (this.resourceName == null ? 43 : this.resourceName.hashCode());
        result = result * 59 + (this.resourceCompartmentId == null ? 43 : this.resourceCompartmentId.hashCode());
        result = result * 59 + (this.resourceCompartmentName == null ? 43 : this.resourceCompartmentName.hashCode());
        result = result * 59 + (this.totalUnits == null ? 43 : this.totalUnits.hashCode());
        result = result * 59 + (this.unitType == null ? 43 : this.unitType.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="resourceId")
        private String resourceId;
        @JsonProperty(value="resourceName")
        private String resourceName;
        @JsonProperty(value="resourceCompartmentId")
        private String resourceCompartmentId;
        @JsonProperty(value="resourceCompartmentName")
        private String resourceCompartmentName;
        @JsonProperty(value="totalUnits")
        private Double totalUnits;
        @JsonProperty(value="unitType")
        private ResourceUnit unitType;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            this.__explicitlySet__.add("resourceId");
            return this;
        }

        public Builder resourceName(String resourceName) {
            this.resourceName = resourceName;
            this.__explicitlySet__.add("resourceName");
            return this;
        }

        public Builder resourceCompartmentId(String resourceCompartmentId) {
            this.resourceCompartmentId = resourceCompartmentId;
            this.__explicitlySet__.add("resourceCompartmentId");
            return this;
        }

        public Builder resourceCompartmentName(String resourceCompartmentName) {
            this.resourceCompartmentName = resourceCompartmentName;
            this.__explicitlySet__.add("resourceCompartmentName");
            return this;
        }

        public Builder totalUnits(Double totalUnits) {
            this.totalUnits = totalUnits;
            this.__explicitlySet__.add("totalUnits");
            return this;
        }

        public Builder unitType(ResourceUnit unitType) {
            this.unitType = unitType;
            this.__explicitlySet__.add("unitType");
            return this;
        }

        public TopUtilizedResourceSummary build() {
            TopUtilizedResourceSummary model = new TopUtilizedResourceSummary(this.resourceId, this.resourceName, this.resourceCompartmentId, this.resourceCompartmentName, this.totalUnits, this.unitType);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(TopUtilizedResourceSummary model) {
            if (model.wasPropertyExplicitlySet("resourceId")) {
                this.resourceId(model.getResourceId());
            }
            if (model.wasPropertyExplicitlySet("resourceName")) {
                this.resourceName(model.getResourceName());
            }
            if (model.wasPropertyExplicitlySet("resourceCompartmentId")) {
                this.resourceCompartmentId(model.getResourceCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("resourceCompartmentName")) {
                this.resourceCompartmentName(model.getResourceCompartmentName());
            }
            if (model.wasPropertyExplicitlySet("totalUnits")) {
                this.totalUnits(model.getTotalUnits());
            }
            if (model.wasPropertyExplicitlySet("unitType")) {
                this.unitType(model.getUnitType());
            }
            return this;
        }
    }
}

