/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.licensemanager;

import com.oracle.bmc.licensemanager.LicenseManager;
import com.oracle.bmc.licensemanager.model.LifeCycleState;
import com.oracle.bmc.licensemanager.requests.GetLicenseRecordRequest;
import com.oracle.bmc.licensemanager.requests.GetProductLicenseRequest;
import com.oracle.bmc.licensemanager.responses.GetLicenseRecordResponse;
import com.oracle.bmc.licensemanager.responses.GetProductLicenseResponse;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class LicenseManagerWaiters {
    private final ExecutorService executorService;
    private final LicenseManager client;

    public LicenseManagerWaiters(ExecutorService executorService, LicenseManager client) {
        this.executorService = executorService;
        this.client = client;
    }

    public Waiter<GetLicenseRecordRequest, GetLicenseRecordResponse> forLicenseRecord(GetLicenseRecordRequest request, LifeCycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forLicenseRecord(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetLicenseRecordRequest, GetLicenseRecordResponse> forLicenseRecord(GetLicenseRecordRequest request, LifeCycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forLicenseRecord(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetLicenseRecordRequest, GetLicenseRecordResponse> forLicenseRecord(GetLicenseRecordRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LifeCycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forLicenseRecord(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetLicenseRecordRequest, GetLicenseRecordResponse> forLicenseRecord(BmcGenericWaiter waiter, GetLicenseRecordRequest request, LifeCycleState ... targetStates) {
        final HashSet<LifeCycleState> targetStatesSet = new HashSet<LifeCycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetLicenseRecordRequest, GetLicenseRecordResponse>(){

            @Override
            public GetLicenseRecordResponse apply(GetLicenseRecordRequest request) {
                return LicenseManagerWaiters.this.client.getLicenseRecord(request);
            }
        }, (Predicate)new Predicate<GetLicenseRecordResponse>(){

            @Override
            public boolean test(GetLicenseRecordResponse response) {
                return targetStatesSet.contains((Object)response.getLicenseRecord().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)LifeCycleState.Deleted)), (Object)request);
    }

    public Waiter<GetProductLicenseRequest, GetProductLicenseResponse> forProductLicense(GetProductLicenseRequest request, LifeCycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forProductLicense(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetProductLicenseRequest, GetProductLicenseResponse> forProductLicense(GetProductLicenseRequest request, LifeCycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forProductLicense(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetProductLicenseRequest, GetProductLicenseResponse> forProductLicense(GetProductLicenseRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LifeCycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forProductLicense(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetProductLicenseRequest, GetProductLicenseResponse> forProductLicense(BmcGenericWaiter waiter, GetProductLicenseRequest request, LifeCycleState ... targetStates) {
        final HashSet<LifeCycleState> targetStatesSet = new HashSet<LifeCycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetProductLicenseRequest, GetProductLicenseResponse>(){

            @Override
            public GetProductLicenseResponse apply(GetProductLicenseRequest request) {
                return LicenseManagerWaiters.this.client.getProductLicense(request);
            }
        }, (Predicate)new Predicate<GetProductLicenseResponse>(){

            @Override
            public boolean test(GetProductLicenseResponse response) {
                return targetStatesSet.contains((Object)response.getProductLicense().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)LifeCycleState.Deleted)), (Object)request);
    }
}

