/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.licensemanager.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.licensemanager.model.LicenseUnit;
import com.oracle.bmc.licensemanager.model.Status;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class TopUtilizedProductLicenseSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="productLicenseId")
    private final String productLicenseId;
    @JsonProperty(value="productType")
    private final String productType;
    @JsonProperty(value="unitType")
    private final LicenseUnit unitType;
    @JsonProperty(value="totalUnitsConsumed")
    private final Double totalUnitsConsumed;
    @JsonProperty(value="totalLicenseUnitCount")
    private final Integer totalLicenseUnitCount;
    @JsonProperty(value="isUnlimited")
    private final Boolean isUnlimited;
    @JsonProperty(value="status")
    private final Status status;

    @Deprecated
    @ConstructorProperties(value={"productLicenseId", "productType", "unitType", "totalUnitsConsumed", "totalLicenseUnitCount", "isUnlimited", "status"})
    public TopUtilizedProductLicenseSummary(String productLicenseId, String productType, LicenseUnit unitType, Double totalUnitsConsumed, Integer totalLicenseUnitCount, Boolean isUnlimited, Status status) {
        this.productLicenseId = productLicenseId;
        this.productType = productType;
        this.unitType = unitType;
        this.totalUnitsConsumed = totalUnitsConsumed;
        this.totalLicenseUnitCount = totalLicenseUnitCount;
        this.isUnlimited = isUnlimited;
        this.status = status;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getProductLicenseId() {
        return this.productLicenseId;
    }

    public String getProductType() {
        return this.productType;
    }

    public LicenseUnit getUnitType() {
        return this.unitType;
    }

    public Double getTotalUnitsConsumed() {
        return this.totalUnitsConsumed;
    }

    public Integer getTotalLicenseUnitCount() {
        return this.totalLicenseUnitCount;
    }

    public Boolean getIsUnlimited() {
        return this.isUnlimited;
    }

    public Status getStatus() {
        return this.status;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("TopUtilizedProductLicenseSummary(");
        sb.append("super=").append(super.toString());
        sb.append("productLicenseId=").append(String.valueOf(this.productLicenseId));
        sb.append(", productType=").append(String.valueOf(this.productType));
        sb.append(", unitType=").append(String.valueOf((Object)this.unitType));
        sb.append(", totalUnitsConsumed=").append(String.valueOf(this.totalUnitsConsumed));
        sb.append(", totalLicenseUnitCount=").append(String.valueOf(this.totalLicenseUnitCount));
        sb.append(", isUnlimited=").append(String.valueOf(this.isUnlimited));
        sb.append(", status=").append(String.valueOf((Object)this.status));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TopUtilizedProductLicenseSummary)) {
            return false;
        }
        TopUtilizedProductLicenseSummary other = (TopUtilizedProductLicenseSummary)((Object)o);
        return Objects.equals(this.productLicenseId, other.productLicenseId) && Objects.equals(this.productType, other.productType) && Objects.equals((Object)this.unitType, (Object)other.unitType) && Objects.equals(this.totalUnitsConsumed, other.totalUnitsConsumed) && Objects.equals(this.totalLicenseUnitCount, other.totalLicenseUnitCount) && Objects.equals(this.isUnlimited, other.isUnlimited) && Objects.equals((Object)this.status, (Object)other.status) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.productLicenseId == null ? 43 : this.productLicenseId.hashCode());
        result = result * 59 + (this.productType == null ? 43 : this.productType.hashCode());
        result = result * 59 + (this.unitType == null ? 43 : this.unitType.hashCode());
        result = result * 59 + (this.totalUnitsConsumed == null ? 43 : this.totalUnitsConsumed.hashCode());
        result = result * 59 + (this.totalLicenseUnitCount == null ? 43 : this.totalLicenseUnitCount.hashCode());
        result = result * 59 + (this.isUnlimited == null ? 43 : this.isUnlimited.hashCode());
        result = result * 59 + (this.status == null ? 43 : this.status.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="productLicenseId")
        private String productLicenseId;
        @JsonProperty(value="productType")
        private String productType;
        @JsonProperty(value="unitType")
        private LicenseUnit unitType;
        @JsonProperty(value="totalUnitsConsumed")
        private Double totalUnitsConsumed;
        @JsonProperty(value="totalLicenseUnitCount")
        private Integer totalLicenseUnitCount;
        @JsonProperty(value="isUnlimited")
        private Boolean isUnlimited;
        @JsonProperty(value="status")
        private Status status;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder productLicenseId(String productLicenseId) {
            this.productLicenseId = productLicenseId;
            this.__explicitlySet__.add("productLicenseId");
            return this;
        }

        public Builder productType(String productType) {
            this.productType = productType;
            this.__explicitlySet__.add("productType");
            return this;
        }

        public Builder unitType(LicenseUnit unitType) {
            this.unitType = unitType;
            this.__explicitlySet__.add("unitType");
            return this;
        }

        public Builder totalUnitsConsumed(Double totalUnitsConsumed) {
            this.totalUnitsConsumed = totalUnitsConsumed;
            this.__explicitlySet__.add("totalUnitsConsumed");
            return this;
        }

        public Builder totalLicenseUnitCount(Integer totalLicenseUnitCount) {
            this.totalLicenseUnitCount = totalLicenseUnitCount;
            this.__explicitlySet__.add("totalLicenseUnitCount");
            return this;
        }

        public Builder isUnlimited(Boolean isUnlimited) {
            this.isUnlimited = isUnlimited;
            this.__explicitlySet__.add("isUnlimited");
            return this;
        }

        public Builder status(Status status) {
            this.status = status;
            this.__explicitlySet__.add("status");
            return this;
        }

        public TopUtilizedProductLicenseSummary build() {
            TopUtilizedProductLicenseSummary model = new TopUtilizedProductLicenseSummary(this.productLicenseId, this.productType, this.unitType, this.totalUnitsConsumed, this.totalLicenseUnitCount, this.isUnlimited, this.status);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(TopUtilizedProductLicenseSummary model) {
            if (model.wasPropertyExplicitlySet("productLicenseId")) {
                this.productLicenseId(model.getProductLicenseId());
            }
            if (model.wasPropertyExplicitlySet("productType")) {
                this.productType(model.getProductType());
            }
            if (model.wasPropertyExplicitlySet("unitType")) {
                this.unitType(model.getUnitType());
            }
            if (model.wasPropertyExplicitlySet("totalUnitsConsumed")) {
                this.totalUnitsConsumed(model.getTotalUnitsConsumed());
            }
            if (model.wasPropertyExplicitlySet("totalLicenseUnitCount")) {
                this.totalLicenseUnitCount(model.getTotalLicenseUnitCount());
            }
            if (model.wasPropertyExplicitlySet("isUnlimited")) {
                this.isUnlimited(model.getIsUnlimited());
            }
            if (model.wasPropertyExplicitlySet("status")) {
                this.status(model.getStatus());
            }
            return this;
        }
    }
}

