/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.licensemanager.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetLicenseRecordRequest
extends BmcRequest<Void> {
    private String licenseRecordId;
    private String opcRequestId;

    public String getLicenseRecordId() {
        return this.licenseRecordId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().licenseRecordId(this.licenseRecordId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",licenseRecordId=").append(String.valueOf(this.licenseRecordId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetLicenseRecordRequest)) {
            return false;
        }
        GetLicenseRecordRequest other = (GetLicenseRecordRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.licenseRecordId, other.licenseRecordId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.licenseRecordId == null ? 43 : this.licenseRecordId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetLicenseRecordRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String licenseRecordId = null;
        private String opcRequestId = null;

        public Builder licenseRecordId(String licenseRecordId) {
            this.licenseRecordId = licenseRecordId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetLicenseRecordRequest o) {
            this.licenseRecordId(o.getLicenseRecordId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetLicenseRecordRequest build() {
            GetLicenseRecordRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetLicenseRecordRequest buildWithoutInvocationCallback() {
            GetLicenseRecordRequest request = new GetLicenseRecordRequest();
            request.licenseRecordId = this.licenseRecordId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

