/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.licensemanager.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetProductLicenseRequest
extends BmcRequest<Void> {
    private String productLicenseId;
    private String opcRequestId;

    public String getProductLicenseId() {
        return this.productLicenseId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().productLicenseId(this.productLicenseId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",productLicenseId=").append(String.valueOf(this.productLicenseId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetProductLicenseRequest)) {
            return false;
        }
        GetProductLicenseRequest other = (GetProductLicenseRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.productLicenseId, other.productLicenseId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.productLicenseId == null ? 43 : this.productLicenseId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetProductLicenseRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String productLicenseId = null;
        private String opcRequestId = null;

        public Builder productLicenseId(String productLicenseId) {
            this.productLicenseId = productLicenseId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetProductLicenseRequest o) {
            this.productLicenseId(o.getProductLicenseId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetProductLicenseRequest build() {
            GetProductLicenseRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetProductLicenseRequest buildWithoutInvocationCallback() {
            GetProductLicenseRequest request = new GetProductLicenseRequest();
            request.productLicenseId = this.productLicenseId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

